package nashid.verify.sdk.data.repository

import android.content.Context
import com.google.mlkit.vision.text.Text.TextBlock
import nashid.verify.sdk.utils.Constants.PASSPORT_TD_3_LINE_1_REGEX
import nashid.verify.sdk.utils.Constants.PASSPORT_TD_3_LINE_2_REGEX
import nashid.verify.sdk.utils.ScanDocument
import nashid.verify.sdk.utils.Utility
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.replaceAlfaWithNumber
import nashid.verify.sdk.utils.helpers.OmanIdCardReaderHelper.Companion.replaceNumberWithAlfa
import nashid.verify.sdk.viewmodel.CameraXLiveData
import nashid.verify.sdkNew.R
import java.util.Objects
import java.util.regex.Pattern

class PassportRepository(
    private val cameraXLiveData: CameraXLiveData,
    private val scanDocument: ScanDocument,
    private val context: Context,
) {
    private var passportMRZ = ""
    private var name = ""

    fun readPassportData(blocks: List<TextBlock>) {
        if (Objects.requireNonNull<String?>(cameraXLiveData.getSelectedDoc().value).equals(
                context.getString(R.string.e_passport),
                ignoreCase = true,
            )
        ) {
            for (i in blocks.indices) {
                val lines = blocks[i].lines
                for (j in lines.indices) {
                    val elements = lines[j].elements
                    for (k in elements.indices) {
                        if (elements[k].text.length > 30) {
                            try {
                                val countrySubstring =
                                    elements[k].text.substring(
                                        10,
                                        13,
                                    ) // Adjust the indices based on the actual MRZ format
                                val newCountryCode =
                                    countrySubstring.replace(
                                        "0",
                                        "O",
                                    ) // Replace with the desired new country code
                                var modifiedMRZText =
                                    elements[k].text.replace(countrySubstring, newCountryCode)
                                modifiedMRZText = modifiedMRZText.replace("«", "<")
                                val patternPassportTD3Line2 =
                                    Pattern.compile(PASSPORT_TD_3_LINE_2_REGEX)
                                val patternPassportTD3Line1 =
                                    Pattern.compile(PASSPORT_TD_3_LINE_1_REGEX)
                                val matcherPassportTD3Line2 =
                                    patternPassportTD3Line2.matcher(modifiedMRZText)
                                val matcherPassportTD3Line1 =
                                    patternPassportTD3Line1.matcher(modifiedMRZText)
                                if (matcherPassportTD3Line2.find() && passportMRZ.isEmpty()) {
                                    passportMRZ = elements[k].text
                                    Utility.getInstance().mrzLine2 = passportMRZ.replace("«", "<")
                                }
                                if (matcherPassportTD3Line1.matches() && name.isEmpty()) {
                                    val latest = removeKValueFromString(modifiedMRZText)
                                    Utility.getInstance().mrzLine1 = latest
                                    name = latest.substring(5, latest.length - 1).replace("<", " ")
                                    Utility.getInstance().name = name.trim { it <= ' ' }
                                    Utility.getInstance().country = latest.substring(2, 5)
                                    Utility.getInstance().documentType = latest.substring(0, 1)
                                }
                            } catch (e: Exception) {
                                e.printStackTrace()
                            }
                        }
                    }
                }
            }
        }
    }

    fun readAllDetailOfPassport() =
        if (passportMRZ.isNotEmpty() && name.isNotEmpty()) {
            val line = passportMRZ
            var documentNumber = line.substring(0, 9)
            var nationality = line.substring(10, 13)
            var dateOfBirthDay = line.substring(13, 19)
            var gender = line.substring(20, 21)
            cameraXLiveData.setExpiryDate(line.substring(21, 27))
            nationality = replaceNumberWithAlfa(nationality)
            dateOfBirthDay = replaceAlfaWithNumber(dateOfBirthDay)
            gender = replaceNumberWithAlfa(gender)
            cameraXLiveData.setExpiryDate(
                replaceAlfaWithNumber(
                    cameraXLiveData.getExpiryDate().value.toString(),
                ),
            )
            documentNumber = documentNumber.replace("O", "0")
            if (documentNumber.isNotEmpty() &&
                dateOfBirthDay.isNotEmpty() &&
                cameraXLiveData.getExpiryDate().value!!.isNotEmpty() &&
                nationality.isNotEmpty() &&
                gender.isNotEmpty()
            ) {
                scanDocument.documentNo = documentNumber
                scanDocument.dateOfBirth = dateOfBirthDay
                scanDocument.expiryDate = cameraXLiveData.getExpiryDate().value
                Utility.getInstance().passportNumber = documentNumber
                Utility.getInstance().dateOfBirth = dateOfBirthDay
                Utility.getInstance().expiryDate = cameraXLiveData.getExpiryDate().value
                Utility.getInstance().nationality = nationality
                Utility.getInstance().gender = gender
                cameraXLiveData.setFlag(false)
                cameraXLiveData.setCloseAnalysisUseCase(true)
                cameraXLiveData.setIsSuccess(true)
                cameraXLiveData.setCaptureAnImage(true)
            } else {
                cameraXLiveData.setIsSuccess(false)
            }
        } else {
            cameraXLiveData.setIsSuccess(false)
        }

    private fun removeKValueFromString(modifiedMRZText: String): String {
        val latest = StringBuilder()
        for (l in modifiedMRZText.indices) {
            if (l != 0) {
                if (modifiedMRZText[l] == 'K') {
                    if (l == modifiedMRZText.length - 1) {
                        if (modifiedMRZText[l] != 'K') {
                            latest.append(modifiedMRZText[l])
                        }
                    } else {
                        if (modifiedMRZText[l - 1] != '<' &&
                            modifiedMRZText[l + 1] != '<'
                        ) {
                            latest.append(modifiedMRZText[l])
                        } else {
                            if (modifiedMRZText[l - 1] != '<' || modifiedMRZText[l + 1] != '<') {
                                latest.append(modifiedMRZText[l])
                            }
                        }
                    }
                } else {
                    latest.append(modifiedMRZText[l])
                }
            } else {
                latest.append(modifiedMRZText[l])
            }
        }
        return latest.toString().replace("\\bK+\\b".toRegex(), "")
    }
}
