package nashid.verify.sdk.utils

import android.util.Log

internal class OtherConstant {
    var needToShowResultScreen = false
    var skipNFC = false

    fun getEncodedString(unicodeString: String): String {
        val hexValues = unicodeString.split("\\\\u".toRegex()).drop(1)
        val decodedString = StringBuilder()

        for (hexValue in hexValues) {
            val codePoint = Integer.parseInt(hexValue, 16)
            decodedString.append(codePoint.toChar())
        }

        Log.d("TAG", "getEncodedString: " + decodedString.toString() + "---" + translateArabicToEnglish(decodedString.toString()))
        return decodedString.toString()
    }

    private fun translateArabicToEnglish(arabicText: String): String {
        val translationMap =
            mapOf(
                'ا' to 'a',
                'أ' to 'a',
                'إ' to 'a',
                'آ' to 'a',
                'ب' to 'b',
                'ت' to 't',
                'ث' to "th",
                'ج' to 'j',
                'ح' to 'h',
                'خ' to "kh",
                'د' to 'd',
                'ذ' to "dh",
                'ر' to 'r',
                'ز' to 'z',
                'س' to 's',
                'ش' to "sh",
                'ص' to 's',
                'ض' to 'd',
                'ط' to 't',
                'ظ' to 'z',
                'ع' to 'a',
                'غ' to "gh",
                'ف' to 'f',
                'ق' to 'q',
                'ك' to 'k',
                'ل' to 'l',
                'م' to 'm',
                'ن' to 'n',
                'ه' to 'h',
                'و' to 'w',
                'ي' to 'y',
                'ء' to 'a',
                'ة' to 'a',
            )
        val englishText = StringBuilder()

        for (char in arabicText) {
            val translatedChar = translationMap[char] ?: char
            englishText.append(translatedChar)
        }

        return englishText.toString()
    }

    companion object {
        @Volatile
        private var instance: OtherConstant? = null

        @JvmStatic
        fun getInstance(): OtherConstant =
            instance ?: synchronized(this) {
                instance ?: OtherConstant().also { instance = it }
            }
    }
}
