package nashid.verify.sdk.model

import com.google.gson.annotations.SerializedName

data class AuthResponse(
    @SerializedName("data")
    val data: AuthData,
    @SerializedName("message")
    val message: String? = null,
    @SerializedName("consolidated_message")
    val consolidatedMessage: String? = null,
    @SerializedName("details")
    val details: Map<String, String>? = null,
)

data class AuthData(
    @SerializedName("access_token")
    val accessToken: String,
    @SerializedName("refresh_token")
    val refreshToken: String,
    @SerializedName("access_token_expiry")
    val accessTokenExpiry: Double,
    @SerializedName("refresh_token_expiry")
    val refreshTokenExpiry: Double,
    @SerializedName("access_token_expire_at")
    val accessTokenExpireAt: Double,
    @SerializedName("refresh_token_expire_at")
    val refreshTokenExpireAt: Double,
    @SerializedName("sdk_config")
    val sdkConfig: SDKConfig,
    @SerializedName("type")
    val type: String,
)

data class SDKConfig(
    @SerializedName("id")
    val id: String,
    @SerializedName("created_at")
    val createdAt: String,
    @SerializedName("updated_at")
    val updatedAt: String,
    @SerializedName("name")
    val name: String,
    @SerializedName("description")
    val description: String,
    @SerializedName("is_active")
    val isActive: Boolean,
    @SerializedName("sandbox_sdk_key")
    val sandboxSdkKey: String,
    @SerializedName("sandbox_sdk_secret")
    val sandboxSdkSecret: String,
    @SerializedName("production_sdk_key")
    val productionSdkKey: String,
    @SerializedName("production_sdk_secret")
    val productionSdkSecret: String,
    @SerializedName("is_nfc_scanning_enabled")
    val isNfcScanningEnabled: Boolean,
    @SerializedName("is_nfc_multi_tries_enabled")
    val isNfcMultiTriesEnabled: Boolean,
    @SerializedName("nfc_multi_tries_max")
    val nfcMultiTriesMax: Int?,
    @SerializedName("is_face_matching_enabled")
    val isFaceMatchingEnabled: Boolean,
    @SerializedName("is_passive_liveness_enabled")
    val isPassiveLivenessEnabled: Boolean,
    @SerializedName("is_active_liveness_enabled")
    val isActiveLivenessEnabled: Boolean,
    @SerializedName("is_aml_check_enabled")
    val isAmlCheckEnabled: Boolean,
    @SerializedName("is_mala2aa_check_enabled")
    val isMala2aaCheckEnabled: Boolean,
    @SerializedName("is_rop_check_enabled")
    val isRopCheckEnabled: Boolean,
    @SerializedName("is_ocr_enabled")
    val isOcrEnabled: Boolean,
    @SerializedName("is_auto_crop_enabled")
    val isAutoCropEnabled: Boolean,
    @SerializedName("is_auto_alignment_enabled")
    val isAutoAlignmentEnabled: Boolean,
    @SerializedName("is_mrz_enabled")
    val isMrzEnabled: Boolean,
    @SerializedName("is_eligible_for_sdk")
    val isEligibleForSdk: Boolean,
    @SerializedName("is_eligible_for_app")
    val isEligibleForApp: Boolean,
    @SerializedName("callback_protocol")
    val callbackProtocol: String,
    @SerializedName("callback_host")
    val callbackHost: String,
    @SerializedName("is_success_callback_enabled")
    val isSuccessCallbackEnabled: Boolean,
    @SerializedName("success_callback_endpoint")
    val successCallbackEndpoint: String,
    @SerializedName("is_error_callback_enabled")
    val isErrorCallbackEnabled: Boolean,
    @SerializedName("error_callback_endpoint")
    val errorCallbackEndpoint: String,
    @SerializedName("show_instructions")
    val showInstructions: Boolean,
    @SerializedName("strict_mode")
    val strictMode: Boolean,
    @SerializedName("is_nfc_skippable")
    val isNfcSkippable: Boolean,
    @SerializedName("nfc_maximum_retries")
    val nfcMaximumRetries: Int?,
    @SerializedName("nfc_count_cancel_as_a_retry")
    val nfcCountCancelAsRetry: Boolean,
    @SerializedName("color_theme")
    val colorTheme: ColorTheme,
    @SerializedName("font_family")
    val fontFamily: FontFamily,
)

data class ColorTheme(
    @SerializedName("name")
    val name: String,
    @SerializedName("primary_color_code")
    val primaryColorCode: String,
    @SerializedName("secondary_color_code")
    val secondaryColorCode: String,
    @SerializedName("background_color_code")
    val backgroundColorCode: String,
)

data class FontFamily(
    @SerializedName("name")
    val name: String,
)
