package nashid.verify.sdk.ui

import android.content.Intent
import android.os.Bundle
import androidx.appcompat.app.AppCompatActivity
import com.airbnb.lottie.LottieAnimationView
import nashid.verify.sdk.ui.theme.FontManager
import nashid.verify.sdk.ui.theme.FontWeight
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdk.utils.helpers.EdgeToEdgeHelper
import nashid.verify.sdk.utils.helpers.TextSizeConverter
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.ActivityLivenessInstructionBinding
import org.koin.android.ext.android.inject
import kotlin.getValue

class LivenessInstructionActivity : AppCompatActivity() {
    private lateinit var binding: ActivityLivenessInstructionBinding
    private val textSizeConverter: TextSizeConverter by inject()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivityLivenessInstructionBinding.inflate(layoutInflater)
        setContentView(binding.root)

        textSizeConverter.changeStatusBarColor(this)
        EdgeToEdgeHelper.applySystemInsets(binding.root, applyTopInset = true, applyBottomInset = true)
        binding.lytMainInstrunction.setBackgroundColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
        binding.btnNext.setBackgroundColor(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        binding.btnNext.setTextColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
        binding.btnNext.typeface = FontManager.getFont(context = applicationContext, FontWeight.MEDIUM)

        val lottieView = findViewById<LottieAnimationView>(R.id.livenessAnimation)
        lottieView.setAnimation(R.raw.face_scan)
        lottieView.playAnimation()

        binding.btnNext.setOnClickListener {
            val intent = Intent(this, SkipNfcLiveNessActivity::class.java)
            val docKey = getString(R.string.doc_key)
            val docType = intent.getStringExtra(docKey)
            if (docType != null) {
                intent.putExtra(docKey, docType)
            }
            startActivity(intent)
            finish()
        }
    }
}
