package nashid.verify.sdk.utils

import android.graphics.Bitmap

object LightDetector {
    init {
        System.loadLibrary("engine")
    }

    external fun analyzeImageLight(bitmap: Bitmap): DoubleArray

    data class Result(
        val avgBrightness: Double,
        val darkRatio: Double,
        val brightRatio: Double,
        val sharpness: Double,
        val brightnessEV: Double,
    )

    fun analyze(bitmap: Bitmap): Result {
        val result = analyzeImageLight(bitmap)
        return Result(
            avgBrightness = result[0],
            darkRatio = result[1],
            brightRatio = result[2],
            sharpness = result[3],
            brightnessEV = result[4],
        )
    }
}
