package nashid.verify.sdk.utils

import nashid.verify.sdk.model.DocumentType
import nashid.verify.sdk.model.ExtraData
import nashid.verify.sdk.model.SDKStatus
import nashid.verify.sdk.model.VerifySdkEnvironment
import nashid.verify.sdk.ui.theme.AppTheme
import nashid.verify.sdk.utils.Constants.APP_KEY_PRODUCTION
import nashid.verify.sdk.utils.Constants.APP_KEY_QA
import nashid.verify.sdk.utils.Constants.APP_KEY_STAGING
import nashid.verify.sdk.utils.Constants.BASE_URL_PRODUCTION
import nashid.verify.sdk.utils.Constants.BASE_URL_QA
import nashid.verify.sdk.utils.Constants.BASE_URL_STAGING

object SdkConfig {
    private val appTheme =
        AppTheme(
            primaryColor = "#101738",
            secondaryColor = "#F08651",
            backgroundColor = "#FFFFFF",
            headerColor = "#000000",
        )

    var selectedEnvironment: VerifySdkEnvironment = VerifySdkEnvironment.Production
    var baseUrl: String = BASE_URL_PRODUCTION
    var appKey: String = APP_KEY_PRODUCTION

    var sandboxSdkKey: String? = null
    var sandboxSdkSecret: String? = null
    var sandboxLanguageType: String? = null
    var name: String? = null
    var description: String? = null
    var isNfcScanningEnabled: Boolean = false
    var isFaceMatchingEnabled: Boolean = false
    var isActiveLiveNessEnabled: Boolean = false
    var isPassiveLiveNessEnabled: Boolean = false
    var isOcrEnabled: Boolean = false
    var isMrzEnabled: Boolean = false
    var callbackProtocol: String? = null
    var callbackHost: String? = null
    var showInstruction: Boolean = false
    var viewType: DocumentType = DocumentType.OMAN_ID
    var isNfcSkipable: Boolean? = false
    var nfcMaximumRetries: Int? = null
    var registerToken: String? = null
    var sdkStatus: SDKStatus = SDKStatus.NOT_INITIALIZED
    var isExtraData: ExtraData? = null
    var ipv4: String? = null
    var ipv6: String? = null
    var sdkAppTheme: AppTheme = appTheme
    var fontName: String = "ping ar"
    var isNfcCountCancelAsRetry: Boolean? = false

    fun updateConfig(
        sdkKey: String?,
        sdkSecret: String?,
        languageType: String?,
        sdkName: String?,
        sdkDescription: String?,
        nfcScanningEnabled: Boolean,
        faceMatchingEnabled: Boolean,
        activeLiveNessEnabled: Boolean,
        passiveLiveNessEnabled: Boolean,
        ocrEnabled: Boolean,
        mrzEnabled: Boolean,
        protocol: String?,
        host: String?,
        instructionsVisible: Boolean,
        nfcSkippable: Boolean,
        nfcRetries: Int,
        nfcCountCancelAsRetry: Boolean,
        appTheme: AppTheme,
        fontName: String,
        extraData: ExtraData?,
    ) {
        sandboxSdkKey = sdkKey
        sandboxSdkSecret = sdkSecret
        sandboxLanguageType = languageType
        name = sdkName
        description = sdkDescription
        isNfcScanningEnabled = nfcScanningEnabled
        isFaceMatchingEnabled = faceMatchingEnabled
        isActiveLiveNessEnabled = activeLiveNessEnabled
        isPassiveLiveNessEnabled = passiveLiveNessEnabled
        isOcrEnabled = ocrEnabled
        isMrzEnabled = mrzEnabled
        callbackProtocol = protocol
        callbackHost = host
        showInstruction = instructionsVisible
        isNfcSkipable = nfcSkippable
        nfcMaximumRetries = nfcRetries
        sdkStatus = SDKStatus.INITIALIZED
        sdkAppTheme = appTheme
        isNfcCountCancelAsRetry = nfcCountCancelAsRetry
        SdkConfig.fontName = fontName
        isExtraData = extraData
    }

    fun updateEnvironmentConfig(env: VerifySdkEnvironment) {
        selectedEnvironment = env
        when (env) {
            VerifySdkEnvironment.Production -> {
                baseUrl = BASE_URL_PRODUCTION
                appKey = APP_KEY_PRODUCTION
            }
            VerifySdkEnvironment.QA -> {
                baseUrl = BASE_URL_QA
                appKey = APP_KEY_QA
            }
            VerifySdkEnvironment.Staging -> {
                baseUrl = BASE_URL_STAGING
                appKey = APP_KEY_STAGING
            }
        }
    }

    fun clear() {
        sandboxSdkKey = null
        sandboxSdkSecret = null
        sandboxLanguageType = null
        name = null
        description = null
        isNfcScanningEnabled = false
        isFaceMatchingEnabled = false
        isPassiveLiveNessEnabled = false
        isOcrEnabled = false
        isMrzEnabled = false
        callbackProtocol = null
        callbackHost = null
        showInstruction = false
        viewType = DocumentType.OMAN_ID
        isNfcSkipable = false
        nfcMaximumRetries = null
        registerToken = null
        sdkStatus = SDKStatus.NOT_INITIALIZED
        isExtraData = null
        ipv4 = null
        ipv6 = null
    }
}
