package nashid.verify.sdk.utils.helpers

import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.graphics.Color
import android.graphics.drawable.ColorDrawable
import android.net.ConnectivityManager
import android.net.Network
import android.net.NetworkCapabilities
import android.net.NetworkRequest
import android.util.Log
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.view.Window
import android.widget.LinearLayout
import androidx.fragment.app.FragmentActivity
import nashid.verify.sdk.Generated
import nashid.verify.sdk.utils.OnInternetAvailabilityListener
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.DialogNoInternetBinding

class ErrorUtility private constructor() {
    companion object {
        private val errorUtility = ErrorUtility()
        private const val TAG = "ErrorUtility"

        fun getInstance(): ErrorUtility = errorUtility
    }

    private var onInternetAvailabilityListener: OnInternetAvailabilityListener? = null
    private var isNetworkAvailable = false
    private var textSizeConverter: TextSizeConverter? = null
    private var dialog: Dialog? = null
    private var activeActivities = 0
    private var conMgr: ConnectivityManager? = null

    @Generated
    fun showNoInternetDialog(
        activity: FragmentActivity,
        isActivityRunning: Boolean,
    ) {
        activity.runOnUiThread {
            if (isActivityRunning) {
                textSizeConverter = TextSizeConverter(activity)
                dialog =
                    Dialog(activity).apply {
                        requestWindowFeature(Window.FEATURE_NO_TITLE)
                        val binding = DialogNoInternetBinding.inflate(layoutInflater)
                        setContentView(binding.root)

                        binding.imgScanFailure.setAnimation(R.raw.failure)
                        binding.btnRetry.visibility = View.VISIBLE

                        val padding = textSizeConverter!!.getPaddingOrMarginValue(16)
                        binding.mainDialogLyt.setPadding(padding, padding, padding, padding)

                        binding.imgScanFailure.layoutParams =
                            binding.imgScanFailure.layoutParams.apply {
                                width = textSizeConverter!!.getWidth(56)
                                height = textSizeConverter!!.getHeight(56)
                            }

                        (binding.imgScanFailure.layoutParams as LinearLayout.LayoutParams).apply {
                            setMargins(0, textSizeConverter!!.getPaddingOrMarginValue(8), 0, 0)
                        }

                        binding.txtScanCompleted.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter!!.getTextSize(18).toFloat())
                        binding.txtScanCompleted.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
                        (binding.txtScanCompleted.layoutParams as LinearLayout.LayoutParams).apply {
                            setMargins(0, textSizeConverter!!.getPaddingOrMarginValue(24), 0, textSizeConverter!!.getPaddingOrMarginValue(24))
                        }
                        binding.btnRetry.setCardBackgroundColor(SdkConfig.sdkAppTheme.getPrimaryColorInt())
                        binding.txtBtnRetry.setTextColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
                        binding.txtBtnRetry.setPadding(0, textSizeConverter!!.getPaddingOrMarginValue(12), 0, textSizeConverter!!.getPaddingOrMarginValue(12))
                        binding.txtBtnRetry.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter!!.getTextSize(16).toFloat())
                        binding.btnRetry.radius = textSizeConverter!!.calculateRadius(8).toFloat()

                        binding.btnRetry.setOnClickListener {
                            if (isNetworkAvailable) {
                                dismiss()
                            }
                        }

                        show()
                        setCancelable(false)
                        window?.apply {
                            setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
                            setBackgroundDrawable(ColorDrawable(Color.TRANSPARENT))
                            attributes.windowAnimations = R.style.DialogAnimation
                            setGravity(Gravity.BOTTOM)
                        }
                    }
            }
        }
    }

    fun registerConnectivityManager(
        activity: Activity,
        onInternetAvailabilityListener: OnInternetAvailabilityListener,
    ): Boolean {
        Log.d(TAG, "registerConnectivityManager: ${activity.localClassName}")
        this.onInternetAvailabilityListener = onInternetAvailabilityListener

        if (activeActivities == 0) {
            conMgr = activity.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
            val networkRequest =
                NetworkRequest
                    .Builder()
                    .addCapability(NetworkCapabilities.NET_CAPABILITY_INTERNET)
                    .addTransportType(NetworkCapabilities.TRANSPORT_WIFI)
                    .addTransportType(NetworkCapabilities.TRANSPORT_CELLULAR)
                    .build()
            conMgr?.requestNetwork(networkRequest, networkCallback)
        }
        activeActivities++

        val netInfo = conMgr?.activeNetworkInfo
        return netInfo != null && netInfo.isConnectedOrConnecting && netInfo.isAvailable
    }

    private val networkCallback =
        object : ConnectivityManager.NetworkCallback() {
            override fun onAvailable(network: Network) {
                super.onAvailable(network)
                if (!isNetworkAvailable) {
                    Log.d(TAG, "onAvailable: connection available")
                    isNetworkAvailable = true
                    onInternetAvailabilityListener?.onAvailable()
                    dialog?.dismiss()
                }
            }

            override fun onLost(network: Network) {
                super.onLost(network)
                if (isNetworkAvailable) {
                    isNetworkAvailable = false
                    Log.d(TAG, "onLost: connection lost")
                    onInternetAvailabilityListener?.onLost()
                }
            }
        }

    fun unregisterConnectivityManager(activity: Activity) {
        activeActivities--
        if (activeActivities == 0) {
            Log.d(TAG, "unregisterConnectivityManager: ${activity.localClassName}")
            (activity.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager)
                .unregisterNetworkCallback(networkCallback)
        }
    }
}
