package nashid.verify.sdk.utils.helpers

import android.content.Context
import android.graphics.Color
import android.util.TypedValue
import android.view.View.GONE
import android.view.ViewTreeObserver
import android.widget.LinearLayout
import android.widget.RelativeLayout
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.ActivityCameraXliveAcitivityBinding

class LayoutAndTextSizeConfigurator(
    private val context: Context,
    private val binding: ActivityCameraXliveAcitivityBinding,
    private val textSizeConverter: TextSizeConverter,
) {
    fun configureLayoutAndTextSize() {
        textSizeConverter.let { textSizeConverter ->
            binding.layoutHeader.imgBack.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.statusTxt.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(18).toFloat())
            binding.statusTxtInstruction.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16).toFloat())
            binding.txtBottom.setTextSize(TypedValue.COMPLEX_UNIT_PX, textSizeConverter.getTextSize(16).toFloat())
            var layoutParams2 = binding.layoutHeader.imgBack.layoutParams
            layoutParams2.width = textSizeConverter.getWidth(24)
            layoutParams2.height = textSizeConverter.getHeight(24)
            binding.layoutHeader.imgBack.layoutParams = layoutParams2
            layoutParams2 = binding.layoutStepMain.lytStep.layoutParams
            layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
            layoutParams2.height = textSizeConverter.getHeight(26)
            binding.layoutStepMain.lytStep.layoutParams = layoutParams2
            binding.layoutHeader.txtHelp.text = context.getString(R.string.header_doc_scan)
            binding.layoutHeader.txtHelp.setTextColor(Color.WHITE)
            binding.layoutHeader.txtHelp.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(17).toFloat(),
            )
            binding.txtGlare.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            var padding = textSizeConverter.getPaddingOrMarginValue(16)
            binding.layoutParentHeader.setPadding(padding, padding, padding, padding)
            val padding1 = textSizeConverter.getPaddingOrMarginValue(4)
            binding.txtGlare.setPadding(padding1, padding1, padding1, padding1)
            val layoutParams = textSizeConverter.getLinearLayoutParam()
            layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(4), 0, 0)
            binding.layoutHeader.lytHeaderMain.layoutParams = layoutParams
            val scanInstruction =
                RelativeLayout.LayoutParams(
                    RelativeLayout.LayoutParams.MATCH_PARENT,
                    RelativeLayout.LayoutParams.WRAP_CONTENT,
                )
            scanInstruction.addRule(RelativeLayout.CENTER_IN_PARENT, RelativeLayout.TRUE)
            scanInstruction.setMargins(
                textSizeConverter.getPaddingOrMarginValue(40),
                0,
                textSizeConverter.getPaddingOrMarginValue(40),
                0,
            )
            binding.lytScanInstruction.layoutParams = scanInstruction
            var marginLayoutParam =
                binding.layoutStepMain.lytStep.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
            binding.layoutStepMain.lytStep.layoutParams = marginLayoutParam
            val stepIconSize = 22
            var stepLayoutParam = binding.layoutStepMain.imgBack1.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
            stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
            binding.layoutStepMain.imgBack1.layoutParams = stepLayoutParam
            stepLayoutParam = binding.layoutStepMain.imgBack2.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
            stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
            binding.layoutStepMain.imgBack2.layoutParams = stepLayoutParam
            stepLayoutParam = binding.layoutStepMain.imgBack3.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
            stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
            binding.layoutStepMain.imgBack3.layoutParams = stepLayoutParam
            binding.statusTxt.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )

            binding.layoutStepMain.imgBack1.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.layoutStepMain.imgForeground2.visibility = GONE
            binding.layoutStepMain.imgForeground3.visibility = GONE

            marginLayoutParam = binding.statusTxt.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
            binding.statusTxt.layoutParams = marginLayoutParam
            marginLayoutParam = binding.lytBottom.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingOrMarginValue(26))
            binding.lytBottom.layoutParams = marginLayoutParam
            stepLayoutParam = binding.imgBottom.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(16)
            stepLayoutParam.height = textSizeConverter.getHeight(16)
            binding.imgBottom.layoutParams = stepLayoutParam
            binding.imgBottom.setImageResource(R.drawable.scan_bottom)
            binding.imgBottom.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.txtBottom.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(14).toFloat(),
            )
            binding.imgScanComplete.layoutParams.width = textSizeConverter.getWidth(56)
            binding.imgScanComplete.layoutParams.height = textSizeConverter.getHeight(56)
            binding.imgScanComplete.invalidate()
            binding.imgScanComplete.setAnimation(R.raw.scan_completed)
            marginLayoutParam = binding.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
            binding.txtScanCompleted.layoutParams = marginLayoutParam
            binding.txtScanCompleted.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(20).toFloat(),
            )
            layoutParams2 = binding.imgScanFail.layoutParams
            layoutParams2.width = textSizeConverter.getWidth(56)
            layoutParams2.height = textSizeConverter.getHeight(56)
            binding.imgScanFail.layoutParams = layoutParams2
            binding.txtScanInstruction.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            marginLayoutParam = binding.txtScanFail.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
            binding.txtScanFail.layoutParams = marginLayoutParam
            binding.txtScanFail.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(20).toFloat(),
            )
            marginLayoutParam =
                binding.btnRescanningDocuments.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                textSizeConverter.getPaddingOrMarginValue(16),
                0,
                textSizeConverter.getPaddingOrMarginValue(16),
                textSizeConverter.getPaddingOrMarginValue(44),
            )
            binding.btnRescanningDocuments.layoutParams = marginLayoutParam
            binding.btnRescanningDocuments.setCardBackgroundColor(SdkConfig.sdkAppTheme.getBackgroundColorInt())
            padding = textSizeConverter.getPaddingOrMarginValue(12)
            binding.txtRescanningDocuments.setTextColor(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.txtRescanningDocuments.setPadding(0, padding, 0, padding)
            binding.txtScanInstruction.setPadding(
                textSizeConverter.getPaddingOrMarginValue(34),
                padding,
                textSizeConverter.getPaddingOrMarginValue(34),
                padding,
            )
            binding.txtRescanningDocuments.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            binding.btnRescanningDocuments.radius = textSizeConverter.calculateRadius(8).toFloat()
            binding.cardInstruction.radius = textSizeConverter.calculateRadius(4).toFloat()
            stepLayoutParam = binding.imgError1.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(14)
            stepLayoutParam.height = textSizeConverter.getHeight(14)
            binding.imgError1.layoutParams = stepLayoutParam
            stepLayoutParam = binding.imgError2.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(14)
            stepLayoutParam.height = textSizeConverter.getHeight(14)
            binding.imgError2.layoutParams = stepLayoutParam
            stepLayoutParam = binding.imgError3.layoutParams
            stepLayoutParam.width = textSizeConverter.getWidth(14)
            stepLayoutParam.height = textSizeConverter.getHeight(14)
            binding.imgError3.layoutParams = stepLayoutParam
            marginLayoutParam = binding.imgError1.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(textSizeConverter.getPaddingOrMarginValue(28), 0, 0, 0)
            binding.imgError1.layoutParams = marginLayoutParam
            marginLayoutParam = binding.imgError2.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(textSizeConverter.getPaddingOrMarginValue(28), 0, 0, 0)
            binding.imgError2.layoutParams = marginLayoutParam
            marginLayoutParam = binding.imgError3.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(textSizeConverter.getPaddingOrMarginValue(28), 0, 0, 0)
            binding.imgError3.layoutParams = marginLayoutParam
            marginLayoutParam = binding.lytError1.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(76), 0, 0)

            binding.imgError1.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.imgError2.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
            binding.imgError3.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())

            binding.lytError1.layoutParams = marginLayoutParam
            marginLayoutParam = binding.lytError2.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(
                0,
                textSizeConverter.getPaddingOrMarginValue(20),
                0,
                textSizeConverter.getPaddingOrMarginValue(20),
            )
            binding.lytError2.layoutParams = marginLayoutParam
            marginLayoutParam = binding.lytError3.layoutParams as LinearLayout.LayoutParams
            marginLayoutParam.setMargins(0, 0, 0, textSizeConverter.getPaddingOrMarginValue(70))
            binding.lytError3.layoutParams = marginLayoutParam
            binding.txtError1.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            binding.txtError2.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            binding.txtError3.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(16).toFloat(),
            )
            binding.txtError1.setPadding(textSizeConverter.getPaddingOrMarginValue(6), 0, 0, 0)
            binding.txtError2.setPadding(textSizeConverter.getPaddingOrMarginValue(6), 0, 0, 0)
            binding.txtError3.setPadding(textSizeConverter.getPaddingOrMarginValue(6), 0, 0, 0)
            binding.imgError1.setImageResource(R.drawable.scan_bottom)
            binding.imgError2.setImageResource(R.drawable.scan_bottom)
            binding.imgError3.setImageResource(R.drawable.scan_bottom)
            binding.txtTurnDoc.setTextSize(
                TypedValue.COMPLEX_UNIT_PX,
                textSizeConverter.getTextSize(20).toFloat(),
            )

            binding.imgBackcrdScan.viewTreeObserver.addOnPreDrawListener(
                object : ViewTreeObserver.OnPreDrawListener {
                    override fun onPreDraw(): Boolean {
                        val height = binding.imgBackcrdScan.height
                        binding.imgBackcrdScan.viewTreeObserver.removeOnPreDrawListener(this)
                        val updatedMarginLayoutParams =
                            binding.txtTurnDoc.layoutParams as RelativeLayout.LayoutParams
                        updatedMarginLayoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(-(height / 12)), 0, 0)
                        binding.txtTurnDoc.layoutParams = updatedMarginLayoutParams
                        return true
                    }
                },
            )
        }
    }
}
