package nashid.verify.sdk.utils.helpers

import android.app.Activity
import android.content.Context
import android.graphics.Color
import android.graphics.Rect
import android.graphics.RectF
import android.hardware.camera2.CameraCharacteristics
import android.hardware.camera2.CameraManager
import android.os.Build
import android.util.TypedValue
import android.view.View.GONE
import android.widget.LinearLayout
import android.widget.RelativeLayout
import androidx.camera.core.ImageProxy
import androidx.core.content.ContextCompat
import nashid.verify.sdk.Generated
import nashid.verify.sdk.utils.SdkConfig
import nashid.verify.sdkNew.R
import nashid.verify.sdkNew.databinding.LivenessActivityMainBinding
import java.nio.ReadOnlyBufferException
import kotlin.experimental.inv

class LiveNessCameraLayout(
    private val activity: Activity,
    private val binding: LivenessActivityMainBinding,
    private val storage: Storage,
    private val textSizeConverter: TextSizeConverter,
) {
    @Generated
    fun changeTextSize() {
        if (!SdkConfig.isNfcScanningEnabled) {
            binding.layoutStepMain.viewStep2Divider.visibility = GONE
            binding.layoutStepMain.imgBack3.visibility = GONE
            binding.layoutStepMain.imgForeground3.visibility = GONE
        }

        // Use EdgeToEdgeHelper for proper Android 15+ edge-to-edge handling with theme color status bar
        val statusBarColor = SdkConfig.sdkAppTheme.getBackgroundColorInt()
        EdgeToEdgeHelper.setupEdgeToEdgeWithStatusBar(activity, statusBarColor)
        var layoutParams2 = binding.layoutHeader.imgBack.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(24)
        layoutParams2.height = textSizeConverter.getHeight(24)
        binding.layoutHeader.imgBack.layoutParams = layoutParams2
        binding.layoutHeader.imgBack.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        binding.layoutHeader.txtHelp.text = activity.getString(R.string.header_doc_scan)
        binding.layoutHeader.txtHelp.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(17).toFloat(),
        )
        binding.layoutHeader.imgBack.setImageResource(R.drawable.back_white)
        if (storage.getPreferredLocale().equals("ar", ignoreCase = true)) {
            binding.layoutHeader.imgBack.rotation = 180F
        }
        binding.layoutHeader.txtHelp.setText(R.string.face_header)
        binding.layoutHeader.txtHelp.setTextColor(Color.WHITE)
        val layoutParams = textSizeConverter.getLinearLayoutParam()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.R) {
            layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(4), 0, 0)
        } else {
            layoutParams.setMargins(0, textSizeConverter.getPaddingOrMarginValue(42), 0, 0)
        }
        binding.layoutHeader.lytHeaderMain.layoutParams = layoutParams

        layoutParams2 = binding.layoutStepMain.lytStep.layoutParams
        layoutParams2.width = LinearLayout.LayoutParams.MATCH_PARENT
        layoutParams2.height = textSizeConverter.getHeight(26)
        binding.layoutStepMain.lytStep.layoutParams = layoutParams2
        var marginLayoutParam =
            binding.layoutStepMain.lytStep.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, 0)
        binding.layoutStepMain.lytStep.layoutParams = marginLayoutParam

        var padding = textSizeConverter.getPaddingOrMarginValue(16)
        binding.lytTopView.setPadding(padding, padding, padding, 0)
        binding.lytBottomMain.setPadding(padding, 0, padding, padding)

        val stepIconSize = 22
        var stepLayoutParam = binding.layoutStepMain.imgBack1.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack1.layoutParams = stepLayoutParam

        stepLayoutParam = binding.layoutStepMain.imgBack2.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack2.layoutParams = stepLayoutParam

        stepLayoutParam = binding.layoutStepMain.imgBack3.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(stepIconSize)
        stepLayoutParam.height = textSizeConverter.getHeight(stepIconSize)
        binding.layoutStepMain.imgBack3.layoutParams = stepLayoutParam

        binding.txtTakeSelfie.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(18).toFloat(),
        )

        marginLayoutParam = binding.txtTakeSelfie.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(20), 0, 0)
        binding.txtTakeSelfie.layoutParams = marginLayoutParam

        val marginLayoutParam1 = binding.cardStartDesc.layoutParams as RelativeLayout.LayoutParams
        marginLayoutParam1.setMargins(textSizeConverter.getPaddingOrMarginValue(34), 0, textSizeConverter.getPaddingOrMarginValue(34), 0)
        binding.cardStartDesc.layoutParams = marginLayoutParam1

        var color = SdkConfig.sdkAppTheme.getBackgroundColorInt()
        var colorWithAlpha = androidx.core.graphics.ColorUtils.setAlphaComponent(color, (0.9 * 255).toInt())
        binding.cardStartDesc.setCardBackgroundColor(colorWithAlpha)
        binding.txtStartRecording.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
        binding.txtStartRecordingDesc2.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())

        binding.txtStartRecording.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )

        binding.txtStartRecordingDesc2.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.imgStartRecording.setImageResource(R.drawable.start_recording)
        binding.imgStartRecording.setColorFilter(
            SdkConfig.sdkAppTheme.getBackgroundColorInt(),
            android.graphics.PorterDuff.Mode.SRC_IN,
        )
        marginLayoutParam = binding.imgStartRecording.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(16), 0, textSizeConverter.getPaddingOrMarginValue(16))
        binding.imgStartRecording.layoutParams = marginLayoutParam

        stepLayoutParam = binding.imgStartRecording.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(74)
        stepLayoutParam.height = textSizeConverter.getHeight(74)
        binding.imgStartRecording.layoutParams = stepLayoutParam

        stepLayoutParam = binding.layoutStepMain.viewStep2Divider.layoutParams
        stepLayoutParam.width = LinearLayout.LayoutParams.MATCH_PARENT
        stepLayoutParam.height = textSizeConverter.getHeight(2)
        binding.layoutStepMain.viewStep2Divider.layoutParams = stepLayoutParam

        binding.layoutStepMain.imgBack1.setImageResource(R.drawable.ic_circle)
        binding.layoutStepMain.imgBack2.setImageResource(R.drawable.ic_circle)
        binding.layoutStepMain.imgBack3.setImageResource(R.drawable.ic_circle)

        binding.layoutStepMain.imgForeground1.setImageResource(R.drawable.complete_step1)
        if (SdkConfig.isNfcScanningEnabled) {
            binding.layoutStepMain.imgForeground2.setImageResource(R.drawable.complete_step1)
        }
        binding.layoutStepMain.imgForeground3.setImageResource(R.drawable.ic_foreground_path3)

        binding.layoutStepMain.imgBack1.setColorFilter(SdkConfig.sdkAppTheme.getSecondaryColorInt())
        if (!SdkConfig.isNfcScanningEnabled) {
            binding.layoutStepMain.imgBack2.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())
        } else {
            binding.layoutStepMain.imgBack2.setColorFilter(SdkConfig.sdkAppTheme.getSecondaryColorInt())
        }
        binding.layoutStepMain.imgBack3.setColorFilter(SdkConfig.sdkAppTheme.getPrimaryColorInt())

        binding.layoutStepMain.viewStep2Divider.setBackgroundResource(R.drawable.gradient_straight_line)
        binding.layoutStepMain.viewStep1Divider.background =
            ContextCompat.getDrawable(
                activity,
                R.drawable.complete_straight_line,
            )

        binding.txtPressDesc.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.txtPressDesc.setPadding(
            textSizeConverter.getPaddingOrMarginValue(4),
            textSizeConverter.getPaddingOrMarginValue(12),
            textSizeConverter.getPaddingOrMarginValue(4),
            textSizeConverter.getPaddingOrMarginValue(12),
        )
        binding.cardPressDesc.radius = textSizeConverter.calculateRadius(4).toFloat()
        binding.cardStartDesc.radius = textSizeConverter.calculateRadius(4).toFloat()

        binding.txtScanCompleted.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20).toFloat(),
        )
        marginLayoutParam = binding.txtScanCompleted.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(
            0,
            textSizeConverter.getPaddingOrMarginValue(24),
            0,
            0,
        )
        binding.txtScanCompleted.layoutParams = marginLayoutParam
        stepLayoutParam = binding.imgScanComplete.layoutParams
        stepLayoutParam.width = textSizeConverter.getWidth(56)
        stepLayoutParam.height = textSizeConverter.getHeight(56)
        binding.imgScanComplete.layoutParams = stepLayoutParam
        binding.imgScanComplete.setAnimation(R.raw.scan_completed)
        binding.overlayMainLayout.setBackgroundColor(
            ContextCompat.getColor(
                activity,
                R.color.transparent,
            ),
        )
        color = SdkConfig.sdkAppTheme.getBackgroundColorInt()
        colorWithAlpha = androidx.core.graphics.ColorUtils.setAlphaComponent(color, (0.5 * 255).toInt())
        binding.lytTopView.setBackgroundColor(colorWithAlpha)
        binding.lytBottomMain.setBackgroundColor(colorWithAlpha)
        binding.lyoutScanFail.setBackgroundColor(colorWithAlpha)

        layoutParams2 = binding.imgScanFail.layoutParams
        layoutParams2.width = textSizeConverter.getWidth(56)
        layoutParams2.height = textSizeConverter.getHeight(56)
        binding.imgScanFail.layoutParams = layoutParams2

        marginLayoutParam = binding.txtScanFail.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(0, textSizeConverter.getPaddingOrMarginValue(24), 0, 0)
        binding.txtScanFail.layoutParams = marginLayoutParam
        binding.txtScanFail.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(20).toFloat(),
        )

        marginLayoutParam = binding.btnRescanningDocuments.layoutParams as LinearLayout.LayoutParams
        marginLayoutParam.setMargins(
            textSizeConverter.getPaddingOrMarginValue(16),
            0,
            textSizeConverter.getPaddingOrMarginValue(16),
            textSizeConverter.getPaddingOrMarginValue(44),
        )
        binding.btnRescanningDocuments.layoutParams = marginLayoutParam

        padding = textSizeConverter.getPaddingOrMarginValue(12)
        binding.txtRescanningDocuments.setPadding(0, padding, 0, padding)
        binding.txtRescanningDocuments.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.txtRescanningDocuments.setTextColor(SdkConfig.sdkAppTheme.getHeaderColorInt())
        binding.btnRescanningDocuments.radius = textSizeConverter.calculateRadius(8).toFloat()
        binding.txtError3.setTextSize(
            TypedValue.COMPLEX_UNIT_PX,
            textSizeConverter.getTextSize(16).toFloat(),
        )
        binding.txtError3.setPadding(0, 0, 0, textSizeConverter.getPaddingOrMarginValue(38))
    }

    fun getFrontCameraId(): String? {
        val cameraManager = activity.getSystemService(Context.CAMERA_SERVICE) as CameraManager
        val cameraIds = cameraManager.cameraIdList

        for (id in cameraIds) {
            val characteristics = cameraManager.getCameraCharacteristics(id)
            val facing = characteristics.get(CameraCharacteristics.LENS_FACING)
            if (facing == CameraCharacteristics.LENS_FACING_FRONT) {
                return id
            }
        }

        return null
    }

    fun getYuvDataFromImage(image: ImageProxy): ByteArray {
        val width = image.width
        val height = image.height
        val ySize = width * height
        val uvSize = width * height / 4

        val nv21 = ByteArray(ySize + uvSize * 2)

        val yBuffer = image.planes[0].buffer // Y

        val uBuffer = image.planes[1].buffer // U

        val vBuffer = image.planes[2].buffer // V

        var rowStride = image.planes[0].rowStride
        assert(image.planes[0].pixelStride == 1)

        var pos = 0

        if (rowStride == width) { // likely
            yBuffer[nv21, 0, ySize]
            pos += ySize
        } else {
            var yBufferPos = -rowStride.toLong() // not an actual position
            while (pos < ySize) {
                yBufferPos += rowStride.toLong()
                yBuffer.position(yBufferPos.toInt())
                yBuffer[nv21, pos, width]
                pos += width
            }
        }

        rowStride = image.planes[2].rowStride
        val pixelStride = image.planes[2].pixelStride

        assert(rowStride == image.planes[1].rowStride)
        assert(pixelStride == image.planes[1].pixelStride)

        if (pixelStride == 2 && rowStride == width && uBuffer[0] == vBuffer[1]) {
            val savePixel = vBuffer[1]
            try {
                vBuffer.put(1, savePixel.inv())
                if (uBuffer[0] == savePixel.inv()) {
                    vBuffer.put(1, savePixel)
                    vBuffer.position(0)
                    uBuffer.position(0)
                    vBuffer[nv21, ySize, 1]
                    uBuffer[nv21, ySize + 1, uBuffer.remaining()]
                    return nv21 // shortcut
                }
            } catch (ex: ReadOnlyBufferException) {
                ex.printStackTrace()
            }

            vBuffer.put(1, savePixel)
        }

        for (row in 0 until height / 2) {
            for (col in 0 until width / 2) {
                val vuPos = col * pixelStride + row * rowStride
                nv21[pos++] = vBuffer[vuPos]
                nv21[pos++] = uBuffer[vuPos]
            }
        }

        return nv21
    }

    @Generated
    fun isFaceCenteredInRectangle(rect: Rect): Boolean {
        val faceBounds =
            RectF(
                binding.coverView.getRect().left,
                binding.coverView.getRect().top,
                binding.coverView.getRect().right,
                binding.coverView.getRect().bottom,
            )
        val faceCenterX = (faceBounds.left + faceBounds.right) / 2

        val rectCenterX = (rect.left + rect.right) / 2
        val thresholdX = 0.1 // Adjust as needed
        faceCenterX.toDouble() in (rectCenterX - thresholdX * rect.width())..(rectCenterX + thresholdX * rect.width())
        val isTooFarRight = faceCenterX > rectCenterX + thresholdX * rect.width()
        val isTooFarLeft = faceCenterX < rectCenterX - thresholdX * rect.width()

        return isTooFarLeft || isTooFarRight
    }
}
