package nashid.verify.sdk.viewmodel

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData

class CameraXLiveData {
    private val isInternetAvailable = MutableLiveData(false)
    private val isSuccess = MutableLiveData(false)
    private val isFrontView = MutableLiveData(false)
    private val closeImageProxy = MutableLiveData(false)
    private val statusText = MutableLiveData<String>()
    private val instructionText = MutableLiveData<String>()
    private val bottomText = MutableLiveData<String>()
    private val idNo = MutableLiveData<String?>(null)
    private val dob = MutableLiveData<String?>(null)
    private val selectedDoc = MutableLiveData("")
    private val expiryDate = MutableLiveData<String?>(null)
    private val captureAnImage = MutableLiveData(false)
    private val cTimer = MutableLiveData(false)
    private val closeAnalysisUseCase = MutableLiveData(false)
    private val isScanVisible = MutableLiveData(false)
    private val isScanFailVisible = MutableLiveData(false)
    private val isTransparentVisible = MutableLiveData(false)
    private val isScanCompleteVisible = MutableLiveData(false)
    private val isLayoutBottomVisible = MutableLiveData(true)
    private val isBackCardScanVisible = MutableLiveData(false)
    private val isFrontViewScanned = MutableLiveData(false)
    private val isOverlayVisible = MutableLiveData(true)
    private val flag = MutableLiveData(true)
    private val algoHeaderDetect = MutableLiveData(false)
    private val isIdLine1 = MutableLiveData(true)
    private val isIdLine2 = MutableLiveData(true)
    private val isIdLine3 = MutableLiveData(true)
    private val glareTextVisibility = MutableLiveData(false)
    private val glareText = MutableLiveData("")
    private val updateCustomLoader = MutableLiveData(false)
    private val unbindCameraProvider = MutableLiveData(false)

    // Getters

    fun getIsInternetAvailable(): LiveData<Boolean> = isInternetAvailable

    fun getIsSuccess(): LiveData<Boolean> = isSuccess

    fun getIsFrontView(): LiveData<Boolean> = isFrontView

    fun getCloseImageProxy(): LiveData<Boolean> = closeImageProxy

    fun getStatusText(): LiveData<String> = statusText

    fun getInstruction(): LiveData<String> = instructionText

    fun getBottomText(): LiveData<String> = bottomText

    fun getIdNo(): LiveData<String?> = idNo

    val dOB: LiveData<String?>
        get() = dob

    fun getExpiryDate(): LiveData<String?> = expiryDate

    fun setSelectedDoc(doc: String) {
        selectedDoc.value = doc
    }

    fun getCaptureAnImage(): LiveData<Boolean> = captureAnImage

    fun getCTimer(): LiveData<Boolean> = cTimer

    fun getCloseAnalysisUseCase(): LiveData<Boolean> = closeAnalysisUseCase

    fun getIsScanVisible(): LiveData<Boolean> = isScanVisible

    fun getIsScanFailVisible(): LiveData<Boolean> = isScanFailVisible

    fun getSelectedDoc(): LiveData<String> = selectedDoc

    fun getIsTransparentVisible(): LiveData<Boolean> = isTransparentVisible

    fun getIsScanCompleteVisible(): LiveData<Boolean> = isScanCompleteVisible

    fun getIsLayoutBottomVisible(): LiveData<Boolean> = isLayoutBottomVisible

    fun getIsBackCardScanVisible(): LiveData<Boolean> = isBackCardScanVisible

    fun getIsFrontViewScanned(): LiveData<Boolean> = isFrontViewScanned

    fun getIsOverlayVisible(): LiveData<Boolean> = isOverlayVisible

    fun getFlag(): LiveData<Boolean> = flag

    fun getAlgoHeaderDetect(): LiveData<Boolean> = algoHeaderDetect

    fun getIdLine1(): LiveData<Boolean> = isIdLine1

    fun getIdLine2(): LiveData<Boolean> = isIdLine2

    fun getIdLine3(): LiveData<Boolean> = isIdLine3

    fun getGlareTextVisibility(): LiveData<Boolean> = glareTextVisibility

    fun getGlareText(): LiveData<String> = glareText

    fun getUpdateCustomLoader(): LiveData<Boolean> = updateCustomLoader

    fun getUnbindCameraProvider(): LiveData<Boolean> = unbindCameraProvider

    // Setters
    fun setIsInternetAvailable(isAvailable: Boolean) {
        isInternetAvailable.value = isAvailable
    }

    fun setIsSuccess(isSuccess: Boolean) {
        this.isSuccess.value = isSuccess
    }

    fun setIsFrontView(isFrontView: Boolean) {
        this.isFrontView.value = isFrontView
    }

    fun setCloseImageProxy(needToCloseImageProxy: Boolean) {
        closeImageProxy.value = needToCloseImageProxy
    }

    fun setStatusText(status: String) {
        statusText.value = status
    }

    fun setInstructionText(status: String) {
        instructionText.value = status
    }

    fun setBottomText(bottom: String) {
        bottomText.value = bottom
    }

    fun setIdNo(value: String?) {
        idNo.value = value
    }

    fun setDOB(value: String?) {
        dob.value = value
    }

    fun setExpiryDate(value: String?) {
        expiryDate.value = value
    }

    fun setCaptureAnImage(capture: Boolean) {
        captureAnImage.value = capture
    }

    fun setCTimer(cTimer: Boolean) {
        this.cTimer.value = cTimer
    }

    fun setCloseAnalysisUseCase(close: Boolean) {
        closeAnalysisUseCase.value = close
    }

    fun setIsScanVisible(isVisible: Boolean) {
        isScanVisible.value = isVisible
    }

    fun setIsScanFailVisible(isVisible: Boolean) {
        isScanFailVisible.value = isVisible
    }

    fun setIsTransparentVisible(isVisible: Boolean) {
        isTransparentVisible.value = isVisible
    }

    fun setIsScanCompleteVisible(isVisible: Boolean) {
        isScanCompleteVisible.value = isVisible
    }

    fun setIsLayoutBottomVisible(visible: Boolean) {
        isLayoutBottomVisible.value = visible
    }

    fun setIsBackCardScanVisible(isVisible: Boolean) {
        isBackCardScanVisible.value = isVisible
    }

    fun setIsFrontViewScanned(isScanned: Boolean) {
        isFrontViewScanned.value = isScanned
    }

    fun setIsOverlayVisible(visibility: Boolean) {
        isOverlayVisible.value = visibility
    }

    fun setFlag(flag: Boolean) {
        this.flag.value = flag
    }

    fun setAlgoHeaderDetect(detect: Boolean) {
        algoHeaderDetect.value = detect
    }

    fun setIdLine1(idLine1: Boolean) {
        isIdLine1.value = idLine1
    }

    fun setIdLine2(idLine2: Boolean) {
        isIdLine2.value = idLine2
    }

    fun setIdLine3(idLine3: Boolean) {
        isIdLine3.value = idLine3
    }

    fun setGlareTextVisibility(visibility: Boolean) {
        glareTextVisibility.value = visibility
    }

    fun setGlareText(text: String) {
        glareText.value = text
    }

    fun setUpdateCustomLoader(needToUpdate: Boolean) {
        updateCustomLoader.value = needToUpdate
    }

    fun setUnbindCameraProvider(isUnbind: Boolean) {
        unbindCameraProvider.value = isUnbind
    }

    fun resetState() {
        isInternetAvailable.value = false
        isSuccess.value = false
        isFrontView.value = false
        closeImageProxy.value = false
        statusText.value = ""
        instructionText.value = ""
        bottomText.value = ""
        idNo.value = null
        dob.value = null
        selectedDoc.value = ""
        expiryDate.value = null
        captureAnImage.value = false
        cTimer.value = false
        closeAnalysisUseCase.value = false
        isScanVisible.value = false
        isScanFailVisible.value = false
        isTransparentVisible.value = false
        isScanCompleteVisible.value = false
        isLayoutBottomVisible.value = true
        isBackCardScanVisible.value = false
        isFrontViewScanned.value = false
        isOverlayVisible.value = true
        flag.value = true
        algoHeaderDetect.value = false
        isIdLine1.value = true
        isIdLine2.value = true
        isIdLine3.value = true
        glareTextVisibility.value = false
        glareText.value = ""
        updateCustomLoader.value = false
        unbindCameraProvider.value = false
    }
}
