/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.messages;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;

public interface Message {
    public static final String NO_TYPE = "NO_TYPE";

    default public long timestamp() {
        return -1L;
    }

    default public long expirationTime() {
        return -1L;
    }

    default public long deliveryTime() {
        return -1L;
    }

    default public int deliveryMode() {
        return -1;
    }

    default public String type() {
        return NO_TYPE;
    }

    default public boolean redelivered() {
        return false;
    }

    default public int priority() {
        return -1;
    }

    default public String correlationID() {
        return "";
    }

    default public Map<String, Object> headers() {
        return Collections.emptyMap();
    }

    default public void reply(Message reply) {
    }

    default public byte[] getBodyBytes() {
        return new byte[0];
    }

    default public String bodyAsString() {
        return new String(this.getBodyBytes(), StandardCharsets.UTF_8);
    }

    default public byte[] getMessageBytes() {
        return this.getBodyBytes();
    }
}

