/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.messages;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.nats.bridge.messages.BaseMessage;
import io.nats.bridge.messages.BaseMessageWithHeaders;
import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.MessageBuilderException;
import io.nats.bridge.messages.Protocol;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBuilder {
    private static final ObjectMapper mapper = new ObjectMapper();
    static Logger logger = LoggerFactory.getLogger(MessageBuilder.class);
    private long timestamp = -1L;
    private long expirationTime = -1L;
    private long deliveryTime = -1L;
    private int mode = -1;
    private String type = "NO_TYPE";
    private boolean redelivered;
    private int priority = -1;
    private Map<String, Object> headers;
    private byte[] body;
    private String correlationID;
    private String creator;
    private Consumer<Message> replyHandler;

    public String getCreator() {
        if (this.creator == null) {
            return "";
        }
        return this.creator;
    }

    public MessageBuilder withCreator(String creator) {
        this.creator = creator;
        return this;
    }

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public MessageBuilder withCorrelationID(String correlationID) {
        this.correlationID = correlationID;
        return this;
    }

    public Consumer<Message> getReplyHandler() {
        if (this.replyHandler == null) {
            this.replyHandler = message -> {
                new Exception().fillInStackTrace().printStackTrace();
                System.out.println(this.creator + "::: DEFAULT HANDLER CALLED " + this.creator);
            };
        }
        return this.replyHandler;
    }

    public MessageBuilder withNoReplyHandler(String description) {
        Exception caller = new Exception();
        this.withReplyHandler(message -> {
            System.out.println("NOT EXPECTING A REPLY " + description + "::: creator" + this.creator + "::: DEFAULT HANDLER CALLED " + this.creator);
            System.out.println("CALLER INFO----");
            caller.printStackTrace(System.out);
            new Exception().fillInStackTrace().printStackTrace();
        });
        return this;
    }

    public MessageBuilder withReplyHandler(Consumer<Message> replyHandler) {
        this.replyHandler = replyHandler;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public MessageBuilder withTimestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public MessageBuilder withExpirationTime(long expirationTime) {
        this.expirationTime = expirationTime;
        return this;
    }

    public long getDeliveryTime() {
        return this.deliveryTime;
    }

    public MessageBuilder withDeliveryTime(long deliveryTime) {
        this.deliveryTime = deliveryTime;
        return this;
    }

    public int getMode() {
        return this.mode;
    }

    public MessageBuilder withDeliveryMode(int mode) {
        this.mode = mode;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public MessageBuilder withType(String type) {
        this.type = type;
        return this;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public MessageBuilder withRedelivered(boolean redelivered) {
        this.redelivered = redelivered;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public MessageBuilder withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public Map<String, Object> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, Object>(9);
        }
        return this.headers;
    }

    public MessageBuilder withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        return this;
    }

    public byte[] getBody() {
        return this.body;
    }

    public MessageBuilder withBody(byte[] body) {
        this.body = body;
        return this;
    }

    public MessageBuilder withBody(String body) {
        this.body = body.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public Message build() {
        if (this.timestamp == -1L && this.headers == null && this.deliveryTime == -1L && this.expirationTime == -1L && this.mode == -1 && this.type == "NO_TYPE" && !this.redelivered && this.priority == -1) {
            return new BaseMessage(this.getBody(), this.getReplyHandler());
        }
        return new BaseMessageWithHeaders(this.getTimestamp(), this.getExpirationTime(), this.getDeliveryTime(), this.getMode(), this.getType(), this.isRedelivered(), this.getPriority(), this.getCorrelationID(), this.getHeaders(), this.getBody(), this.getReplyHandler());
    }

    public MessageBuilder initFromMessage(Message inputMessage) {
        this.buildFromBytes(inputMessage.getMessageBytes());
        this.withReplyHandler(inputMessage::reply);
        return this;
    }

    public Message buildFromBytes(byte[] buffer) {
        this.initFromBytes(buffer);
        return this.build();
    }

    public MessageBuilder initFromBytes(byte[] buffer) {
        Map<String, Object> headersRead = Collections.emptyMap();
        if (buffer.length > 3) {
            if (buffer[0] == -85 && buffer[1] == -51 && buffer[2] == 1 && buffer[3] == 0) {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(buffer));
                try {
                    dataInputStream.skipBytes(4);
                    int numHHeaders = dataInputStream.readByte();
                    if (numHHeaders > 0) {
                        headersRead = new HashMap(numHHeaders);
                        block14: for (int index = 0; index < numHHeaders; ++index) {
                            String headerName;
                            byte headerNameLength = dataInputStream.readByte();
                            if (headerNameLength < 0) {
                                headerName = Protocol.getHeaderFromCode(headerNameLength);
                            } else {
                                byte[] headerNameBytes = new byte[headerNameLength];
                                dataInputStream.read(headerNameBytes);
                                headerName = new String(headerNameBytes, StandardCharsets.UTF_8);
                            }
                            byte type = dataInputStream.readByte();
                            switch (type) {
                                case -110: {
                                    char stringLength = dataInputStream.readByte();
                                    if (stringLength < '\u0001') {
                                        throw new RuntimeException("bad string length");
                                    }
                                    byte[] stringBytes = new byte[stringLength];
                                    dataInputStream.read(stringBytes);
                                    headersRead.put(headerName, new String(stringBytes, StandardCharsets.UTF_8));
                                    continue block14;
                                }
                                case -111: {
                                    char stringLength = dataInputStream.readChar();
                                    if (stringLength < '\u0001') {
                                        throw new RuntimeException("bad string length");
                                    }
                                    byte[] stringBytes = new byte[stringLength];
                                    dataInputStream.read(stringBytes);
                                    headersRead.put(headerName, new String(stringBytes, StandardCharsets.UTF_8));
                                    continue block14;
                                }
                                case -112: {
                                    headersRead.put(headerName, true);
                                    continue block14;
                                }
                                case -113: {
                                    headersRead.put(headerName, false);
                                    continue block14;
                                }
                                case -114: {
                                    headersRead.put(headerName, dataInputStream.readByte());
                                    continue block14;
                                }
                                case -116: {
                                    headersRead.put(headerName, dataInputStream.readShort());
                                    continue block14;
                                }
                                case -118: {
                                    headersRead.put(headerName, dataInputStream.readInt());
                                    continue block14;
                                }
                                case -120: {
                                    headersRead.put(headerName, dataInputStream.readLong());
                                    continue block14;
                                }
                                case -122: {
                                    headersRead.put(headerName, Float.valueOf(dataInputStream.readFloat()));
                                    continue block14;
                                }
                                case -123: {
                                    headersRead.put(headerName, dataInputStream.readDouble());
                                    continue block14;
                                }
                                default: {
                                    if (type < -109) {
                                        throw new RuntimeException("bad type code");
                                    }
                                    headersRead.put(headerName, Integer.valueOf(type));
                                }
                            }
                        }
                    }
                    int bodyLength = dataInputStream.readInt();
                    int bodyHash = dataInputStream.readInt();
                    byte[] bodyBuffer = new byte[bodyLength];
                    dataInputStream.read(bodyBuffer);
                    if (Protocol.createHashCode(bodyBuffer) != bodyHash) {
                        throw new MessageBuilderException("Body Hash did not match ");
                    }
                    if (this.headers == null) {
                        this.headers = headersRead;
                    } else {
                        this.headers.putAll(headersRead);
                    }
                    if (this.headers.containsKey("BRIDGE_timestamp")) {
                        this.withTimestamp((Long)this.headers.get("BRIDGE_timestamp"));
                        this.headers.remove("BRIDGE_timestamp");
                    }
                    if (this.headers.containsKey("BRIDGE_expirationTime")) {
                        this.withExpirationTime((Long)this.headers.get("BRIDGE_expirationTime"));
                        this.headers.remove("BRIDGE_expirationTime");
                    }
                    if (this.headers.containsKey("BRIDGE_deliveryTime")) {
                        this.withDeliveryTime((Long)this.headers.get("BRIDGE_deliveryTime"));
                        this.headers.remove("BRIDGE_deliveryTime");
                    }
                    if (this.headers.containsKey("BRIDGE_mode")) {
                        this.withDeliveryMode((Integer)this.headers.get("BRIDGE_mode"));
                        this.headers.remove("BRIDGE_mode");
                    }
                    if (this.headers.containsKey("BRIDGE_type")) {
                        this.withType((String)this.headers.get("BRIDGE_type"));
                        this.headers.remove("BRIDGE_type");
                    }
                    if (this.headers.containsKey("BRIDGE_redelivered")) {
                        this.withRedelivered((Boolean)this.headers.get("BRIDGE_redelivered"));
                        this.headers.remove("BRIDGE_redelivered");
                    }
                    if (this.headers.containsKey("BRIDGE_priority")) {
                        this.withPriority((Integer)this.headers.get("BRIDGE_priority"));
                        this.headers.remove("BRIDGE_priority");
                    }
                    this.withHeaders(this.headers);
                    this.withBody(bodyBuffer);
                    return this;
                }
                catch (Exception ex) {
                    logger.warn("Unable to parse the message after detecting that headers are present", (Throwable)ex);
                    this.withBody(buffer);
                    return this;
                }
            }
            this.withBody(buffer);
            return this;
        }
        this.withBody(buffer);
        return this;
    }

    public MessageBuilder withHeader(String key, int value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, short value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, byte value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, Object value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, long value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, boolean value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, double value) {
        this.getHeaders().put(key, value);
        return this;
    }

    public MessageBuilder withHeader(String key, float value) {
        this.getHeaders().put(key, Float.valueOf(value));
        return this;
    }

    public MessageBuilder withHeader(String key, String value) {
        this.getHeaders().put(key, value);
        return this;
    }
}

