/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.messages.transform;

import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.transform.Result;
import java.util.Optional;

public class TransformResult {
    private final Optional<Throwable> error;
    private final Optional<String> statusMessage;
    private final Result result;
    private final Optional<Message> message;

    public TransformResult(Throwable error, String transformationMessage, Result result, Message message) {
        this.error = Optional.ofNullable(error);
        this.statusMessage = Optional.ofNullable(transformationMessage);
        this.message = Optional.ofNullable(message);
        this.result = result != null ? result : Result.TRANSFORMED;
    }

    public TransformResult() {
        this(null, null, null, null);
    }

    public static TransformResult success(Message transformedMessage) {
        return new TransformResult(null, null, Result.TRANSFORMED, transformedMessage);
    }

    public static TransformResult success(String transformationMessage, Message transformedMessage) {
        return new TransformResult(null, transformationMessage, Result.TRANSFORMED, transformedMessage);
    }

    public static TransformResult skip() {
        return new TransformResult(null, null, Result.SKIP, null);
    }

    public static TransformResult skip(String transformationMessage) {
        return new TransformResult(null, transformationMessage, Result.SKIP, null);
    }

    public static TransformResult notTransformed() {
        return new TransformResult(null, null, Result.NOT_TRANSFORMED, null);
    }

    public static TransformResult notTransformed(String transformationMessage) {
        return new TransformResult(null, transformationMessage, Result.NOT_TRANSFORMED, null);
    }

    public static TransformResult error(Throwable exception) {
        return new TransformResult(exception, null, Result.ERROR, null);
    }

    public static TransformResult error(String transformationMessage, Throwable exception) {
        return new TransformResult(exception, transformationMessage, Result.ERROR, null);
    }

    public Result getResult() {
        return this.result;
    }

    public boolean isError() {
        return this.result == Result.ERROR || this.result == Result.SYSTEM_ERROR;
    }

    public boolean wasTransformed() {
        return this.result == Result.TRANSFORMED;
    }

    public Throwable getError() {
        return this.error.orElse(null);
    }

    public Message getTransformedMessage() {
        return this.message.orElse(null);
    }

    public Optional<String> getStatusMessage() {
        return this.statusMessage;
    }
}

