/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.messages;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.nats.bridge.messages.BytesMessage;
import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.MessageException;
import io.nats.bridge.messages.Protocol;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class BaseMessageWithHeaders
implements BytesMessage {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final long timestamp;
    private final long expirationTime;
    private final long deliveryTime;
    private final int mode;
    private final String type;
    private final boolean redelivered;
    private final int priority;
    private final String correlationID;
    private final Map<String, Object> headers;
    private final byte[] bodyBytes;
    private final Consumer<Message> replyHandler;

    public BaseMessageWithHeaders(long timestamp, long expirationTime, long deliveryTime, int mode, String type, boolean redelivered, int priority, String correlationID, Map<String, Object> headers, byte[] bytes, Consumer<Message> replyHandler) {
        this.timestamp = timestamp;
        this.expirationTime = expirationTime;
        this.deliveryTime = deliveryTime;
        this.mode = mode;
        this.type = type;
        this.redelivered = redelivered;
        this.priority = priority;
        this.correlationID = correlationID;
        this.headers = headers;
        this.bodyBytes = bytes == null ? new byte[]{} : bytes;
        this.replyHandler = replyHandler;
    }

    @Override
    public String correlationID() {
        return this.correlationID;
    }

    @Override
    public void reply(Message reply) {
        this.replyHandler.accept(reply);
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBytes;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public long expirationTime() {
        return this.expirationTime;
    }

    @Override
    public long deliveryTime() {
        return this.deliveryTime;
    }

    @Override
    public int deliveryMode() {
        return this.mode;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public boolean redelivered() {
        return this.redelivered;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public Map<String, Object> headers() {
        if (this.headers == null) {
            return Collections.emptyMap();
        }
        return this.headers;
    }

    public byte[] getMessageAsBytes() {
        ByteArrayOutputStream bytesOutputStream = new ByteArrayOutputStream();
        DataOutputStream streamOut = new DataOutputStream(bytesOutputStream);
        try {
            streamOut.writeByte(-85);
            streamOut.writeByte(-51);
            streamOut.writeByte(1);
            streamOut.writeByte(0);
            Map<Object, Object> outputHeaders = this.headers == null ? Collections.emptyMap() : this.headers;
            int headerSize = 0;
            if (this.deliveryTime > 0L) {
                ++headerSize;
            }
            if (this.mode != -1) {
                ++headerSize;
            }
            if (this.expirationTime > 0L) {
                ++headerSize;
            }
            if (this.timestamp > 0L) {
                ++headerSize;
            }
            if (this.type != null && !"NO_TYPE".equals(this.type)) {
                ++headerSize;
            }
            if (this.priority != -1) {
                ++headerSize;
            }
            if (this.redelivered) {
                ++headerSize;
            }
            if (this.correlationID != null) {
                ++headerSize;
            }
            streamOut.writeByte(headerSize += outputHeaders.size());
            if (headerSize > 255) {
                throw new MessageException("Can't write out the message as there are too many headers");
            }
            if (this.deliveryTime() > 0L) {
                streamOut.writeByte(-128);
                streamOut.writeByte(-120);
                streamOut.writeLong(this.deliveryTime());
            }
            if (this.deliveryMode() != -1) {
                streamOut.writeByte(-126);
                streamOut.writeByte(this.deliveryMode());
            }
            if (this.expirationTime() > 0L) {
                streamOut.writeByte(-125);
                streamOut.writeByte(-120);
                streamOut.writeLong(this.expirationTime());
            }
            if (this.correlationID() != null) {
                streamOut.writeByte(-121);
                streamOut.writeByte(-110);
                streamOut.writeByte(this.correlationID().length());
                streamOut.write(this.correlationID().getBytes(StandardCharsets.UTF_8));
            }
            if (this.timestamp() > 0L) {
                streamOut.writeByte(-127);
                streamOut.writeByte(-120);
                streamOut.writeLong(this.timestamp());
            }
            if (this.type() != null && !"NO_TYPE".equals(this.type())) {
                streamOut.writeByte(-124);
                streamOut.writeByte(-110);
                streamOut.writeByte(this.type().length());
                streamOut.write(this.type().getBytes(StandardCharsets.UTF_8));
            }
            if (this.priority != -1) {
                streamOut.writeByte(-123);
                streamOut.writeByte(this.priority());
            }
            if (this.redelivered) {
                streamOut.writeByte(-122);
                streamOut.writeByte(-112);
            }
            for (Map.Entry<Object, Object> kv : outputHeaders.entrySet()) {
                if (((String)kv.getKey()).length() > 255) {
                    throw new MessageException("Can't write out the message as there header name length is too long");
                }
                int codeFromHeader = Protocol.getCodeFromHeader((String)kv.getKey());
                if (codeFromHeader > 0) {
                    streamOut.writeByte(((String)kv.getKey()).length());
                    streamOut.write(((String)kv.getKey()).getBytes(StandardCharsets.UTF_8));
                } else {
                    streamOut.writeByte(codeFromHeader);
                }
                switch (kv.getValue().getClass().getSimpleName()) {
                    case "String": {
                        String string = (String)kv.getValue();
                        if (string.length() < 512) {
                            streamOut.writeByte(-110);
                            streamOut.writeByte(string.length());
                        } else {
                            streamOut.writeByte(-111);
                            streamOut.writeChar(string.length());
                        }
                        streamOut.write(string.getBytes(StandardCharsets.UTF_8));
                        break;
                    }
                    case "Boolean": {
                        boolean b = (Boolean)kv.getValue();
                        if (b) {
                            streamOut.writeByte(-112);
                            break;
                        }
                        streamOut.writeByte(-113);
                        break;
                    }
                    case "Short": {
                        streamOut.writeByte(-116);
                        streamOut.writeShort(((Short)kv.getValue()).shortValue());
                        break;
                    }
                    case "Byte": {
                        streamOut.writeByte(-114);
                        streamOut.writeByte(((Byte)kv.getValue()).byteValue());
                        break;
                    }
                    case "Integer": {
                        int value = (Integer)kv.getValue();
                        if (value < -109 && value > -128) {
                            streamOut.write(value);
                            break;
                        }
                        streamOut.writeByte(-118);
                        streamOut.writeInt(value);
                        break;
                    }
                    case "Long": {
                        streamOut.writeByte(-120);
                        streamOut.writeLong((Long)kv.getValue());
                        break;
                    }
                    case "Float": {
                        streamOut.writeByte(-122);
                        streamOut.writeFloat(((Float)kv.getValue()).floatValue());
                        break;
                    }
                    case "Double": {
                        streamOut.writeByte(-123);
                        streamOut.writeDouble((Double)kv.getValue());
                    }
                }
            }
            if (this.bodyBytes != null && this.bodyBytes.length > 0) {
                streamOut.writeInt(this.bodyBytes.length);
                streamOut.writeInt(Protocol.createHashCode(this.bodyBytes));
                streamOut.write(this.bodyBytes);
            } else {
                streamOut.writeInt(0);
                streamOut.writeInt(0);
            }
        }
        catch (Exception e) {
            throw new MessageException("Can't write out message", e);
        }
        finally {
            try {
                streamOut.close();
                bytesOutputStream.close();
            }
            catch (Exception exception) {}
        }
        return bytesOutputStream.toByteArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BaseMessageWithHeaders)) {
            return false;
        }
        BaseMessageWithHeaders that = (BaseMessageWithHeaders)o;
        return this.timestamp == that.timestamp && this.expirationTime == that.expirationTime && this.deliveryTime == that.deliveryTime && this.mode == that.mode && this.redelivered == that.redelivered && this.priority == that.priority && Objects.equals(this.correlationID, that.correlationID) && Objects.equals(this.type, that.type) && this.compareHeaders(that.headers) && Arrays.equals(this.bodyBytes, that.bodyBytes);
    }

    private boolean compareHeaders(Map<String, Object> thatHeaders) {
        if (this.headers == null && thatHeaders == null) {
            return true;
        }
        if (this.headers == null) {
            return false;
        }
        if (thatHeaders == null) {
            return false;
        }
        if (this.headers.size() != thatHeaders.size()) {
            return false;
        }
        for (String key : this.headers.keySet()) {
            Object value1 = thatHeaders.get(key);
            Object value2 = this.headers.get(key);
            if (value1 instanceof Number && value2 instanceof Number) {
                Number num1 = (Number)value1;
                Number num2 = (Number)value2;
                if (num1.doubleValue() == num2.doubleValue()) continue;
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = Objects.hash(this.timestamp, this.expirationTime, this.deliveryTime, this.mode, this.type, this.redelivered, this.priority, this.headers);
        result = 31 * result + Arrays.hashCode(this.bodyBytes);
        return result;
    }

    @Override
    public byte[] getMessageBytes() {
        return this.getMessageAsBytes();
    }

    public String toString() {
        String bodyStr = this.bodyBytes != null ? ", bodyBytes=" + Arrays.toString(this.bodyBytes) : "";
        return "BaseMessageWithHeaders{timestamp=" + this.timestamp + ", expirationTime=" + this.expirationTime + ", deliveryTime=" + this.deliveryTime + ", mode=" + this.mode + ", type='" + this.type + '\'' + ", redelivered=" + this.redelivered + ", priority=" + this.priority + ", headers=" + this.headers + bodyStr + '}';
    }
}

