/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.integration.ibmmq;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import com.ibm.msg.client.jms.JmsPropertyContext;
import io.nats.bridge.integration.ibmmq.PropertyUtils;
import io.nats.bridge.integration.ibmmq.PropertyValue;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;

public class IbmMqInitialContextFactory
implements InitialContextFactory {
    private final Map<String, Object> contextMap = new HashMap<String, Object>();
    private static final String CONNECTION_FACTORY = "ConnectionFactory";
    public static final String PREFIX = "nats.ibm.mq.";
    private static final String HOST = "nats.ibm.mq.host";
    private static final String CHANNEL = "nats.ibm.mq.channel";
    private static final String CCDT_URL = "nats.ibm.mq.ccdtUrl";
    private static final String QUEUE_MANAGER = "nats.ibm.mq.queueManager";
    private static final String QUEUE_MODEL_NAME = "nats.ibm.mq.queueModelName";
    private static final String QUEUE_MODEL_PREFIX = "nats.ibm.mq.queueModelPrefix";

    @Override
    public Context getInitialContext(Hashtable<?, ?> jndiProperties) throws NamingException {
        try {
            JmsFactoryFactory factoryFactory = JmsFactoryFactory.getInstance((String)"com.ibm.msg.client.wmq");
            JmsConnectionFactory connectionFactory = factoryFactory.createConnectionFactory();
            String ccdtURL = this.getOptionalStringProp(jndiProperties, CCDT_URL);
            if (ccdtURL != null) {
                if (connectionFactory instanceof MQConnectionFactory) {
                    MQConnectionFactory factory = (MQConnectionFactory)connectionFactory;
                    factory.setCCDTURL(new URL(ccdtURL));
                } else {
                    System.out.println("Unable to set CCDT file using nats.ibm.mq.ccdtUrl");
                }
            } else {
                String hostURL = this.getOptionalStringProp(jndiProperties, HOST);
                String channel = this.getStringProp(jndiProperties, CHANNEL);
                if (hostURL != null) {
                    URI uri = new URI(hostURL);
                    String host = uri.getHost();
                    int port = uri.getPort();
                    connectionFactory.setStringProperty("XMSC_WMQ_HOST_NAME", host);
                    connectionFactory.setIntProperty("XMSC_WMQ_PORT", port);
                }
                if (channel != null) {
                    connectionFactory.setStringProperty("XMSC_WMQ_CHANNEL", channel);
                }
                connectionFactory.setStringProperty("XMSC_WMQ_CHANNEL", channel);
            }
            String queueManagerName = this.getStringProp(jndiProperties, QUEUE_MANAGER);
            String queueModelName = this.getOptionalStringProp(jndiProperties, QUEUE_MODEL_NAME);
            String queueModelPrefix = this.getOptionalStringProp(jndiProperties, QUEUE_MODEL_PREFIX);
            connectionFactory.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            connectionFactory.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", queueManagerName);
            connectionFactory.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", true);
            List<PropertyValue> propertyValues = PropertyUtils.extractProperties(jndiProperties);
            PropertyUtils.initJMSContext((JmsPropertyContext)connectionFactory, propertyValues);
            if (queueModelName != null) {
                connectionFactory.setStringProperty("XMSC_WMQ_TEMPORARY_MODEL", queueModelName);
            }
            if (queueModelPrefix != null) {
                connectionFactory.setStringProperty("XMSC_WMQ_TEMP_Q_PREFIX", queueModelPrefix);
            }
            this.contextMap.put(CONNECTION_FACTORY, new NatsMQConnectionFactory(connectionFactory));
            return new MQContext(this.contextMap);
        }
        catch (Exception ex) {
            throw new NamingException(ex.getLocalizedMessage());
        }
    }

    private String getOptionalStringProp(Hashtable<?, ?> jndiProperties, String key) {
        return (String)jndiProperties.get(key);
    }

    private String getStringProp(Hashtable<?, ?> jndiProperties, String key) {
        if (!jndiProperties.containsKey(key)) {
            throw new IllegalStateException("REQ KEY IS MISSING KEY " + key);
        }
        return (String)jndiProperties.get(key);
    }

    public static class MQContext
    implements Context {
        final Map<String, Object> contextMap;

        private MQContext(Map<String, Object> contextMap) {
            this.contextMap = contextMap;
        }

        @Override
        public Object lookup(String name) throws NamingException {
            if (name == null || !this.contextMap.containsKey(name)) {
                throw new NamingException("Name " + name + " not found");
            }
            return this.contextMap.get(name);
        }

        @Override
        public Object lookup(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void bind(Name name, Object o) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void bind(String s, Object o) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void rebind(Name name, Object o) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void rebind(String s, Object o) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void unbind(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void unbind(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void rename(Name name, Name name1) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void rename(String s, String s1) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NamingEnumeration<NameClassPair> list(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NamingEnumeration<Binding> listBindings(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void destroySubcontext(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void destroySubcontext(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Context createSubcontext(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Context createSubcontext(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object lookupLink(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object lookupLink(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NameParser getNameParser(Name name) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public NameParser getNameParser(String s) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Name composeName(Name name, Name name1) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String composeName(String s, String s1) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object addToEnvironment(String s, Object o) throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public Object removeFromEnvironment(String s) throws NamingException {
            return null;
        }

        @Override
        public Hashtable<?, ?> getEnvironment() throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public void close() throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }

        @Override
        public String getNameInNamespace() throws NamingException {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    public static class NatsMQConnectionFactory
    implements ConnectionFactory {
        private final JmsConnectionFactory connectionFactory;

        private NatsMQConnectionFactory(JmsConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
        }

        public Connection createConnection() throws JMSException {
            return this.connectionFactory.createConnection();
        }

        public Connection createConnection(String userName, String password) throws JMSException {
            this.connectionFactory.setStringProperty("XMSC_USERID", userName);
            this.connectionFactory.setStringProperty("XMSC_PASSWORD", password);
            return this.connectionFactory.createConnection(userName, password);
        }

        public JMSContext createContext() {
            throw new UnsupportedOperationException("Not supported");
        }

        public JMSContext createContext(int sessionMode) {
            throw new UnsupportedOperationException("Not supported");
        }

        public JMSContext createContext(String userName, String password) {
            throw new UnsupportedOperationException("Not supported");
        }

        public JMSContext createContext(String userName, String password, int sessionMode) {
            throw new UnsupportedOperationException("Not supported");
        }
    }
}

