/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.jms;

import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.slf4j.Logger;

public class JmsContext {
    private final Destination destination;
    private final Session session;
    private final Connection connection;
    private final Destination responseDestination;
    private final MessageConsumer responseConsumer;
    private final Supplier<MessageProducer> producerSupplier;
    private final Supplier<MessageConsumer> consumerSupplier;
    private MessageProducer producer;
    private MessageConsumer consumer;
    private final Logger logger;

    public JmsContext(Destination destination, Session session, Connection connection, Destination responseDestination, MessageConsumer responseConsumer, Supplier<MessageProducer> producer, Supplier<MessageConsumer> consumer, Logger logger) {
        this.destination = destination;
        this.session = session;
        this.connection = connection;
        this.responseDestination = responseDestination;
        this.responseConsumer = responseConsumer;
        this.producerSupplier = producer;
        this.consumerSupplier = consumer;
        this.logger = logger;
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Session getSession() {
        return this.session;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Destination getResponseDestination() {
        return this.responseDestination;
    }

    public MessageConsumer getResponseConsumer() {
        return this.responseConsumer;
    }

    public MessageProducer producer() {
        if (this.producer == null) {
            this.producer = this.producerSupplier.get();
        }
        return this.producer;
    }

    public MessageConsumer consumer() {
        if (this.consumer == null) {
            this.consumer = this.consumerSupplier.get();
        }
        return this.consumer;
    }

    public void close() {
        this.logger.info("Closing session");
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (Exception ex) {
            this.logger.debug("Unable to close session", (Throwable)ex);
        }
        this.logger.info("Closing connection");
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (Exception ex) {
            this.logger.debug("Unable to close connection", (Throwable)ex);
        }
    }
}

