/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.jms.support;

import io.nats.bridge.TimeSource;
import io.nats.bridge.jms.JMSMessageBusException;
import io.nats.bridge.jms.support.JMSReply;
import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.MessageBuilder;
import io.nats.bridge.util.ExceptionHandler;
import io.nats.bridge.util.FunctionWithException;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.TextMessage;

public class ConvertJmsMessageToBridgeMessage
implements FunctionWithException<javax.jms.Message, Message> {
    private final TimeSource timeSource;
    private final Queue<JMSReply> jmsReplyQueue;
    private final ExceptionHandler tryHandler;
    private final String name;

    public ConvertJmsMessageToBridgeMessage(ExceptionHandler tryHandler, TimeSource timeSource, Queue<JMSReply> jmsReplyQueue, String name) {
        this.timeSource = timeSource;
        this.jmsReplyQueue = jmsReplyQueue;
        this.tryHandler = tryHandler;
        this.name = name;
    }

    private void enqueueReply(long sentTime, Message reply, String correlationID, Destination jmsReplyTo) {
        this.jmsReplyQueue.add(new JMSReply(sentTime, reply, correlationID, jmsReplyTo));
    }

    private byte[] readBytesFromJMSMessage(javax.jms.Message jmsMessage) throws Exception {
        if (jmsMessage instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)jmsMessage;
            byte[] buffer = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(buffer);
            return buffer;
        }
        if (jmsMessage instanceof TextMessage) {
            return ((TextMessage)jmsMessage).getText().getBytes(StandardCharsets.UTF_8);
        }
        throw new JMSMessageBusException("Unable to read bytes from message " + jmsMessage.getClass().getName());
    }

    @Override
    public Message apply(javax.jms.Message jmsMessage) throws Exception {
        Destination jmsReplyTo = jmsMessage.getJMSReplyTo();
        long startTime = this.timeSource.getTime();
        byte[] bodyBytes = this.readBytesFromJMSMessage(jmsMessage);
        if (jmsReplyTo != null) {
            return MessageBuilder.builder().withBody(bodyBytes).withReplyHandler(reply -> this.tryHandler.tryWithRethrow(() -> this.enqueueReply(startTime, (Message)reply, jmsMessage.getJMSCorrelationID(), jmsReplyTo), e -> {
                throw new JMSMessageBusException("Unable to send to JMS reply", (Throwable)e);
            })).withCreator(this.name).build();
        }
        return MessageBuilder.builder().withNoReplyHandler("CONVERT JMS TO BRIDGE MESSAGE NO JMS REPLY TO").withBody(bodyBytes).build();
    }
}

