/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.jms.support;

import io.nats.bridge.TimeSource;
import io.nats.bridge.jms.JMSMessageBusException;
import io.nats.bridge.jms.support.JMSReply;
import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.MessageBuilder;
import io.nats.bridge.util.ExceptionHandler;
import io.nats.bridge.util.FunctionWithException;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Queue;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.TextMessage;

public class ConvertJmsMessageToBridgeMessageWithHeaders
implements FunctionWithException<javax.jms.Message, Message> {
    private final ExceptionHandler tryHandler;
    private final TimeSource timeSource;
    private final Queue<JMSReply> jmsReplyQueue;
    private final String name;

    public ConvertJmsMessageToBridgeMessageWithHeaders(ExceptionHandler tryHandler, TimeSource timeSource, Queue<JMSReply> jmsReplyQueue, String name) {
        this.tryHandler = tryHandler;
        this.timeSource = timeSource;
        this.jmsReplyQueue = jmsReplyQueue;
        this.name = name;
    }

    private void enqueueReply(long sentTime, Message reply, String correlationID, Destination jmsReplyTo) {
        this.jmsReplyQueue.add(new JMSReply(sentTime, reply, correlationID, jmsReplyTo));
    }

    private byte[] readBytesFromJMSMessage(javax.jms.Message jmsMessage) throws Exception {
        if (jmsMessage instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)jmsMessage;
            byte[] buffer = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(buffer);
            return buffer;
        }
        if (jmsMessage instanceof TextMessage) {
            return ((TextMessage)jmsMessage).getText().getBytes(StandardCharsets.UTF_8);
        }
        throw new JMSMessageBusException("Unable to read bytes from message " + jmsMessage.getClass().getName());
    }

    @Override
    public Message apply(javax.jms.Message jmsMessage) throws Exception {
        Destination jmsReplyTo = jmsMessage.getJMSReplyTo();
        long startTime = this.timeSource.getTime();
        byte[] bodyBytes = this.readBytesFromJMSMessage(jmsMessage);
        MessageBuilder builder = MessageBuilder.builder().withBody(bodyBytes);
        this.copyHeaders(builder, jmsMessage);
        if (jmsReplyTo != null) {
            builder.withReplyHandler(reply -> this.tryHandler.tryWithRethrow(() -> this.enqueueReply(startTime, (Message)reply, jmsMessage.getJMSCorrelationID(), jmsReplyTo), e -> {
                throw new JMSMessageBusException("Unable to send to JMS reply", (Throwable)e);
            }));
        } else {
            builder.withNoReplyHandler("CONVERT JMS TO BRIDGE MESSAGE WITH HEADERS FOR NO JMS_REPLY_TO");
        }
        return builder.withCreator(this.name).build();
    }

    private void copyHeaders(MessageBuilder builder, javax.jms.Message jmsMessage) throws Exception {
        Enumeration propertyNames = jmsMessage.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (propertyName.startsWith("JMS")) continue;
            builder.withHeader(propertyName, jmsMessage.getObjectProperty(propertyName));
        }
        builder.withRedelivered(jmsMessage.getJMSRedelivered());
        builder.withDeliveryTime(jmsMessage.getJMSDeliveryTime());
        builder.withDeliveryMode(jmsMessage.getJMSDeliveryMode());
        builder.withType(jmsMessage.getJMSType());
        builder.withPriority(jmsMessage.getJMSPriority());
        builder.withExpirationTime(jmsMessage.getJMSExpiration());
        builder.withTimestamp(jmsMessage.getJMSTimestamp());
        builder.withCorrelationID(jmsMessage.getJMSCorrelationID());
    }
}

