/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.jms.support;

import io.nats.bridge.MessageBus;
import io.nats.bridge.TimeSource;
import io.nats.bridge.jms.JMSMessageBus;
import io.nats.bridge.jms.JMSMessageBusException;
import io.nats.bridge.jms.JmsContext;
import io.nats.bridge.jms.support.ConvertBridgeMessageToJmsMessage;
import io.nats.bridge.jms.support.ConvertBridgeMessageToJmsMessageWithHeaders;
import io.nats.bridge.jms.support.ConvertJmsMessageToBridgeMessage;
import io.nats.bridge.jms.support.ConvertJmsMessageToBridgeMessageWithHeaders;
import io.nats.bridge.jms.support.JMSMessageBusBuilderException;
import io.nats.bridge.jms.support.JMSReply;
import io.nats.bridge.messages.Message;
import io.nats.bridge.metrics.Metrics;
import io.nats.bridge.metrics.MetricsDisplay;
import io.nats.bridge.metrics.MetricsProcessor;
import io.nats.bridge.metrics.Output;
import io.nats.bridge.metrics.implementation.SimpleMetrics;
import io.nats.bridge.nats.support.NatsBuilderException;
import io.nats.bridge.support.MessageBusBuilder;
import io.nats.bridge.util.ExceptionHandler;
import io.nats.bridge.util.FunctionWithException;
import java.time.Duration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMSMessageBusBuilder
implements MessageBusBuilder {
    private final ExceptionHandler exceptionHandler = new ExceptionHandler(LoggerFactory.getLogger(JMSMessageBusBuilder.class));
    private Logger jmsBusLogger;
    private ConnectionFactory connectionFactory;
    private Destination destination;
    private Session session;
    private Connection connection;
    private String connectionFactoryName = "ConnectionFactory";
    private String destinationName;
    private int acknowledgeSessionMode = 1;
    private boolean transactionalSession = false;
    private Function<Connection, Session> sessionCreator;
    private Function<ConnectionFactory, Connection> connectionCreator;
    private String userNameConnection;
    private String passwordConnection;
    private Context context;
    private TimeSource timeSource;
    private Destination responseDestination;
    private MessageConsumer responseConsumer;
    private Supplier<MessageProducer> producerSupplier;
    private Supplier<MessageConsumer> consumerSupplier;
    private Metrics metrics;
    private MetricsProcessor metricsProcessor;
    private ExceptionHandler tryHandler;
    private FunctionWithException<javax.jms.Message, Message> jmsMessageConverter;
    private FunctionWithException<Message, javax.jms.Message> bridgeMessageConverter;
    private Queue<JMSReply> jmsReplyQueue;
    private boolean copyHeaders = false;
    private Hashtable<String, Object> jndiProperties = new Hashtable();
    private String name = "jms-no-name";
    private boolean ibmMQ = false;
    private String responseDestinationName = "TEMP_QUEUE";
    private boolean source = false;
    private Logger logger = LoggerFactory.getLogger(JMSMessageBusBuilder.class);
    private String ibmMQQueueModelName;
    private String ibmMQQueueModelPrefix;
    private String ibmMQQueueManager;
    private String ibmMQChannel;
    private boolean requestReply = true;

    public boolean isRequestReply() {
        return this.requestReply;
    }

    public JMSMessageBusBuilder withRequestReply(boolean requestReply) {
        this.requestReply = requestReply;
        return this;
    }

    public static JMSMessageBusBuilder builder() {
        return new JMSMessageBusBuilder();
    }

    public String getIbmMQQueueModelName() {
        if (this.ibmMQQueueModelName == null) {
            this.ibmMQQueueModelName = System.getenv().getOrDefault("NATS_BRIDGE_IBM_QUEUE_MODEL_NAME", "DEV.MODEL");
            this.logger.info("IBM QUEUE MODEL NAME WAS NOT SET SO USING ENV VAR NATS_BRIDGE_IBM_QUEUE_MODEL_NAME or default value of DEV.MODEL");
            this.logger.info("IBM QUEUE MODEL SET TO {}", (Object)this.ibmMQQueueModelName);
        }
        return this.ibmMQQueueModelName;
    }

    public JMSMessageBusBuilder withIbmMQQueueModelName(String ibmMQQueueModelName) {
        this.ibmMQQueueModelName = ibmMQQueueModelName;
        return this;
    }

    public String getIbmMQQueueModelPrefix() {
        if (this.ibmMQQueueModelPrefix == null) {
            this.ibmMQQueueModelPrefix = System.getenv().getOrDefault("NATS_BRIDGE_IBM_QUEUE_MODEL_PREFIX", "DEV*");
            this.logger.info("IBM QUEUE MODEL PREFIX WAS NOT SET SO USING ENV VAR NATS_BRIDGE_IBM_QUEUE_MODEL_PREFIX or default value of DEV*");
            this.logger.info("IBM QUEUE MODEL PREFIX SET TO {}", (Object)this.ibmMQQueueModelPrefix);
        }
        return this.ibmMQQueueModelPrefix;
    }

    public JMSMessageBusBuilder withIbmMQQueueModelPrefix(String ibmMQQueueModelPrefix) {
        this.ibmMQQueueModelPrefix = ibmMQQueueModelPrefix;
        return this;
    }

    public String getIbmMQQueueManager() {
        if (this.ibmMQQueueManager == null) {
            this.ibmMQQueueManager = System.getenv().getOrDefault("NATS_BRIDGE_IBM_MQ_QUEUE_MANAGER", "QM1");
            this.logger.info("IBM QUEUE MANAGER WAS NOT SET SO USING ENV VAR NATS_BRIDGE_IBM_MQ_QUEUE_MANAGER or default value of QM1");
            this.logger.info("IBM QUEUE MANAGER SET TO {}", (Object)this.ibmMQQueueManager);
        }
        return this.ibmMQQueueManager;
    }

    public JMSMessageBusBuilder withIbmMQQueueManager(String ibmMQQueueManager) {
        this.ibmMQQueueManager = ibmMQQueueManager;
        return this;
    }

    public String getIbmMQChannel() {
        if (this.ibmMQChannel == null) {
            this.ibmMQChannel = System.getenv().getOrDefault("NATS_BRIDGE_IBM_MQ_CHANNEL", "DEV.APP.SVRCONN");
            this.logger.info("IBM QUEUE CHANNEL WAS NOT SET SO USING ENV VAR NATS_BRIDGE_IBM_MQ_CHANNEL or default value of DEV.APP.SVRCONN");
            this.logger.info("IBM QUEUE MANAGER SET TO {}", (Object)this.ibmMQChannel);
        }
        return this.ibmMQChannel;
    }

    public JMSMessageBusBuilder withIbmMQChannel(String ibmMQChannel) {
        this.ibmMQChannel = ibmMQChannel;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JMSMessageBusBuilder asSource() {
        this.source = true;
        return this;
    }

    public JMSMessageBusBuilder withName(String name) {
        if (name == null) {
            throw new NatsBuilderException("Name must be set");
        }
        this.name = name;
        return this;
    }

    public FunctionWithException<Message, javax.jms.Message> getBridgeMessageConverter() {
        if (this.bridgeMessageConverter == null) {
            this.bridgeMessageConverter = this.isCopyHeaders() ? new ConvertBridgeMessageToJmsMessageWithHeaders(this.getSession()) : new ConvertBridgeMessageToJmsMessage(this.getSession());
        }
        return this.bridgeMessageConverter;
    }

    public JMSMessageBusBuilder withBridgeMessageConverter(FunctionWithException<Message, javax.jms.Message> bridgeMessageConverter) {
        this.bridgeMessageConverter = bridgeMessageConverter;
        return this;
    }

    public boolean isCopyHeaders() {
        return this.copyHeaders;
    }

    public JMSMessageBusBuilder turnOnCopyHeaders() {
        return this.withCopyHeaders(true);
    }

    public JMSMessageBusBuilder withCopyHeaders(boolean copyHeaders) {
        this.copyHeaders = copyHeaders;
        return this;
    }

    public Queue<JMSReply> getJmsReplyQueue() {
        if (this.jmsReplyQueue == null) {
            this.jmsReplyQueue = new LinkedTransferQueue<JMSReply>();
        }
        return this.jmsReplyQueue;
    }

    public JMSMessageBusBuilder withJmsReplyQueue(Queue<JMSReply> jmsReplyQueue) {
        this.jmsReplyQueue = jmsReplyQueue;
        return this;
    }

    public FunctionWithException<javax.jms.Message, Message> getJmsMessageConverter() {
        if (this.jmsMessageConverter == null) {
            this.jmsMessageConverter = !this.isCopyHeaders() ? new ConvertJmsMessageToBridgeMessage(this.getTryHandler(), this.getTimeSource(), this.getJmsReplyQueue(), "" + this.getName() + "_CONVERT_JMS_MESSAGE") : new ConvertJmsMessageToBridgeMessageWithHeaders(this.getTryHandler(), this.getTimeSource(), this.getJmsReplyQueue(), "" + this.getName() + "_CONVERT_JMS_MESSAGE_W_HEADERS");
        }
        return this.jmsMessageConverter;
    }

    public JMSMessageBusBuilder withJmsMessageConverter(FunctionWithException<javax.jms.Message, Message> messageConverter) {
        this.jmsMessageConverter = messageConverter;
        return this;
    }

    public JMSMessageBusBuilder withJndiProperty(String name, String value) {
        this.getJndiProperties().put(name, value);
        return this;
    }

    public JMSMessageBusBuilder withJndiProperties(Map<String, String> props) {
        this.getJndiProperties().putAll(props);
        return this;
    }

    public ExceptionHandler getTryHandler() {
        if (this.tryHandler == null) {
            this.tryHandler = new ExceptionHandler(this.getJmsBusLogger());
        }
        return this.tryHandler;
    }

    public JMSMessageBusBuilder withTryHandler(ExceptionHandler tryHandler) {
        this.tryHandler = tryHandler;
        return this;
    }

    public Logger getJmsBusLogger() {
        if (this.jmsBusLogger == null) {
            this.jmsBusLogger = LoggerFactory.getLogger((String)(JMSMessageBus.class.toString() + "_" + this.getName()));
        }
        return this.jmsBusLogger;
    }

    public JMSMessageBusBuilder withJmsBusLogger(Logger jmsBusLogger) {
        this.jmsBusLogger = jmsBusLogger;
        return this;
    }

    public MetricsProcessor getMetricsProcessor() {
        if (this.metricsProcessor == null) {
            this.metricsProcessor = new MetricsDisplay(new Output(){}, this.getMetrics(), 10, Duration.ofSeconds(10L), System::currentTimeMillis, this.name);
        }
        return this.metricsProcessor;
    }

    public JMSMessageBusBuilder withMetricsProcessor(MetricsProcessor metricsProcessor) {
        this.metricsProcessor = metricsProcessor;
        return this;
    }

    public Supplier<MessageProducer> getProducerSupplier() {
        if (this.producerSupplier == null) {
            this.producerSupplier = () -> this.getTryHandler().tryReturnOrRethrow(() -> this.getSession().createProducer(this.getDestination()), e -> new JMSMessageBusException("unable to create producer", (Throwable)e));
        }
        return this.producerSupplier;
    }

    public void withProducerSupplier(Supplier<MessageProducer> producerSupplier) {
        this.producerSupplier = producerSupplier;
    }

    public Supplier<MessageConsumer> getConsumerSupplier() {
        if (this.consumerSupplier == null) {
            this.consumerSupplier = () -> this.getTryHandler().tryReturnOrRethrow(() -> this.getSession().createConsumer(this.getDestination()), e -> new JMSMessageBusException("unable to create consumer", (Throwable)e));
        }
        return this.consumerSupplier;
    }

    public void withConsumerSupplier(Supplier<MessageConsumer> consumerSupplier) {
        this.consumerSupplier = consumerSupplier;
    }

    public Metrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = new SimpleMetrics(System::currentTimeMillis);
        }
        return this.metrics;
    }

    public JMSMessageBusBuilder withMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public Destination getResponseDestination() {
        if (this.responseDestination == null) {
            this.responseDestination = (Destination)this.exceptionHandler.tryReturnOrRethrow(() -> {
                if (this.getResponseDestinationName().equals("TEMP_QUEUE")) {
                    this.logger.info("Creating temp queue ");
                    return this.getSession().createTemporaryQueue();
                }
                this.logger.info("Creating response queue " + this.getResponseDestinationName());
                return this.getSession().createQueue(this.getResponseDestinationName());
            }, e -> new JMSMessageBusBuilderException("Unable to create JMS response queue " + this.getUserNameConnection(), (Throwable)e));
        }
        return this.responseDestination;
    }

    public JMSMessageBusBuilder withResponseDestination(Destination responseDestination) {
        this.responseDestination = responseDestination;
        return this;
    }

    public MessageConsumer getResponseConsumer() {
        if (this.responseConsumer == null) {
            this.responseConsumer = this.exceptionHandler.tryReturnOrRethrow(() -> this.getSession().createConsumer(this.getResponseDestination()), e -> new JMSMessageBusBuilderException("Unable to create JMS response consumer " + this.getUserNameConnection(), (Throwable)e));
        }
        return this.responseConsumer;
    }

    public JMSMessageBusBuilder withResponseConsumer(MessageConsumer responseConsumer) {
        this.responseConsumer = responseConsumer;
        return this;
    }

    public TimeSource getTimeSource() {
        if (this.timeSource == null) {
            this.timeSource = System::currentTimeMillis;
        }
        return this.timeSource;
    }

    public JMSMessageBusBuilder withTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    public String getUserNameConnection() {
        if (this.userNameConnection == null || this.userNameConnection.trim().isEmpty()) {
            this.userNameConnection = System.getenv("NATS_BRIDGE_JMS_USER");
        }
        return this.userNameConnection;
    }

    public JMSMessageBusBuilder withUserNameConnection(String userNameConnection) {
        this.userNameConnection = userNameConnection;
        return this;
    }

    public String getPasswordConnection() {
        if (this.passwordConnection == null) {
            this.passwordConnection = System.getenv("NATS_BRIDGE_JMS_PWD");
        }
        return this.passwordConnection;
    }

    public JMSMessageBusBuilder withPasswordConnection(String passwordConnection) {
        this.passwordConnection = passwordConnection;
        return this;
    }

    public Function<ConnectionFactory, Connection> getConnectionCreator() {
        if (this.connectionCreator == null) {
            this.connectionCreator = connectionFactory -> this.getTryHandler().tryReturnOrRethrow(() -> {
                Connection connection = this.getUserNameConnection() == null || this.getPasswordConnection() == null ? connectionFactory.createConnection() : connectionFactory.createConnection(this.getUserNameConnection(), this.getPasswordConnection());
                connection.start();
                return connection;
            }, e -> new JMSMessageBusBuilderException("Unable to create JMS connection " + this.getUserNameConnection(), (Throwable)e));
        }
        return this.connectionCreator;
    }

    public JMSMessageBusBuilder withConnectionCreator(Function<ConnectionFactory, Connection> connectionCreator) {
        this.connectionCreator = connectionCreator;
        return this;
    }

    public int getAcknowledgeSessionMode() {
        return this.acknowledgeSessionMode;
    }

    public JMSMessageBusBuilder withAcknowledgeSessionMode(int acknowledgeMode) {
        this.acknowledgeSessionMode = acknowledgeMode;
        return this;
    }

    public boolean isTransactionalSession() {
        return this.transactionalSession;
    }

    public JMSMessageBusBuilder withTransactionalSession(boolean transactionalSession) {
        this.transactionalSession = transactionalSession;
        return this;
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = this.exceptionHandler.tryReturnOrRethrow(() -> new InitialContext(this.getJndiProperties()), e -> new JMSMessageBusBuilderException("Unable to create JNDI context", (Throwable)e));
        }
        return this.context;
    }

    public JMSMessageBusBuilder withContext(Context context) {
        this.context = context;
        return this;
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactory == null) {
            this.connectionFactory = this.exceptionHandler.tryReturnOrRethrow(() -> (ConnectionFactory)this.getContext().lookup(this.getConnectionFactoryName()), e -> new JMSMessageBusBuilderException("Unable to lookup connection factory " + this.getConnectionFactoryName(), (Throwable)e));
        }
        return this.connectionFactory;
    }

    public JMSMessageBusBuilder withConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        return this;
    }

    public Destination getDestination() {
        if (this.destination == null) {
            this.destination = !this.ibmMQ ? this.exceptionHandler.tryReturnOrRethrow(() -> (Destination)this.getContext().lookup(this.getDestinationName()), e -> new JMSMessageBusBuilderException("Unable to lookup destination " + this.getDestinationName(), (Throwable)e)) : (Destination)this.exceptionHandler.tryReturnOrRethrow(() -> this.getSessionCreator().apply(this.getConnection()).createQueue(this.getDestinationName()), e -> new JMSMessageBusBuilderException("Unable to lookup destination " + this.getDestinationName(), (Throwable)e));
        }
        return this.destination;
    }

    public JMSMessageBusBuilder withDestination(Destination destination) {
        this.destination = destination;
        return this;
    }

    public Session getSession() {
        if (this.session == null) {
            this.session = this.getSessionCreator().apply(this.getConnection());
        }
        return this.session;
    }

    public JMSMessageBusBuilder withSession(Session session) {
        this.session = session;
        return this;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            this.connection = this.getConnectionCreator().apply(this.getConnectionFactory());
        }
        return this.connection;
    }

    public JMSMessageBusBuilder withConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public JMSMessageBusBuilder withConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
        return this;
    }

    public String getResponseDestinationName() {
        return this.responseDestinationName;
    }

    public JMSMessageBusBuilder withResponseDestinationName(String replyDestinationName) {
        this.responseDestinationName = replyDestinationName;
        return this;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public JMSMessageBusBuilder withDestinationName(String destinationName) {
        this.destinationName = destinationName;
        return this;
    }

    public Function<Connection, Session> getSessionCreator() {
        if (this.sessionCreator == null) {
            this.sessionCreator = connection -> this.getTryHandler().tryReturnOrRethrow(() -> connection.createSession(this.isTransactionalSession(), this.getAcknowledgeSessionMode()), e -> new JMSMessageBusBuilderException("Unable to create session", (Throwable)e));
        }
        return this.sessionCreator;
    }

    public JMSMessageBusBuilder withSessionCreator(Function<Connection, Session> sessionCreator) {
        this.sessionCreator = sessionCreator;
        return this;
    }

    public Supplier<JmsContext> buildJmsSupplier() {
        return new Supplier<JmsContext>(){

            @Override
            public JmsContext get() {
                JMSMessageBusBuilder.this.connection = null;
                JMSMessageBusBuilder.this.session = null;
                JMSMessageBusBuilder.this.destination = null;
                JMSMessageBusBuilder.this.responseDestination = null;
                JMSMessageBusBuilder.this.producerSupplier = null;
                JMSMessageBusBuilder.this.consumerSupplier = null;
                JMSMessageBusBuilder.this.responseConsumer = null;
                if (JMSMessageBusBuilder.this.isRequestReply()) {
                    return new JmsContext(JMSMessageBusBuilder.this.getDestination(), JMSMessageBusBuilder.this.getSession(), JMSMessageBusBuilder.this.getConnection(), JMSMessageBusBuilder.this.getResponseDestination(), JMSMessageBusBuilder.this.source ? null : JMSMessageBusBuilder.this.getResponseConsumer(), JMSMessageBusBuilder.this.getProducerSupplier(), JMSMessageBusBuilder.this.getConsumerSupplier(), JMSMessageBusBuilder.this.getJmsBusLogger());
                }
                return new JmsContext(JMSMessageBusBuilder.this.getDestination(), JMSMessageBusBuilder.this.getSession(), JMSMessageBusBuilder.this.getConnection(), null, null, JMSMessageBusBuilder.this.getProducerSupplier(), JMSMessageBusBuilder.this.getConsumerSupplier(), JMSMessageBusBuilder.this.getJmsBusLogger());
            }
        };
    }

    @Override
    public MessageBus build() {
        if (this.getConnectionFactory() != null && this.getConnectionFactory().getClass().getPackage().getName().contains("io.nats.bridge.integration.ibmmq")) {
            this.ibmMQ = true;
        }
        Supplier<JmsContext> jmsContextSupplier = this.buildJmsSupplier();
        return new JMSMessageBus(this.getName(), this.getTimeSource(), this.getMetrics(), this.getMetricsProcessor(), this.getTryHandler(), this.getJmsBusLogger(), this.getJmsReplyQueue(), this.getJmsMessageConverter(), this.getBridgeMessageConverter(), this.getDestinationName(), jmsContextSupplier);
    }

    public JMSMessageBusBuilder useIBMMQ(Hashtable<String, Object> jndiProperties) {
        this.getJmsBusLogger().info("CLEARING JNDI PROPERTIES");
        this.ibmMQ = true;
        this.jndiProperties.clear();
        jndiProperties.put("java.naming.factory.initial", System.getenv().getOrDefault("NATS_BRIDGE_JMS_NAMING_FACTORY", "io.nats.bridge.integration.ibmmq.IbmMqInitialContextFactory"));
        this.jndiProperties.putAll(jndiProperties);
        return this;
    }

    public JMSMessageBusBuilder useIBMMQ() {
        this.getJmsBusLogger().info("Setting JNDI PROPERTIES for IBM");
        this.ibmMQ = true;
        String queueManager = this.getIbmMQQueueManager();
        String channel = this.getIbmMQChannel();
        this.getJmsBusLogger().info("Setting JNDI PROPERTIES for IBM {} {}", (Object)queueManager, (Object)channel);
        this.jndiProperties.put("java.naming.factory.initial", System.getenv().getOrDefault("NATS_BRIDGE_JMS_NAMING_FACTORY", "io.nats.bridge.integration.ibmmq.IbmMqInitialContextFactory"));
        String connectionListKey = "nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST";
        if (!this.jndiProperties.containsKey("nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST")) {
            this.getJmsBusLogger().info("Connection List was not set so we are using nats.ibm.mq.host");
            String hostName = System.getenv().getOrDefault("NATS_BRIDGE_IBM_MQ_HOST", "tcp://localhost:1414");
            this.jndiProperties.put("nats.ibm.mq.host", hostName);
            this.getJmsBusLogger().info("JUST SET nats.ibm.mq.host to {}", (Object)hostName);
        } else {
            this.getJmsBusLogger().info("Using IBM Connection List key={} value={}", (Object)"nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST", this.jndiProperties.get("nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST"));
        }
        if (!this.jndiProperties.containsKey("nats.ibm.mq.channel")) {
            this.jndiProperties.put("nats.ibm.mq.channel", channel);
        } else {
            this.logger.info("IBM MQ CHANNEL IS {}", this.jndiProperties.get("nats.ibm.mq.channel"));
        }
        if (!this.jndiProperties.containsKey("nats.ibm.mq.queueManager")) {
            this.jndiProperties.put("nats.ibm.mq.queueManager", queueManager);
        } else {
            this.logger.info("IBM MQ QUEUE MANAGER IS {}", this.jndiProperties.get("nats.ibm.mq.queueManager"));
        }
        if (this.isRequestReply()) {
            String queueModelName = this.getIbmMQQueueModelName();
            String queueModelPrefix = this.getIbmMQQueueModelPrefix();
            this.jndiProperties.put("nats.ibm.mq.queueModelName", queueModelName);
            this.jndiProperties.put("nats.ibm.mq.queueModelPrefix", queueModelPrefix);
        }
        return this;
    }

    public JMSMessageBusBuilder useActiveMQ() {
        this.getJmsBusLogger().info("Setting JNDI PROPERTIES for ActiveMq");
        String queueManager = this.getIbmMQQueueManager();
        String channel = this.getIbmMQChannel();
        this.getJmsBusLogger().info("Setting JNDI PROPERTIES for IBM {} {}", (Object)queueManager, (Object)channel);
        this.jndiProperties.put("java.naming.factory.initial", System.getenv().getOrDefault("NATS_BRIDGE_JMS_NAMING_FACTORY", "io.nats.bridge.integration.ibmmq.IbmMqInitialContextFactory"));
        String connectionListKey = "nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST";
        if (!this.jndiProperties.containsKey("nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST")) {
            this.getJmsBusLogger().info("Connection List was not set so we are using nats.ibm.mq.host");
            String hostName = System.getenv().getOrDefault("NATS_BRIDGE_IBM_MQ_HOST", "tcp://localhost:1414");
            this.jndiProperties.put("nats.ibm.mq.host", hostName);
            this.getJmsBusLogger().info("JUST SET nats.ibm.mq.host to {}", (Object)hostName);
        } else {
            this.getJmsBusLogger().info("Using IBM Connection List key={} value={}", (Object)"nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST", this.jndiProperties.get("nats.ibm.mq.jms.prop.string.XMSC_WMQ_CONNECTION_NAME_LIST"));
        }
        if (!this.jndiProperties.containsKey("nats.ibm.mq.channel")) {
            this.jndiProperties.put("nats.ibm.mq.channel", channel);
        } else {
            this.logger.info("IBM MQ CHANNEL IS {}", this.jndiProperties.get("nats.ibm.mq.channel"));
        }
        if (!this.jndiProperties.containsKey("nats.ibm.mq.queueManager")) {
            this.jndiProperties.put("nats.ibm.mq.queueManager", queueManager);
        } else {
            this.logger.info("IBM MQ QUEUE MANAGER IS {}", this.jndiProperties.get("nats.ibm.mq.queueManager"));
        }
        if (this.isRequestReply()) {
            String queueModelName = this.getIbmMQQueueModelName();
            String queueModelPrefix = this.getIbmMQQueueModelPrefix();
            this.jndiProperties.put("nats.ibm.mq.queueModelName", queueModelName);
            this.jndiProperties.put("nats.ibm.mq.queueModelPrefix", queueModelPrefix);
        }
        return this;
    }

    public Hashtable<String, Object> getJndiProperties() {
        if (this.jndiProperties.size() == 0) {
            this.jndiProperties.put("java.naming.factory.initial", System.getenv().getOrDefault("NATS_BRIDGE_JMS_NAMING_FACTORY", "org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory"));
            this.jndiProperties.put("connectionFactory.ConnectionFactory", System.getenv().getOrDefault("NATS_BRIDGE_JMS_CONNECTION_FACTORY", "tcp://localhost:61616"));
            this.jndiProperties.put("queue.queue/testQueue", System.getenv().getOrDefault("NATS_BRIDGE_JMS_QUEUE", "queue.queue/testQueue=testQueue"));
        }
        return this.jndiProperties;
    }

    public JMSMessageBusBuilder setJndiProperties(Hashtable<String, Object> jndiProperties) {
        this.jndiProperties = jndiProperties;
        return this;
    }
}

