/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.metrics.implementation;

import io.nats.bridge.TimeSource;
import io.nats.bridge.metrics.GetMetric;
import io.nats.bridge.metrics.MetricId;
import io.nats.bridge.metrics.TimeTracker;
import java.util.Map;

public class SimpleTimeTracker
implements MetricId,
TimeTracker,
GetMetric {
    private final String name;
    private long timeHolder;
    private final TimeSource timeSource;
    private final Map<String, String> tags;
    private final String id;

    public SimpleTimeTracker(String name, TimeSource timeSource, Map<String, String> tags, String id) {
        this.name = name;
        this.timeSource = timeSource;
        this.tags = tags;
        this.id = id;
    }

    @Override
    public long getValue() {
        return this.timeHolder;
    }

    @Override
    public String metricName() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Map<String, String> dimensions() {
        return this.tags;
    }

    @Override
    public void recordTiming(long duration) {
        this.timeHolder = duration;
    }

    @Override
    public void recordTiming(Runnable runnable) {
        long startTime = this.timeSource.getTime();
        runnable.run();
        long endTime = this.timeSource.getTime();
        this.recordTiming(endTime - startTime);
    }

    public String toString() {
        return String.format("%30s %10d", this.metricName(), this.getValue());
    }
}

