/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.nats.support;

import io.nats.bridge.TimeSource;
import io.nats.bridge.metrics.Metrics;
import io.nats.bridge.metrics.MetricsDisplay;
import io.nats.bridge.metrics.MetricsProcessor;
import io.nats.bridge.metrics.Output;
import io.nats.bridge.metrics.implementation.SimpleMetrics;
import io.nats.bridge.nats.NatsMessageBus;
import io.nats.bridge.nats.support.NatsBuilderException;
import io.nats.bridge.support.MessageBusBuilder;
import io.nats.bridge.tls.SslContextBuilder;
import io.nats.bridge.util.ExceptionHandler;
import io.nats.client.Connection;
import io.nats.client.Consumer;
import io.nats.client.ErrorListener;
import io.nats.client.Nats;
import io.nats.client.Options;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.LinkedTransferQueue;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NatsMessageBusBuilder
implements MessageBusBuilder {
    private List<String> servers = new ArrayList<String>();
    private Connection connection;
    private String subject;
    private String name = "nats-no-name";
    private ExceptionHandler tryHandler;
    private Options options;
    private Options.Builder optionsBuilder;
    private Properties optionProperties;
    private char[] user;
    private char[] password;
    private TimeSource timeSource;
    private Metrics metrics;
    private MetricsProcessor metricsProcessor;
    public static final String PFX_TLS = "io.nats.client.tls.";
    public static final String JSSL_ENABLE = "io.nats.client.tls.jssl.enable";
    public static final String JSSL_TRUST_STORE_PATH = "io.nats.client.tls.truststore.path";
    public static final String JSSL_KEY_STORE_PATH = "io.nats.client.tls.keystore.path";
    public static final String JSSL_ALGORITHM = "io.nats.client.tls.algorithm";
    public static final String JSSL_KEY_STORE_PWD = "io.nats.client.tls.keystore.password";
    public static final String JSSL_KEY_STORE_ALIAS = "io.nats.client.tls.keystore.alias";
    public static final String JSSL_TRUST_STORE_PWD = "io.nats.client.tls.truststore.password";
    public static final String JSSL_KEYSTORE_ENV_VAR_VALUE = "io.nats.client.tls.keystore.env_var.value";
    public static final String JSSL_KEYSTORE_ENV_VAR_PATH = "io.nats.client.tls.keystore.env_var.path";
    public static final String JSSL_TRUSTSTORE_ENV_VAR_VALUE = "io.nats.client.tls.truststore.env_var.value";
    public static final String JSSL_TRUSTSTORE_ENV_VAR_PATH = "io.nats.client.tls.truststore.env_var.path";
    private Queue<NatsMessageBus.NatsReply> replyQueue;
    private Queue<NatsMessageBus.NatsReply> replyQueueNotDone;
    private String queueGroup;
    private SslContextBuilder sslContextBuilder;
    private SSLContext sslContext;
    private boolean useTls;
    private Duration durationConnectionsMetrics;

    public boolean isUseTls() {
        if (this.getOptionProperties().size() > 0 && this.getOptionProperties().get(JSSL_ENABLE) != null) {
            this.useTls = Boolean.parseBoolean(this.getOptionProperties().getProperty(JSSL_ENABLE, "false"));
        }
        return this.useTls;
    }

    public NatsMessageBusBuilder withUseTls(boolean useTls) {
        this.useTls = useTls;
        return this;
    }

    public static NatsMessageBusBuilder builder() {
        return new NatsMessageBusBuilder();
    }

    public SslContextBuilder getSslContextBuilder() {
        if (this.sslContextBuilder == null) {
            this.sslContextBuilder = new SslContextBuilder();
            if (this.getOptionProperties().getProperty(JSSL_KEY_STORE_PATH) != null) {
                this.sslContextBuilder.withKeystorePath(this.getOptionProperties().getProperty(JSSL_KEY_STORE_PATH));
            }
            if (this.getOptionProperties().getProperty(JSSL_TRUST_STORE_PATH) != null) {
                this.sslContextBuilder.withTruststorePath(this.getOptionProperties().getProperty(JSSL_TRUST_STORE_PATH));
            }
            if (this.getOptionProperties().getProperty(JSSL_TRUST_STORE_PWD) != null) {
                this.sslContextBuilder.withStorePassword(this.getOptionProperties().getProperty(JSSL_TRUST_STORE_PWD));
            }
            if (this.getOptionProperties().getProperty(JSSL_KEY_STORE_PWD) != null) {
                this.sslContextBuilder.withKeyPassword(this.getOptionProperties().getProperty(JSSL_KEY_STORE_PWD));
            }
            if (this.getOptionProperties().getProperty(JSSL_KEY_STORE_ALIAS) != null) {
                this.sslContextBuilder.withKeyStoreAlias(this.getOptionProperties().getProperty(JSSL_KEY_STORE_ALIAS));
            }
            if (this.getOptionProperties().getProperty(JSSL_ALGORITHM) != null) {
                this.sslContextBuilder.withAlgorithm(this.getOptionProperties().getProperty(JSSL_ALGORITHM));
            }
            if (this.getOptionProperties().getProperty(JSSL_KEYSTORE_ENV_VAR_PATH) != null) {
                this.sslContextBuilder.withKeyStorePathEnvVariable(this.getOptionProperties().getProperty(JSSL_KEYSTORE_ENV_VAR_PATH));
            }
            if (this.getOptionProperties().getProperty(JSSL_KEYSTORE_ENV_VAR_VALUE) != null) {
                this.sslContextBuilder.withKeyStoreValueEnvVariable(this.getOptionProperties().getProperty(JSSL_KEYSTORE_ENV_VAR_VALUE));
            }
            if (this.getOptionProperties().getProperty(JSSL_TRUSTSTORE_ENV_VAR_PATH) != null) {
                this.sslContextBuilder.withTrustStorePathEnvVariable(this.getOptionProperties().getProperty(JSSL_TRUSTSTORE_ENV_VAR_PATH));
            }
            if (this.getOptionProperties().getProperty(JSSL_TRUSTSTORE_ENV_VAR_VALUE) != null) {
                this.sslContextBuilder.withTrustStoreValueEnvVariable(this.getOptionProperties().getProperty(JSSL_TRUSTSTORE_ENV_VAR_VALUE));
            }
        }
        return this.sslContextBuilder;
    }

    public NatsMessageBusBuilder setSslContextBuilder(SslContextBuilder sslContextBuilder) {
        this.sslContextBuilder = sslContextBuilder;
        return this;
    }

    public SSLContext getSslContext() {
        if (this.sslContext == null) {
            this.sslContext = this.getSslContextBuilder().build();
        }
        return this.sslContext;
    }

    public NatsMessageBusBuilder withSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Metrics getMetrics() {
        if (this.metrics == null) {
            this.metrics = new SimpleMetrics(System::currentTimeMillis);
        }
        return this.metrics;
    }

    public NatsMessageBusBuilder withMetrics(Metrics metrics) {
        this.metrics = metrics;
        return this;
    }

    public MetricsProcessor getMetricsProcessor() {
        if (this.metricsProcessor == null) {
            this.metricsProcessor = new MetricsDisplay(new Output(){}, this.getMetrics(), 10, Duration.ofSeconds(10L), System::currentTimeMillis, this.name);
        }
        return this.metricsProcessor;
    }

    public NatsMessageBusBuilder withMetricsProcessor(MetricsProcessor metricsProcessor) {
        this.metricsProcessor = metricsProcessor;
        return this;
    }

    public Queue<NatsMessageBus.NatsReply> getReplyQueue() {
        if (this.replyQueue == null) {
            this.replyQueue = new LinkedTransferQueue<NatsMessageBus.NatsReply>();
        }
        return this.replyQueue;
    }

    public NatsMessageBusBuilder withReplyQueue(Queue<NatsMessageBus.NatsReply> replyQueueNotDone) {
        this.replyQueue = this.replyQueue;
        return this;
    }

    public Queue<NatsMessageBus.NatsReply> getReplyQueueNotDone() {
        if (this.replyQueueNotDone == null) {
            this.replyQueueNotDone = new LinkedTransferQueue<NatsMessageBus.NatsReply>();
        }
        return this.replyQueueNotDone;
    }

    public NatsMessageBusBuilder withReplyQueueNotDone(Queue<NatsMessageBus.NatsReply> replyQueueNotDone) {
        this.replyQueueNotDone = replyQueueNotDone;
        return this;
    }

    public TimeSource getTimeSource() {
        if (this.timeSource == null) {
            this.timeSource = System::currentTimeMillis;
        }
        return this.timeSource;
    }

    public NatsMessageBusBuilder withTimeSource(TimeSource timeSource) {
        this.timeSource = timeSource;
        return this;
    }

    public char[] getUser() {
        return this.user;
    }

    public NatsMessageBusBuilder withUser(String user) {
        this.user = user.toCharArray();
        return this;
    }

    public char[] getPassword() {
        return this.password;
    }

    public NatsMessageBusBuilder withPassword(String password) {
        this.password = password.toCharArray();
        return this;
    }

    public Properties getOptionProperties() {
        if (this.optionProperties == null) {
            this.optionProperties = new Properties();
        }
        return this.optionProperties;
    }

    public NatsMessageBusBuilder withOptionProperties(Properties properties) {
        this.optionProperties = properties;
        return this;
    }

    public String getQueueGroup() {
        if (this.queueGroup == null) {
            this.queueGroup = "queueGroup" + UUID.randomUUID().toString() + "_" + System.currentTimeMillis();
        }
        return this.queueGroup;
    }

    public NatsMessageBusBuilder withQueueGroup(String queueGroup) {
        this.queueGroup = queueGroup;
        return this;
    }

    public List<String> getServers() {
        if (this.servers.isEmpty()) {
            String hosts = System.getenv().getOrDefault("NATS_BRIDGE_NATS_SERVERS", "nats://localhost:4222");
            if (!hosts.contains(",")) {
                this.servers.add(hosts);
            } else {
                Collections.addAll(this.servers, hosts.split(","));
            }
        }
        return this.servers;
    }

    public NatsMessageBusBuilder withHost(String host) {
        this.servers.add(host);
        return this;
    }

    public NatsMessageBusBuilder withServers(List<String> servers) {
        this.servers.addAll(servers);
        return this;
    }

    public Connection getConnection() {
        if (this.connection == null) {
            try {
                this.connection = Nats.connect((Options)this.getOptions());
            }
            catch (Exception e) {
                throw new NatsBuilderException("Issues getting connection", e);
            }
        }
        return this.connection;
    }

    public NatsMessageBusBuilder withConnection(Connection connection) {
        this.connection = connection;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public NatsMessageBusBuilder withName(String name) {
        if (name == null) {
            throw new NatsBuilderException("Name must be set");
        }
        this.name = name;
        return this;
    }

    public String getSubject() {
        return this.subject;
    }

    public NatsMessageBusBuilder withSubject(String subject) {
        if (subject == null) {
            throw new NatsBuilderException("Subject must be set");
        }
        this.subject = subject;
        return this;
    }

    public ExceptionHandler getTryHandler() {
        if (this.tryHandler == null) {
            this.tryHandler = new ExceptionHandler(LoggerFactory.getLogger(NatsMessageBus.class));
        }
        return this.tryHandler;
    }

    public NatsMessageBusBuilder withTryHandler(ExceptionHandler tryHandler) {
        this.tryHandler = tryHandler;
        return this;
    }

    public Options getOptions() {
        if (this.options == null) {
            this.options = this.getOptionsBuilder().build();
        }
        return this.options;
    }

    public Options.Builder getOptionsBuilder() {
        if (this.optionsBuilder == null) {
            this.optionsBuilder = this.optionProperties == null ? new Options.Builder().servers(this.getServers().toArray(new String[1])) : new Options.Builder(this.getOptionProperties()).servers(this.getServers().toArray(new String[1]));
            if (this.password != null && this.user != null) {
                this.optionsBuilder.userInfo(this.user, this.password);
            }
            if (this.isUseTls()) {
                this.optionsBuilder.sslContext(this.getSslContext());
            }
            final Logger logger = LoggerFactory.getLogger(NatsMessageBus.class);
            this.optionsBuilder.errorListener(new ErrorListener(){

                public void errorOccurred(Connection conn, String error) {
                    logger.error("Error Occurred with NATS: {} with the bus {}", (Object)error, (Object)NatsMessageBusBuilder.this.name);
                }

                public void exceptionOccurred(Connection conn, Exception exp) {
                    logger.error("Exception Occurred with NATS:", (Throwable)exp);
                    logger.error("Exception Occurred with NATS: {} with the bus {}", (Object)exp.getLocalizedMessage(), (Object)NatsMessageBusBuilder.this.name);
                }

                public void slowConsumerDetected(Connection conn, Consumer consumer) {
                    logger.warn("Slow Consumer Detected {}", (Object)NatsMessageBusBuilder.this.name);
                }
            });
        }
        return this.optionsBuilder;
    }

    public NatsMessageBusBuilder withOptionsBuilder(Options.Builder optionsBuilder) {
        this.optionsBuilder = optionsBuilder;
        return this;
    }

    public NatsMessageBusBuilder withOptions(Options options) {
        this.options = options;
        return this;
    }

    public Duration getDurationConnectionsMetrics() {
        if (this.durationConnectionsMetrics == null) {
            this.durationConnectionsMetrics = Duration.ofSeconds(30L);
        }
        return this.durationConnectionsMetrics;
    }

    public NatsMessageBusBuilder withDurationConnectionsMetrics(Duration durationConnectionsMetrics) {
        this.durationConnectionsMetrics = durationConnectionsMetrics;
        return this;
    }

    @Override
    public NatsMessageBus build() {
        return new NatsMessageBus(this.getName(), this.getSubject(), this.getConnection(), this.getQueueGroup(), this.getTryHandler(), this.getReplyQueue(), this.getReplyQueueNotDone(), this.getTimeSource(), this.getMetrics(), this.getMetricsProcessor(), this.getDurationConnectionsMetrics());
    }
}

