/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.task;

import io.nats.bridge.MessageBridge;
import io.nats.bridge.task.ProcessNotifier;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;

public class BridgeTaskRunner {
    private final List<MessageBridge> messageBridges;
    private final ProcessNotifier processNotifier;
    private final Duration pollDuration;
    private final Logger logger;
    private final String name;

    public BridgeTaskRunner(List<MessageBridge> messageBridges, ProcessNotifier processNotifier, Duration pollDuration, Logger logger, String name) {
        this.messageBridges = messageBridges;
        this.processNotifier = processNotifier;
        this.pollDuration = pollDuration;
        this.logger = logger;
        this.name = name;
    }

    public boolean isHealthy() {
        return !this.processNotifier.wasError();
    }

    public void process() {
        this.processNotifier.notifyStarted();
        int count = 0;
        boolean pause = false;
        this.logger.info("BridgeTaskRunner starting processing loop {}", (Object)this.name);
        try {
            while (this.processNotifier.keepRunning()) {
                for (int index = 0; index < 100; ++index) {
                    for (MessageBridge messageBridge : this.messageBridges) {
                        if (pause) {
                            count += messageBridge.process(this.pollDuration);
                            continue;
                        }
                        count += messageBridge.process();
                    }
                    pause = count == 0;
                    count = 0;
                }
            }
            this.logger.info("BridgeTaskRunner exited loop {}", (Object)this.name);
            this.cleanUp();
            this.processNotifier.notifyStopped();
        }
        catch (Exception ex) {
            this.logger.error(String.format("Bridge Task Runner %s Stopped by Exception %s", this.name, ex.getClass().getSimpleName()), (Throwable)ex);
            this.processNotifier.notifyStoppedByException(ex);
        }
        catch (Throwable ex) {
            this.logger.error(String.format("Bridge Task Runner %s Stopped by Error %s", this.name, ex.getClass().getSimpleName()), ex);
            this.processNotifier.notifyStoppedByError(ex);
        }
    }

    private void cleanUp() {
        this.messageBridges.forEach(messageBridge -> {
            try {
                messageBridge.close();
            }
            catch (Exception ex) {
                this.logger.error("Issue closing bridge", (Throwable)ex);
            }
        });
    }
}

