/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.task;

import io.nats.bridge.MessageBridge;
import io.nats.bridge.task.BridgeTaskRunner;
import io.nats.bridge.task.ProcessNotifier;
import java.time.Duration;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeTaskRunnerBuilder {
    private List<MessageBridge> messageBridges;
    private ProcessNotifier processNotifier;
    private Duration pollDuration;
    private Logger logger;
    private String name;
    private int worker;

    public int getWorker() {
        return this.worker;
    }

    public BridgeTaskRunnerBuilder withWorker(int worker) {
        this.worker = worker;
        return this;
    }

    public List<MessageBridge> getMessageBridges() {
        return this.messageBridges;
    }

    public BridgeTaskRunnerBuilder withMessageBridges(List<MessageBridge> messageBridges) {
        this.messageBridges = messageBridges;
        return this;
    }

    public ProcessNotifier getProcessNotifier() {
        return this.processNotifier;
    }

    public BridgeTaskRunnerBuilder withProcessNotifier(ProcessNotifier processNotifier) {
        this.processNotifier = processNotifier;
        return this;
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public BridgeTaskRunnerBuilder withPollDuration(Duration pollDuration) {
        this.pollDuration = pollDuration;
        return this;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)(BridgeTaskRunner.class.toString() + "." + this.name + "." + this.worker));
        }
        return this.logger;
    }

    public BridgeTaskRunnerBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public BridgeTaskRunnerBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public BridgeTaskRunner build() {
        return new BridgeTaskRunner(this.getMessageBridges(), this.getProcessNotifier(), this.getPollDuration(), this.getLogger(), this.getName());
    }

    public static BridgeTaskRunnerBuilder builder() {
        return new BridgeTaskRunnerBuilder();
    }
}

