/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.task;

import io.nats.bridge.task.ProcessNotifier;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;

public class NonResumeProcessNotifier
implements ProcessNotifier {
    private boolean started;
    private boolean stopped;
    private final AtomicBoolean healthy = new AtomicBoolean(true);
    private final String name;
    private final int worker;
    private final AtomicBoolean stop;
    private final Logger logger;
    private final AtomicInteger startedCount;
    private final AtomicReference<Exception> lastError;

    public NonResumeProcessNotifier(String name, int worker, AtomicBoolean stop, Logger logger, AtomicInteger startedCount, AtomicReference<Exception> lastError) {
        this.name = name;
        this.worker = worker;
        this.stop = stop;
        this.logger = logger;
        this.startedCount = startedCount;
        this.lastError = lastError;
    }

    @Override
    public boolean stopRunning() {
        return this.stop.get();
    }

    @Override
    public void notifyStopped() {
        this.stopped = true;
        this.logger.info("Worker stopped {} {}", (Object)this.name, (Object)this.worker);
    }

    @Override
    public void notifyStoppedByException(Exception ex) {
        this.logger.error("Worker sent an exception {} {} {}", new Object[]{this.name, this.worker, ex});
        this.lastError.set(ex);
        this.healthy.set(false);
    }

    @Override
    public void notifyStoppedByError(Throwable ex) {
        this.logger.error("Worker sent an ERROR {} {} {}", new Object[]{this.name, this.worker, ex});
        this.logger.error("ERROR ", ex);
        this.healthy.set(false);
    }

    @Override
    public void notifyStarted() {
        this.started = true;
        this.logger.info("Worker sent a start signal {} {}", (Object)this.name, (Object)this.worker);
        this.startedCount.incrementAndGet();
    }

    @Override
    public boolean wasStarted() {
        return this.started;
    }

    @Override
    public boolean wasStopped() {
        return this.stopped;
    }

    @Override
    public boolean wasError() {
        return !this.healthy.get();
    }
}

