/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.tls;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

class SSLUtils {
    SSLUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore loadKeystore(String path, String storePassword, String storeAlias) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(path));){
            store.load(in, storePassword.toCharArray());
        }
        store.aliases().equals(storeAlias);
        return store;
    }

    public static KeyManager[] createTestKeyManagers(String keystorePath, String algorithm, String keyPassword, String storePassword, String storeAlias) throws Exception {
        KeyStore store = SSLUtils.loadKeystore(keystorePath, storePassword, storeAlias);
        KeyManagerFactory factory = KeyManagerFactory.getInstance(algorithm);
        factory.init(store, keyPassword.toCharArray());
        return factory.getKeyManagers();
    }

    public static TrustManager[] createTestTrustManagers(String truststorePath, String algorithm, String storePassword, String storeAlias) throws Exception {
        KeyStore store = SSLUtils.loadKeystore(truststorePath, storePassword, storeAlias);
        TrustManagerFactory factory = TrustManagerFactory.getInstance(algorithm);
        factory.init(store);
        return factory.getTrustManagers();
    }

    public static SSLContext createSSLContext(String truststorePath, String keystorePath, String algorithm, String keyPassword, String storePassword, String storeAlias) throws Exception {
        SSLContext ctx = SSLContext.getInstance("TLSv1.2");
        ctx.init(SSLUtils.createTestKeyManagers(keystorePath, algorithm, keyPassword, storePassword, storeAlias), SSLUtils.createTestTrustManagers(truststorePath, algorithm, storePassword, storeAlias), new SecureRandom());
        return ctx;
    }
}

