/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.tls;

import io.nats.bridge.tls.SSLUtils;
import io.nats.bridge.tls.SslContextBuilderException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Base64;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SslContextBuilder {
    private String truststorePath;
    private String keystorePath;
    private String algorithm;
    private char[] keystorePassword;
    private char[] trustStorePassword;
    private TrustManager[] trustStoreKeyManagers;
    private KeyManager[] keyStoreKeyManagers;
    private String trustStoreValueEnvVariable = "TRUSTSTORE";
    private String keyStoreValueEnvVariable = "KEYSTORE";
    private String trustStorePathEnvVariable = "TRUSTSTORE_PATH";
    private String keyStorePathEnvVariable = "KEYSTORE_PATH";
    private String keyStoreAlias;

    public String getTrustStoreValueEnvVariable() {
        return this.trustStoreValueEnvVariable;
    }

    public SslContextBuilder withTrustStoreValueEnvVariable(String trustStoreValueEnvVariable) {
        this.trustStoreValueEnvVariable = trustStoreValueEnvVariable;
        return this;
    }

    public String getKeyStoreValueEnvVariable() {
        return this.keyStoreValueEnvVariable;
    }

    public SslContextBuilder withKeyStoreValueEnvVariable(String keyStoreValueEnvVariable) {
        this.keyStoreValueEnvVariable = keyStoreValueEnvVariable;
        return this;
    }

    public String getTrustStorePathEnvVariable() {
        return this.trustStorePathEnvVariable;
    }

    public SslContextBuilder withTrustStorePathEnvVariable(String trustStorePathEnvVariable) {
        this.trustStorePathEnvVariable = trustStorePathEnvVariable;
        return this;
    }

    public String getKeyStorePathEnvVariable() {
        return this.keyStorePathEnvVariable;
    }

    public SslContextBuilder withKeyStorePathEnvVariable(String keyStorePathEnvVariable) {
        this.keyStorePathEnvVariable = keyStorePathEnvVariable;
        return this;
    }

    public String getKeyStoreAlias() {
        return this.keyStoreAlias;
    }

    public SslContextBuilder withKeyStoreAlias(String keyStoreAlias) {
        this.keyStoreAlias = keyStoreAlias;
        return this;
    }

    private static KeyStore loadKeystore(InputStream in, char[] password) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        try {
            store.load(in, password);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return store;
    }

    private static KeyStore loadKeystoreAlias(String alias, char[] password) throws Exception {
        KeyStore store = KeyStore.getInstance("JKS");
        store.getKey(alias, password);
        return store;
    }

    public SslContextBuilder withTrustStoreKeyManagers(TrustManager[] trustStoreKeyManagers) {
        this.trustStoreKeyManagers = trustStoreKeyManagers;
        return this;
    }

    public String getTruststorePath() {
        if (this.truststorePath == null) {
            this.truststorePath = System.getenv(this.getTrustStorePathEnvVariable());
        }
        if (this.truststorePath != null) {
            this.validatePath("TruststorePath", this.truststorePath);
        }
        return this.truststorePath;
    }

    private void validatePath(String name, String path) {
        if (path == null) {
            throw new SslContextBuilderException(String.format("%s cannot be null", name));
        }
        if (path.trim().isEmpty()) {
            throw new SslContextBuilderException(String.format("%s cannot be empty", name));
        }
        File filePath = new File(path);
        if (!filePath.exists()) {
            throw new SslContextBuilderException(String.format("%s path must exist", name));
        }
    }

    public SslContextBuilder withTruststorePath(String truststorePath) {
        this.truststorePath = truststorePath;
        return this;
    }

    public String getKeystorePath() {
        if (this.keystorePath == null) {
            this.keystorePath = System.getenv(this.getKeyStorePathEnvVariable());
        }
        if (this.keystorePath != null) {
            this.validatePath("keystorePath", this.keystorePath);
        }
        return this.keystorePath;
    }

    public SslContextBuilder withKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
        return this;
    }

    public String getAlgorithm() {
        if (this.algorithm == null || this.algorithm.trim().isEmpty()) {
            throw new IllegalStateException("algorithm must be set");
        }
        return this.algorithm;
    }

    public SslContextBuilder withAlgorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public char[] getKeystorePassword() {
        return this.keystorePassword;
    }

    public SslContextBuilder withKeyPassword(String keyPassword) {
        this.keystorePassword = keyPassword.toCharArray();
        return this;
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public SslContextBuilder withStorePassword(String storePassword) {
        this.trustStorePassword = storePassword.toCharArray();
        return this;
    }

    public SSLContext buildOld() {
        try {
            return SSLUtils.createSSLContext(this.getTruststorePath(), this.getKeystorePath(), this.getAlgorithm(), new String(this.getKeystorePassword()), new String(this.getTrustStorePassword()), this.getKeyStoreAlias());
        }
        catch (Exception e) {
            throw new SslContextBuilderException("Unable to create SSL context", e);
        }
    }

    public SSLContext build() {
        try {
            SSLContext ctx = SSLContext.getInstance("TLSv1.2");
            ctx.init(this.getKeyStoreKeyManagers(), this.getTrustStoreKeyManagers(), new SecureRandom());
            return ctx;
        }
        catch (Exception e) {
            throw new SslContextBuilderException("Unable to create SSL context", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrustManager[] getTrustStoreKeyManagers() {
        if (this.trustStoreKeyManagers == null) {
            String truststorePath = this.getTruststorePath();
            if (truststorePath == null) {
                String value = System.getenv(this.getTrustStoreValueEnvVariable());
                byte[] decode = Base64.getDecoder().decode(value);
                try {
                    KeyStore store = SslContextBuilder.loadKeystore(new ByteArrayInputStream(decode), this.getTrustStorePassword());
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(this.getAlgorithm());
                    factory.init(store);
                    this.trustStoreKeyManagers = factory.getTrustManagers();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to load Trust store from env variable" + this.getTrustStoreValueEnvVariable(), e);
                }
            }
            String extension = truststorePath.substring(truststorePath.lastIndexOf(".") + 1, truststorePath.length());
            if (extension.equals("crt")) {
                KeyStore truststore = null;
                try {
                    Certificate ca;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    try (FileInputStream cert = new FileInputStream(truststorePath);){
                        ca = cf.generateCertificate(cert);
                    }
                    String trustStoreType = KeyStore.getDefaultType();
                    truststore = KeyStore.getInstance(trustStoreType);
                    truststore.load(null, this.getTrustStorePassword());
                    truststore.setCertificateEntry("ca", ca);
                    TrustManagerFactory factory = TrustManagerFactory.getInstance(this.getAlgorithm());
                    factory.init(truststore);
                    this.trustStoreKeyManagers = factory.getTrustManagers();
                }
                catch (Exception e) {
                    throw new SslContextBuilderException("Unable to convert the CRT file " + truststorePath, e);
                }
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(truststorePath);
                KeyStore store = SslContextBuilder.loadKeystore(fileInputStream, this.getTrustStorePassword());
                TrustManagerFactory factory = TrustManagerFactory.getInstance(this.getAlgorithm());
                factory.init(store);
                this.trustStoreKeyManagers = factory.getTrustManagers();
            }
            catch (FileNotFoundException e) {
                throw new SslContextBuilderException("Trust store path not found" + truststorePath, e);
            }
            catch (Exception e) {
                throw new SslContextBuilderException("Unable to load Trust store with path" + truststorePath, e);
            }
        }
        return this.trustStoreKeyManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyManager[] getKeyStoreKeyManagers() {
        if (this.keyStoreKeyManagers == null) {
            String keyStorePath = this.getKeystorePath();
            String keyStoreAlias = this.getKeyStoreAlias();
            if (keyStorePath == null) {
                String value = System.getenv(this.getKeyStoreValueEnvVariable());
                byte[] decode = Base64.getDecoder().decode(value);
                try {
                    KeyStore store = SslContextBuilder.loadKeystore(new ByteArrayInputStream(decode), this.getKeystorePassword());
                    KeyManagerFactory factory = KeyManagerFactory.getInstance(this.getAlgorithm());
                    factory.init(store, this.getKeystorePassword());
                    this.keyStoreKeyManagers = factory.getKeyManagers();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Unable to load key store from env variable" + this.getKeyStoreValueEnvVariable(), e);
                }
            }
            String extension = keyStorePath.substring(keyStorePath.lastIndexOf(".") + 1, keyStorePath.length());
            if (extension.equals("crt")) {
                KeyStore keystore = null;
                try {
                    Certificate ca;
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    try (FileInputStream cert = new FileInputStream(keyStorePath);){
                        ca = cf.generateCertificate(cert);
                    }
                    String keyStoreType = KeyStore.getDefaultType();
                    keystore = KeyStore.getInstance(keyStoreType);
                    keystore.load(null, this.getKeystorePassword());
                    keystore.setCertificateEntry("ca", ca);
                    KeyManagerFactory factory = KeyManagerFactory.getInstance(this.getAlgorithm());
                    factory.init(keystore, this.getKeystorePassword());
                    this.keyStoreKeyManagers = factory.getKeyManagers();
                }
                catch (Exception e) {
                    throw new SslContextBuilderException("Unable to convert the CRT file " + keyStorePath, e);
                }
            }
            try {
                FileInputStream fileInputStream = new FileInputStream(keyStorePath);
                KeyStore store = SslContextBuilder.loadKeystore(fileInputStream, this.getKeystorePassword());
                if (keyStoreAlias != null) {
                    try {
                        store.setKeyEntry(keyStoreAlias, store.getKey(keyStoreAlias, this.getKeystorePassword()), this.getKeystorePassword(), store.getCertificateChain(keyStoreAlias));
                    }
                    catch (Exception e) {
                        throw new SslContextBuilderException("Unable to find the alias " + keyStoreAlias, e);
                    }
                }
                KeyManagerFactory factory = KeyManagerFactory.getInstance(this.getAlgorithm());
                factory.init(store, this.getKeystorePassword());
                this.keyStoreKeyManagers = factory.getKeyManagers();
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException("Key store path not found" + keyStorePath, e);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to load Key store with path" + keyStorePath, e);
            }
        }
        return this.keyStoreKeyManagers;
    }

    public SslContextBuilder withKeyStoreKeyManagers(KeyManager[] keyStoreKeyManagers) {
        this.keyStoreKeyManagers = keyStoreKeyManagers;
        return this;
    }
}

