/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.util;

import io.nats.bridge.metrics.Counter;
import io.nats.bridge.util.FunctionWithException;
import io.nats.bridge.util.RunnableWithException;
import io.nats.bridge.util.SupplierWithException;
import java.util.function.Function;
import org.slf4j.Logger;

public class ExceptionHandler {
    private final Logger logger;

    public ExceptionHandler(Logger logger) {
        this.logger = logger;
    }

    public void tryWithLog(RunnableWithException runnable, String errorMessage) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            this.logger.error(errorMessage, (Throwable)ex);
        }
    }

    public void tryWithErrorCount(RunnableWithException runnable, Counter errorCounter, String errorMessage) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            errorCounter.increment();
            this.logger.error(errorMessage, (Throwable)ex);
        }
    }

    public void tryWithRethrow(RunnableWithException runnable, Counter errorCounter, Function<Exception, RuntimeException> exceptionCreator) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            errorCounter.increment();
            throw exceptionCreator.apply(ex);
        }
    }

    public <T> T tryReturnOrRethrow(SupplierWithException<T> supplier, Function<Exception, RuntimeException> exceptionCreator) {
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            throw exceptionCreator.apply(ex);
        }
    }

    public <T, R> R tryFunctionOrRethrow(T arg, FunctionWithException<T, R> function, Function<Exception, RuntimeException> exceptionCreator) {
        try {
            return function.apply(arg);
        }
        catch (Exception ex) {
            throw exceptionCreator.apply(ex);
        }
    }

    public void tryWithRethrow(RunnableWithException runnable, Function<Exception, RuntimeException> exceptionCreator) {
        try {
            runnable.run();
        }
        catch (Exception ex) {
            throw exceptionCreator.apply(ex);
        }
    }
}

