/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge;

import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.MessageBuilder;
import io.nats.bridge.metrics.Metrics;
import java.io.Closeable;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;

public interface MessageBus
extends Closeable {
    public String name();

    public Metrics metrics();

    public void publish(Message var1);

    default public void publish(String message) {
        this.publish(MessageBuilder.builder().withBody(message).withCreator(this.name()).withNoReplyHandler("DEFAULT MESSAGE BUS PUBLISH").build());
    }

    public void request(Message var1, Consumer<Message> var2);

    default public void request(String message, Consumer<String> reply) {
        this.request(MessageBuilder.builder().withBody(message).withCreator(this.name()).withNoReplyHandler("DEFAULT METHOD MESSAGE BUS REQUEST").build(), (Message replyMessage) -> reply.accept(replyMessage.bodyAsString()));
    }

    public Optional<Message> receive();

    public Optional<Message> receive(Duration var1);

    @Override
    public void close();

    public int process();

    default public void init() {
    }
}

