/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.jms.support;

import io.nats.bridge.jms.support.ByteMessageSupplierFromSession;
import io.nats.bridge.messages.BaseMessageWithHeaders;
import io.nats.bridge.messages.Message;
import io.nats.bridge.util.FunctionWithException;
import io.nats.bridge.util.SupplierWithException;
import java.util.Map;
import java.util.Set;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Session;

public class ConvertBridgeMessageToJmsMessageWithHeaders
implements FunctionWithException<Message, javax.jms.Message> {
    private final SupplierWithException<BytesMessage> messageCreator;

    public ConvertBridgeMessageToJmsMessageWithHeaders(SupplierWithException<BytesMessage> messageCreator) {
        this.messageCreator = messageCreator;
    }

    public ConvertBridgeMessageToJmsMessageWithHeaders(Session session) {
        this(new ByteMessageSupplierFromSession(session));
    }

    @Override
    public javax.jms.Message apply(Message message) throws Exception {
        BytesMessage bytesMessage = this.messageCreator.get();
        if (message instanceof BaseMessageWithHeaders) {
            this.copyHeaders(message, bytesMessage);
        }
        bytesMessage.writeBytes(message.getBodyBytes());
        return bytesMessage;
    }

    private void copyHeaders(Message message, BytesMessage bytesMessage) throws JMSException {
        Map headers = message.headers();
        Set keys = headers.keySet();
        for (String key : keys) {
            bytesMessage.setObjectProperty(key, headers.get(key));
        }
        if (message.timestamp() != -1L) {
            bytesMessage.setJMSTimestamp(message.timestamp());
        }
        if (message.expirationTime() != -1L) {
            bytesMessage.setJMSExpiration(message.expirationTime());
        }
        if (message.deliveryTime() != -1L) {
            bytesMessage.setJMSDeliveryTime(message.deliveryTime());
        }
        if (message.deliveryMode() != -1) {
            bytesMessage.setJMSDeliveryMode(message.deliveryMode());
        }
        if (!"NO_TYPE".equals(message.type())) {
            bytesMessage.setJMSType(message.type());
        }
        bytesMessage.setJMSRedelivered(message.redelivered());
        if (message.priority() != -1) {
            bytesMessage.setJMSPriority(message.priority());
        }
        if (message.correlationID() != null && message.correlationID().trim().length() > 0) {
            bytesMessage.setJMSCorrelationID(message.correlationID());
        }
    }
}

