/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.metrics;

import io.nats.bridge.TimeSource;
import io.nats.bridge.metrics.Metrics;
import io.nats.bridge.metrics.MetricsProcessor;
import io.nats.bridge.metrics.Output;
import java.time.Duration;

public class MetricsDisplay
implements MetricsProcessor {
    private final Output output;
    private final Metrics metrics;
    private final int every;
    private final Duration everyDuration;
    private final TimeSource timeSource;
    private final String name;
    private int index = 0;
    private long lastTime = 0L;

    public MetricsDisplay(Output output, Metrics metrics, int every, Duration everyDuration, TimeSource timeSource, String name) {
        this.output = output;
        this.every = every;
        this.metrics = metrics;
        this.everyDuration = everyDuration;
        this.timeSource = timeSource;
        this.name = name;
    }

    @Override
    public void process() {
        long currentTime;
        long duration;
        ++this.index;
        if (this.index % this.every == 0 && (duration = (currentTime = this.timeSource.getTime()) - this.lastTime) > this.everyDuration.toMillis()) {
            this.lastTime = currentTime;
            this.display();
        }
    }

    private void display() {
        this.output.println("======== Counts for " + this.name + " =========== ");
        this.metrics.counters().forEach(counter -> this.output.println(counter.toString()));
        this.output.println("======== Gauges for " + this.name + " =========== ");
        this.metrics.gauges().forEach(counter -> this.output.println(counter.toString()));
        this.output.println("======== Timers for " + this.name + " =========== ");
        this.metrics.timers().forEach(counter -> this.output.println(counter.toString()));
    }
}

