/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.metrics.implementation;

import io.nats.bridge.TimeSource;
import io.nats.bridge.metrics.Counter;
import io.nats.bridge.metrics.Gauge;
import io.nats.bridge.metrics.Metrics;
import io.nats.bridge.metrics.TimeTracker;
import io.nats.bridge.metrics.implementation.SimpleCounter;
import io.nats.bridge.metrics.implementation.SimpleGauge;
import io.nats.bridge.metrics.implementation.SimpleTimeTracker;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class SimpleMetrics
implements Metrics {
    private final TimeSource timeSource;
    private final CopyOnWriteArrayList<Gauge> gauges = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Counter> counters = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<TimeTracker> timers = new CopyOnWriteArrayList();

    public SimpleMetrics(TimeSource timeSource) {
        this.timeSource = timeSource;
    }

    Map<String, String> convertToMap(String[] tags) {
        if (tags.length % 2 != 0) {
            throw new IllegalStateException("Tags must be key value pairs so must be an even number");
        }
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (int i = 0; i < tags.length - 1; i += 2) {
            map.put(tags[i], tags[i + 1]);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Gauge createGauge(String name, String ... tags) {
        Map<String, String> map = this.convertToMap(tags);
        String id = this.generateId(name, map);
        SimpleGauge gauge = new SimpleGauge(name, map, id);
        this.gauges.add(gauge);
        return gauge;
    }

    private String generateId(String name, Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append('_');
        for (String key : map.keySet()) {
            builder.append(key).append('_').append(map.get(key));
        }
        return builder.toString();
    }

    @Override
    public Counter createCounter(String name, String ... tags) {
        Map<String, String> map = this.convertToMap(tags);
        SimpleCounter counter = new SimpleCounter(name, map, this.generateId(name, map));
        this.counters.add(counter);
        return counter;
    }

    @Override
    public TimeTracker createTimeTracker(String name, String ... tags) {
        Map<String, String> map = this.convertToMap(tags);
        SimpleTimeTracker tt = new SimpleTimeTracker(name, this.timeSource, map, this.generateId(name, map));
        this.timers.add(tt);
        return tt;
    }

    @Override
    public Collection<Counter> counters() {
        return Collections.unmodifiableCollection(this.counters);
    }

    @Override
    public Collection<Gauge> gauges() {
        return Collections.unmodifiableCollection(this.gauges);
    }

    @Override
    public Collection<TimeTracker> timers() {
        return Collections.unmodifiableCollection(this.timers);
    }
}

