/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.support;

import io.nats.bridge.MessageBridge;
import io.nats.bridge.MessageBus;
import io.nats.bridge.messages.transform.TransformMessage;
import io.nats.bridge.messages.transform.Transformers;
import io.nats.bridge.support.MessageBridgeBase;
import io.nats.bridge.support.MessageBridgeDynamicForward;
import io.nats.bridge.support.MessageBridgeForward;
import io.nats.bridge.support.MessageBridgeRequestReply;
import io.nats.bridge.support.MessageBusBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public class MessageBridgeBuilder {
    private MessageBus sourceBus;
    private MessageBus destinationBus;
    private boolean requestReply = true;
    private boolean dynamicHeader = false;
    private String dynamicHeaderName = "REPLY_DESTINATION";
    private String name;
    private Queue<MessageBridgeBase.MessageBridgeRequestReply> replyMessageQueue;
    private MessageBusBuilder sourceBusBuilder;
    private MessageBusBuilder destinationBusBuilder;
    private List<String> transforms = Collections.emptyList();
    private List<String> replyTransforms = Collections.emptyList();
    private Map<String, TransformMessage> transformers;

    public static MessageBridgeBuilder builder() {
        return new MessageBridgeBuilder();
    }

    public String getDynamicHeaderName() {
        return this.dynamicHeaderName;
    }

    public MessageBridgeBuilder withDynamicHeaderName(String dynamicHeaderName) {
        this.withDynamicHeader(true);
        this.withRequestReply(false);
        this.dynamicHeaderName = dynamicHeaderName;
        return this;
    }

    public boolean isDynamicHeader() {
        return this.dynamicHeader;
    }

    public MessageBridgeBuilder withDynamicHeader(boolean dynamicHeader) {
        this.dynamicHeader = dynamicHeader;
        return this;
    }

    public MessageBusBuilder getSourceBusBuilder() {
        return this.sourceBusBuilder;
    }

    public List<String> getReplyTransforms() {
        return this.replyTransforms;
    }

    public MessageBridgeBuilder withReplyTransforms(List<String> replyTransforms) {
        this.replyTransforms = replyTransforms;
        return this;
    }

    public List<String> getTransforms() {
        return this.transforms;
    }

    public MessageBridgeBuilder withTransforms(List<String> transforms) {
        this.transforms = transforms;
        return this;
    }

    public MessageBridgeBuilder withSourceBusBuilder(MessageBusBuilder sourceBusBuilder) {
        this.sourceBusBuilder = sourceBusBuilder;
        return this;
    }

    public MessageBusBuilder getDestinationBusBuilder() {
        return this.destinationBusBuilder;
    }

    public MessageBridgeBuilder withDestinationBusBuilder(MessageBusBuilder destBusBuilder) {
        this.destinationBusBuilder = destBusBuilder;
        return this;
    }

    public MessageBus getSourceBus() {
        if (this.sourceBus == null && this.sourceBusBuilder == null) {
            throw new IllegalStateException("Source Bus must be set");
        }
        if (this.sourceBus == null) {
            this.sourceBus = this.getSourceBusBuilder().build();
        }
        return this.sourceBus;
    }

    public MessageBridgeBuilder withSourceBus(MessageBus sourceBus) {
        this.sourceBus = sourceBus;
        return this;
    }

    public MessageBus getDestinationBus() {
        if (this.destinationBus == null && this.destinationBusBuilder == null) {
            throw new IllegalStateException("Destination Bus must be set");
        }
        if (this.destinationBus == null) {
            this.destinationBus = this.getDestinationBusBuilder().build();
        }
        return this.destinationBus;
    }

    public MessageBridgeBuilder withDestinationBus(MessageBus destinationBus) {
        this.destinationBus = destinationBus;
        return this;
    }

    public boolean isRequestReply() {
        return this.requestReply;
    }

    public MessageBridgeBuilder withRequestReply(boolean requestReply) {
        this.requestReply = requestReply;
        return this;
    }

    public String getName() {
        if (this.name == null) {
            throw new IllegalStateException("Name must be set");
        }
        return this.name;
    }

    public MessageBridgeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public Queue<MessageBridgeBase.MessageBridgeRequestReply> getReplyMessageQueue() {
        return this.replyMessageQueue;
    }

    public MessageBridgeBuilder withReplyMessageQueue(Queue<MessageBridgeBase.MessageBridgeRequestReply> replyMessageQueue) {
        this.replyMessageQueue = replyMessageQueue;
        return this;
    }

    public Map<String, TransformMessage> getTransformers() {
        if (this.transformers == null) {
            this.transformers = Transformers.loadTransforms();
        }
        return this.transformers;
    }

    public MessageBridgeBuilder withTransformers(Map<String, TransformMessage> transformers) {
        this.transformers = transformers;
        return this;
    }

    public MessageBridge build() {
        if (this.isRequestReply()) {
            return new MessageBridgeRequestReply(this.getName(), this.getSourceBus(), this.getDestinationBus(), this.getReplyMessageQueue(), this.getTransforms(), this.getReplyTransforms(), this.getTransformers());
        }
        if (this.isDynamicHeader()) {
            return new MessageBridgeDynamicForward(this.getName(), this.getSourceBus(), this.getDestinationBus(), this.getTransforms(), this.getReplyTransforms(), this.getTransformers(), this.getDynamicHeaderName(), s -> this.getDestinationBusBuilder().build((String)s));
        }
        return new MessageBridgeForward(this.getName(), this.getSourceBus(), this.getDestinationBus(), this.getTransforms(), this.getReplyTransforms(), this.getTransformers());
    }
}

