/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.support;

import io.nats.bridge.MessageBus;
import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.transform.TransformMessage;
import io.nats.bridge.support.MessageBridgeBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class MessageBridgeDynamicForward
extends MessageBridgeBase {
    private final Function<String, MessageBus> createMessageBusFunction;
    private final Map<String, MessageBus> busMap = new HashMap<String, MessageBus>();
    private final String forwardHeaderName;

    public MessageBridgeDynamicForward(String name, MessageBus sourceBus, MessageBus destinationBus, List<String> inputTransforms, List<String> outputTransforms, Map<String, TransformMessage> transformers, String forwardHeaderName, Function<String, MessageBus> createMessageBus) {
        super(name, sourceBus, destinationBus, inputTransforms, outputTransforms, transformers);
        this.createMessageBusFunction = createMessageBus;
        this.forwardHeaderName = forwardHeaderName;
    }

    @Override
    protected void processMessage(Message receiveMessageFromSource) {
        Message currentMessageFinal = this.transformMessageIfNeeded(receiveMessageFromSource, this.transforms);
        if (currentMessageFinal == null) {
            return;
        }
        String destination = (String)currentMessageFinal.headers().get(this.forwardHeaderName);
        if (destination == null) {
            try {
                this.destinationBus.publish(currentMessageFinal);
            }
            catch (Exception ex) {
                this.restartMessageBus(ex, this.destinationBus);
                this.destinationBus.publish(currentMessageFinal);
            }
        } else {
            MessageBus dynamicDestinationBus = this.busMap.computeIfAbsent(destination, this.createMessageBusFunction);
            try {
                dynamicDestinationBus.publish(currentMessageFinal);
            }
            catch (Exception ex) {
                this.restartMessageBus(ex, dynamicDestinationBus);
                dynamicDestinationBus.publish(currentMessageFinal);
            }
        }
    }

    @Override
    protected int otherProcess() {
        int count = 0;
        for (MessageBus mb : this.busMap.values()) {
            count += this.processBus(mb);
        }
        return count;
    }
}

