/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.support;

import io.nats.bridge.messages.Message;
import io.nats.bridge.messages.transform.TransformMessage;
import io.nats.bridge.messages.transform.TransformResult;
import io.nats.bridge.messages.transform.Transformers;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class MessageBridgeUtil {
    public static Message transformMessageIfNeeded(Message receiveMessageFromSource, List<String> transforms, boolean transformMessage, Map<String, TransformMessage> transformers, Logger logger, Logger runtimeLogger) {
        if (transforms.isEmpty()) {
            return receiveMessageFromSource;
        }
        Message currentMessage = receiveMessageFromSource;
        if (transformMessage) {
            TransformResult result = Transformers.runTransforms(transformers, transforms, (Message)currentMessage);
            switch (result.getResult()) {
                case SKIP: {
                    if (runtimeLogger.isTraceEnabled()) {
                        runtimeLogger.trace("Message was skipped");
                    }
                    return null;
                }
                case SYSTEM_ERROR: 
                case ERROR: {
                    if (result.getStatusMessage().isPresent()) {
                        logger.error((String)result.getStatusMessage().get(), result.getError());
                    } else {
                        logger.error("Error handling transform ", result.getError());
                    }
                    return null;
                }
                case TRANSFORMED: {
                    if (runtimeLogger.isTraceEnabled()) {
                        if (!result.getStatusMessage().isPresent()) {
                            runtimeLogger.trace("Message was transformed");
                        } else {
                            runtimeLogger.trace("Message was transformed " + (String)result.getStatusMessage().get());
                        }
                    }
                    currentMessage = result.getTransformedMessage();
                }
            }
        }
        return currentMessage;
    }
}

