/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.support;

import io.nats.bridge.MessageBus;
import io.nats.bridge.jms.JMSMessageBus;
import java.time.Duration;
import org.slf4j.Logger;

public class MessageBusRestarter {
    private final String name;
    private final Logger logger;
    private final Duration ignoreRestartBackoffAfter = Duration.ofMinutes(10L);
    private final int backoffMax = 60;
    private long lastRestart = System.currentTimeMillis();
    private int backoffSeconds = 1;

    public MessageBusRestarter(String name, Logger logger) {
        this.name = name;
        this.logger = logger;
    }

    public void restartMessageBus(Exception ex, MessageBus messageBus) {
        if (messageBus instanceof JMSMessageBus) {
            this.logger.info("Restarting Message Bus {} {}", (Object)this.name, (Object)this.backoffSeconds);
            long now = System.currentTimeMillis();
            if (this.lastRestart > now - this.ignoreRestartBackoffAfter.toMillis() && this.backoffSeconds < 60) {
                this.backoffSeconds *= 2;
            }
            this.logger.info("Restart reason for " + this.name, (Throwable)ex);
            try {
                messageBus.close();
                this.logger.info("Restart reason {} === CLOSED", (Object)this.name);
            }
            catch (Exception exClose) {
                this.logger.debug("Unable to close", (Throwable)exClose);
            }
            try {
                messageBus.init();
                this.logger.info("Restart reason {} === RESTARTED", (Object)this.name);
            }
            catch (Exception exClose) {
                this.logger.error("Unable to recreate", (Throwable)exClose);
                try {
                    Thread.sleep(this.backoffSeconds * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return;
            }
            this.backoffSeconds = 1;
            this.lastRestart = System.currentTimeMillis();
            this.logger.info("Restarting Message Bus for {}, sleeping {}", (Object)this.name, (Object)this.backoffSeconds);
            this.logger.info("Restarted Message Bus for {}", (Object)this.name);
        } else {
            this.rethrow(ex);
        }
    }

    private void rethrow(Exception ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException(ex);
    }
}

