/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.task;

import io.nats.bridge.MessageBridge;
import io.nats.bridge.MessageBridgeTasksManager;
import io.nats.bridge.task.MessageBridgeTasksManagerImpl;
import java.time.Duration;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBridgeTasksManagerBuilder {
    private String name;
    private Logger logger;
    private Function<String, MessageBridge> bridgeFactory;
    private int workers;
    private int tasks;
    private Duration pollDuration;
    private boolean namePerTask;

    public String getName() {
        return this.name;
    }

    public MessageBridgeTasksManagerBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger((String)(MessageBridgeTasksManager.class.toString() + "." + this.getName()));
        }
        return this.logger;
    }

    public MessageBridgeTasksManagerBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public Function<String, MessageBridge> getBridgeFactory() {
        return this.bridgeFactory;
    }

    public MessageBridgeTasksManagerBuilder withBridgeFactory(Function<String, MessageBridge> bridgeFactory) {
        this.bridgeFactory = bridgeFactory;
        return this;
    }

    public int getWorkers() {
        return this.workers;
    }

    public MessageBridgeTasksManagerBuilder withWorkers(int workers) {
        this.workers = workers;
        return this;
    }

    public int getTasks() {
        return this.tasks;
    }

    public MessageBridgeTasksManagerBuilder withTasks(int tasks) {
        this.tasks = tasks;
        return this;
    }

    public Duration getPollDuration() {
        return this.pollDuration;
    }

    public MessageBridgeTasksManagerBuilder withPollDuration(Duration pollDuration) {
        this.pollDuration = pollDuration;
        return this;
    }

    public boolean isNamePerTask() {
        return this.namePerTask;
    }

    public MessageBridgeTasksManagerBuilder withNamePerTask(boolean namePerTask) {
        this.namePerTask = namePerTask;
        return this;
    }

    public static MessageBridgeTasksManagerBuilder builder() {
        return new MessageBridgeTasksManagerBuilder();
    }

    public MessageBridgeTasksManager build() {
        return new MessageBridgeTasksManagerImpl(this.getName(), this.getLogger(), this.getBridgeFactory(), this.getWorkers(), this.getTasks(), this.getPollDuration(), this.isNamePerTask());
    }
}

