/*
 * Decompiled with CFR 0.152.
 */
package io.nats.bridge.tls;

import com.ibm.msg.client.jms.JmsConnectionFactory;
import com.ibm.msg.client.jms.JmsFactoryFactory;
import javax.jms.Destination;
import javax.jms.JMSConsumer;
import javax.jms.JMSContext;
import javax.jms.JMSException;
import javax.jms.JMSProducer;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.TextMessage;

public class IbmTls {
    private static int status = 1;
    private static final String HOST = "localhost";
    private static final int PORT = 1414;
    private static final String CHANNEL = "DEV.APP.SVRCONN";
    private static final String QMGR = "QM1";
    private static final String APP_USER = "app";
    private static final String APP_PASSWORD = "passw0rd";
    private static final String QUEUE_NAME = "DEV.QUEUE.1";

    public static void main(String[] args) {
        JMSContext context = null;
        Queue destination = null;
        JMSProducer producer = null;
        JMSConsumer consumer = null;
        try {
            JmsFactoryFactory ff = JmsFactoryFactory.getInstance((String)"com.ibm.msg.client.wmq");
            JmsConnectionFactory cf = ff.createConnectionFactory();
            cf.setStringProperty("XMSC_WMQ_HOST_NAME", HOST);
            cf.setIntProperty("XMSC_WMQ_PORT", 1414);
            cf.setStringProperty("XMSC_WMQ_CHANNEL", CHANNEL);
            cf.setIntProperty("XMSC_WMQ_CONNECTION_MODE", 1);
            cf.setStringProperty("XMSC_WMQ_QUEUE_MANAGER", QMGR);
            cf.setStringProperty("XMSC_WMQ_APPNAME", "JmsPutGet (JMS)");
            cf.setBooleanProperty("XMSC_USER_AUTHENTICATION_MQCSP", true);
            cf.setStringProperty("XMSC_USERID", APP_USER);
            cf.setStringProperty("XMSC_PASSWORD", APP_PASSWORD);
            cf.setStringProperty("XMSC_WMQ_SSL_CIPHER_SUITE", "TLS_RSA_WITH_AES_128_CBC_SHA256");
            System.setProperty("com.ibm.mq.cfg.useIBMCipherMappings", "false");
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            System.setProperty("javax.net.ssl.trustStore", "../certs/ibmkey.jks");
            System.setProperty("javax.net.ssl.trustStorePassword", "cloudurable@10");
            context = cf.createContext();
            destination = context.createQueue("queue:///DEV.QUEUE.1");
            TextMessage message = context.createTextMessage("Rick is the best!!! ");
            producer = context.createProducer();
            producer.send((Destination)destination, (Message)message);
            System.out.println("Sent message:\n" + message);
            consumer = context.createConsumer((Destination)destination);
            String receivedMessage = (String)consumer.receiveBody(String.class, 15000L);
            System.out.println("\nReceived message:\n" + receivedMessage);
            IbmTls.recordSuccess();
        }
        catch (JMSException jmsex) {
            IbmTls.recordFailure((Exception)((Object)jmsex));
        }
        System.exit(status);
    }

    private static void recordSuccess() {
        System.out.println("SUCCESS");
        status = 0;
    }

    private static void recordFailure(Exception ex) {
        if (ex != null) {
            if (ex instanceof JMSException) {
                IbmTls.processJMSException((JMSException)((Object)ex));
            } else {
                System.out.println(ex);
            }
        }
        System.out.println("FAILURE");
        status = -1;
    }

    private static void processJMSException(JMSException jmsex) {
        System.out.println((Object)jmsex);
        Throwable innerException = jmsex.getLinkedException();
        if (innerException != null) {
            System.out.println("Inner exception(s):");
        }
        while (innerException != null) {
            System.out.println(innerException);
            innerException = innerException.getCause();
        }
    }
}

