/*
 * Decompiled with CFR 0.152.
 */
package io.nats.stan;

import io.nats.stan.protobuf.StartPosition;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionOptions {
    static final Logger logger = LoggerFactory.getLogger(SubscriptionOptions.class);
    String durableName;
    int maxInFlight;
    Duration ackWait;
    StartPosition startAt;
    long startSequence;
    Instant startTime;
    boolean manualAcks;

    private SubscriptionOptions(Builder builder) {
        this.durableName = builder.durableName;
        this.maxInFlight = builder.maxInFlight;
        this.ackWait = builder.ackWait;
        this.startAt = builder.startAt;
        this.startSequence = builder.startSequence;
        this.startTime = builder.startTime;
        this.manualAcks = builder.manualAcks;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    public Duration getAckWait() {
        return this.ackWait;
    }

    public StartPosition getStartAt() {
        return this.startAt;
    }

    public long getStartSequence() {
        return this.startSequence;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public long getStartTime(TimeUnit unit) {
        long totalNanos = TimeUnit.SECONDS.toNanos(this.startTime.getEpochSecond());
        return unit.convert(totalNanos += (long)this.startTime.getNano(), TimeUnit.NANOSECONDS);
    }

    public boolean isManualAcks() {
        return this.manualAcks;
    }

    public static final class Builder {
        String durableName;
        int maxInFlight = 1024;
        Duration ackWait = Duration.ofMillis(30000L);
        StartPosition startAt = StartPosition.NewOnly;
        long startSequence;
        Instant startTime;
        boolean manualAcks;
        Date startTimeAsDate;

        public Builder setDurableName(String durableName) {
            this.durableName = durableName;
            return this;
        }

        public Builder setMaxInFlight(int maxInFlight) {
            this.maxInFlight = maxInFlight;
            return this;
        }

        public Builder setAckWait(Duration ackWait) {
            this.ackWait = ackWait;
            return this;
        }

        public Builder setAckWait(long ackWait, TimeUnit unit) {
            this.ackWait = Duration.ofMillis(unit.toMillis(ackWait));
            return this;
        }

        public Builder setManualAcks(boolean manualAcks) {
            this.manualAcks = manualAcks;
            return this;
        }

        public Builder startAtSequence(long seq) {
            this.startAt = StartPosition.SequenceStart;
            this.startSequence = seq;
            return this;
        }

        public Builder startAtTime(Instant start) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = start;
            return this;
        }

        public Builder startAtTimeDelta(long ago, TimeUnit unit) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = Instant.now().minusNanos(unit.toNanos(ago));
            return this;
        }

        public Builder startAtTimeDelta(Duration ago) {
            this.startAt = StartPosition.TimeDeltaStart;
            this.startTime = Instant.now().minusNanos(ago.toNanos());
            return this;
        }

        public Builder startWithLastReceived() {
            this.startAt = StartPosition.LastReceived;
            return this;
        }

        public Builder deliverAllAvailable() {
            this.startAt = StartPosition.First;
            return this;
        }

        public SubscriptionOptions build() {
            return new SubscriptionOptions(this);
        }
    }
}

