/*
 * Decompiled with CFR 0.152.
 */
package io.nats.stan;

import io.nats.stan.Connection;
import io.nats.stan.ConnectionImpl;
import io.nats.stan.Options;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ConnectionFactory {
    private Duration ackTimeout = Duration.ofMillis(30000L);
    private Duration connectTimeout = Duration.ofSeconds(2L);
    private String discoverPrefix = "_STAN.discover";
    private int maxPubAcksInFlight = 12;
    private String natsUrl = "nats://localhost:4222";
    private io.nats.client.Connection natsConn;
    private String clientId;
    private String clusterId;

    public ConnectionFactory() {
    }

    public ConnectionFactory(String clusterId, String clientId) {
        this.setClusterId(clusterId);
        this.setClientId(clientId);
    }

    public Connection createConnection() throws IOException, TimeoutException {
        ConnectionImpl conn = new ConnectionImpl(this.clusterId, this.clientId, this.options());
        conn.connect();
        return conn;
    }

    Options options() {
        Options opts = new Options.Builder().setConnectTimeout(this.connectTimeout).setAckTimeout(this.ackTimeout).setDiscoverPrefix(this.discoverPrefix).setMaxPubAcksInFlight(this.maxPubAcksInFlight).setNatsConn(this.natsConn).setNatsUrl(this.natsUrl).create();
        return opts;
    }

    public Duration getAckTimeout() {
        return this.ackTimeout;
    }

    public void setAckTimeout(Duration ackTimeout) {
        this.ackTimeout = ackTimeout;
    }

    public void setAckTimeout(long ackTimeout, TimeUnit unit) {
        this.ackTimeout = Duration.ofMillis(unit.toMillis(ackTimeout));
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.connectTimeout = Duration.ofMillis(unit.toMillis(connectTimeout));
    }

    public String getDiscoverPrefix() {
        return this.discoverPrefix;
    }

    public void setDiscoverPrefix(String discoverPrefix) {
        if (discoverPrefix == null) {
            throw new NullPointerException("stan: discoverPrefix must be non-null");
        }
        this.discoverPrefix = discoverPrefix;
    }

    public int getMaxPubAcksInFlight() {
        return this.maxPubAcksInFlight;
    }

    public void setMaxPubAcksInFlight(int maxPubAcksInFlight) {
        if (maxPubAcksInFlight < 0) {
            throw new IllegalArgumentException("stan: max publish acks in flight must be >= 0");
        }
        this.maxPubAcksInFlight = maxPubAcksInFlight;
    }

    public String getNatsUrl() {
        return this.natsUrl;
    }

    public void setNatsUrl(String natsUrl) {
        if (natsUrl == null) {
            throw new NullPointerException("stan: NATS URL must be non-null");
        }
        this.natsUrl = natsUrl;
    }

    public io.nats.client.Connection getNatsConnection() {
        return this.natsConn;
    }

    public void setNatsConnection(io.nats.client.Connection natsConn) {
        this.natsConn = natsConn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        if (clientId == null) {
            throw new NullPointerException("stan: client ID must be non-null");
        }
        this.clientId = clientId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public void setClusterId(String clusterId) {
        if (clusterId == null) {
            throw new NullPointerException("stan: cluster ID must be non-null");
        }
        this.clusterId = clusterId;
    }
}

