/*
 * Decompiled with CFR 0.152.
 */
package io.nats.stan;

import io.nats.client.Connection;
import java.time.Duration;

class Options {
    private String natsUrl;
    private Connection natsConn;
    private Duration connectTimeout;
    private Duration ackTimeout;
    private String discoverPrefix;
    private int maxPubAcksInFlight;

    private Options(Builder builder) {
        this.natsUrl = builder.natsUrl;
        this.natsConn = builder.natsConn;
        this.connectTimeout = builder.connectTimeout;
        this.ackTimeout = builder.ackTimeout;
        this.discoverPrefix = builder.discoverPrefix;
        this.maxPubAcksInFlight = builder.maxPubAcksInFlight;
    }

    String getNatsUrl() {
        return this.natsUrl;
    }

    Connection getNatsConn() {
        return this.natsConn;
    }

    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    Duration getAckTimeout() {
        return this.ackTimeout;
    }

    String getDiscoverPrefix() {
        return this.discoverPrefix;
    }

    int getMaxPubAcksInFlight() {
        return this.maxPubAcksInFlight;
    }

    static final class Builder {
        private String natsUrl = "nats://localhost:4222";
        private Connection natsConn;
        private Duration connectTimeout = Duration.ofSeconds(2L);
        private Duration ackTimeout = Duration.ofMillis(30000L);
        private String discoverPrefix = "_STAN.discover";
        private int maxPubAcksInFlight = 12;

        Builder() {
        }

        public Builder setAckTimeout(Duration ackTimeout) {
            this.ackTimeout = ackTimeout;
            return this;
        }

        public Builder setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder setDiscoverPrefix(String discoverPrefix) {
            this.discoverPrefix = discoverPrefix;
            return this;
        }

        public Builder setMaxPubAcksInFlight(int maxPubAcksInFlight) {
            this.maxPubAcksInFlight = maxPubAcksInFlight;
            return this;
        }

        public Builder setNatsConn(Connection natsConn) {
            this.natsConn = natsConn;
            return this;
        }

        public Builder setNatsUrl(String natsUrl) {
            this.natsUrl = natsUrl;
            return this;
        }

        public Options create() {
            return new Options(this);
        }
    }
}

