/*
 * Decompiled with CFR 0.152.
 */
package io.nats.stan;

import io.nats.stan.ConnectionImpl;
import io.nats.stan.Subscription;
import io.nats.stan.SubscriptionImpl;
import io.nats.stan.protobuf.Ack;
import io.nats.stan.protobuf.MsgProto;
import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.TimeoutException;

public class Message {
    static final String ERR_MSG_IMMUTABLE = "stan: message is immutable";
    private String subject;
    private String reply;
    private byte[] data;
    private SubscriptionImpl sub;
    private long sequence;
    private long timestamp;
    private boolean redelivered;
    private int crc32;
    private boolean immutable;

    Message() {
    }

    Message(MsgProto msgp) {
        if (msgp == null) {
            throw new NullPointerException("stan: MsgProto cannot be null");
        }
        this.subject = msgp.getSubject();
        this.reply = msgp.getReply();
        this.data = msgp.getData().toByteArray();
        this.sequence = msgp.getSequence();
        this.timestamp = msgp.getTimestamp();
        this.redelivered = msgp.getRedelivered();
        this.crc32 = msgp.getCRC32();
        this.immutable = true;
    }

    public Instant getInstant() {
        long tsSeconds = this.timestamp / 1000000000L;
        long tsNanos = this.timestamp - tsSeconds * 1000000000L;
        Instant inst = Instant.ofEpochSecond(tsSeconds).plusNanos(tsNanos);
        return inst;
    }

    void setSubscription(Subscription sub) {
        this.sub = (SubscriptionImpl)sub;
    }

    Subscription getSubscription() {
        return this.sub;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        if (this.immutable) {
            throw new IllegalStateException(ERR_MSG_IMMUTABLE);
        }
        this.subject = subject;
    }

    public String getReplyTo() {
        return this.reply;
    }

    public void setReplyTo(String reply) {
        if (this.immutable) {
            throw new IllegalStateException(ERR_MSG_IMMUTABLE);
        }
        this.reply = reply;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        if (this.immutable) {
            throw new IllegalStateException(ERR_MSG_IMMUTABLE);
        }
        if (data == null) {
            this.data = null;
        } else {
            this.setData(data, 0, data.length);
        }
    }

    public void setData(byte[] data, int offset, int length) {
        if (this.immutable) {
            throw new IllegalStateException(ERR_MSG_IMMUTABLE);
        }
        this.data = new byte[length];
        System.arraycopy(data, offset, this.data, 0, length);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isRedelivered() {
        return this.redelivered;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void ack() throws IOException, TimeoutException {
        ConnectionImpl sc;
        boolean isManualAck;
        String ackSubject = null;
        this.sub.rLock();
        try {
            ackSubject = this.sub.getAckInbox();
            isManualAck = this.sub.getOptions().isManualAcks();
            sc = this.sub.getConnection();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.sub.rUnlock();
        }
        if (sc == null) {
            throw new IllegalStateException("stan: invalid subscription");
        }
        if (!isManualAck) {
            throw new IllegalStateException("stan: cannot manually ack in auto-ack mode");
        }
        Ack ack = Ack.newBuilder().setSubject(this.getSubject()).setSequence(this.getSequence()).build();
        sc.getNatsConnection().publish(ackSubject, ack.toByteArray());
    }

    public String toString() {
        int maxBytes = 32;
        int len = 0;
        byte[] bytes = this.getData();
        if (bytes != null) {
            len = bytes.length;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("{Timestamp=%d;Sequence=%d;Redelivered=%b;Subject=%s;Reply=%s;Payload=<", this.getTimestamp(), this.getSequence(), this.isRedelivered(), this.getSubject(), this.getReplyTo()));
        for (int i = 0; i < maxBytes && i < len; ++i) {
            sb.append((char)bytes[i]);
        }
        int remainder = len - maxBytes;
        if (remainder > 0) {
            sb.append(String.format("%d more bytes", remainder));
        }
        sb.append(">}");
        return sb.toString();
    }
}

