/*
 * Decompiled with CFR 0.152.
 */
package io.nats.stan;

import io.nats.client.Message;
import io.nats.stan.ConnectionImpl;
import io.nats.stan.MessageHandler;
import io.nats.stan.Subscription;
import io.nats.stan.SubscriptionOptions;
import io.nats.stan.protobuf.SubscriptionResponse;
import io.nats.stan.protobuf.UnsubscribeRequest;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionImpl
implements Subscription {
    static final Logger logger = LoggerFactory.getLogger(SubscriptionImpl.class);
    static final long DEFAULT_ACK_WAIT = 30000L;
    static final int DEFAULT_MAX_IN_FLIGHT = 1024;
    final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    ConnectionImpl sc;
    String subject;
    String qgroup;
    String inbox;
    String ackInbox;
    io.nats.client.Subscription inboxSub;
    SubscriptionOptions opts = new SubscriptionOptions.Builder().build();
    MessageHandler cb;

    protected SubscriptionImpl() {
    }

    protected SubscriptionImpl(String subject, String qgroup, MessageHandler cb, ConnectionImpl sc, SubscriptionOptions opts) {
        this.subject = subject;
        this.qgroup = qgroup;
        this.cb = cb;
        this.sc = sc;
        if (opts != null) {
            this.opts = opts;
        }
        this.inbox = sc.newInbox();
    }

    protected void rLock() {
        this.rwlock.readLock().lock();
    }

    protected void rUnlock() {
        this.rwlock.readLock().unlock();
    }

    protected void wLock() {
        this.rwlock.writeLock().lock();
    }

    protected void wUnlock() {
        this.rwlock.writeLock().unlock();
    }

    protected String getAckInbox() {
        return this.ackInbox;
    }

    protected ConnectionImpl getConnection() {
        return this.sc;
    }

    protected String getInbox() {
        return this.inbox;
    }

    protected MessageHandler getMessageHandler() {
        return this.cb;
    }

    @Override
    public String getQueue() {
        return this.qgroup;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public SubscriptionOptions getOptions() {
        return this.opts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe() throws IOException, TimeoutException {
        ConnectionImpl sc = null;
        String inbox = null;
        String reqSubject = null;
        this.wLock();
        try {
            sc = this.sc;
            if (sc == null) {
                throw new IllegalStateException("stan: invalid subscription");
            }
            this.sc = null;
            try {
                if (this.inboxSub != null) {
                    this.inboxSub.unsubscribe();
                }
            }
            catch (Exception e) {
                logger.warn("stan: encountered exception unsubscribing from inbox", (Throwable)e);
            }
            this.inboxSub = null;
            inbox = this.inbox;
        }
        finally {
            this.wUnlock();
        }
        sc.lock();
        try {
            if (sc.nc == null) {
                throw new IllegalStateException("stan: connection closed");
            }
            sc.subMap.remove(inbox);
            reqSubject = sc.unsubRequests;
        }
        finally {
            sc.unlock();
        }
        UnsubscribeRequest usr = UnsubscribeRequest.newBuilder().setClientID(sc.getClientId()).setSubject(this.subject).setInbox(this.ackInbox).build();
        byte[] bytes = usr.toByteArray();
        Message reply = null;
        try {
            reply = sc.nc.request(reqSubject, bytes, 2L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new TimeoutException("stan: publish ack timeout");
        }
        SubscriptionResponse response = SubscriptionResponse.parseFrom(reply.getData());
        if (!response.getError().isEmpty()) {
            throw new IOException("stan: " + response.getError());
        }
    }

    @Override
    public void close() {
        if (this.sc == null) {
            return;
        }
        try {
            this.unsubscribe();
        }
        catch (Exception e) {
            logger.warn("stan: exception during unsubscribe for subject {}", (Object)this.subject);
            logger.debug("Stack trace: ", (Throwable)e);
        }
    }

    protected void setAckInbox(String ackInbox) {
        this.ackInbox = ackInbox;
    }
}

