/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import io.nats.client.AsyncSubscription;
import io.nats.client.AsyncSubscriptionImpl;
import io.nats.client.ClosedCallback;
import io.nats.client.Connection;
import io.nats.client.ConnectionEvent;
import io.nats.client.DisconnectedCallback;
import io.nats.client.ExceptionHandler;
import io.nats.client.Message;
import io.nats.client.MessageHandler;
import io.nats.client.MsgDeliveryPool;
import io.nats.client.MsgDeliveryWorker;
import io.nats.client.NATSException;
import io.nats.client.NUID;
import io.nats.client.Nats;
import io.nats.client.NatsThreadFactory;
import io.nats.client.Options;
import io.nats.client.Parser;
import io.nats.client.ReconnectedCallback;
import io.nats.client.ServerInfo;
import io.nats.client.Statistics;
import io.nats.client.Subscription;
import io.nats.client.SubscriptionImpl;
import io.nats.client.SyncSubscription;
import io.nats.client.SyncSubscriptionImpl;
import io.nats.client.TcpConnection;
import io.nats.client.TcpConnectionFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

class ConnectionImpl
implements Connection {
    private String version = null;
    private static final String INBOX_PREFIX = "_INBOX.";
    private static final int NUID_SIZE = 22;
    private static final int RESP_INBOX_PREFIX_LEN = "_INBOX.".length() + 22 + 1;
    private Nats.ConnState status = Nats.ConnState.DISCONNECTED;
    protected static final String STALE_CONNECTION = "Stale Connection";
    protected static final String LANG_STRING = "java";
    protected static final int DEFAULT_BUF_SIZE = 65536;
    protected static final int DEFAULT_STREAM_BUF_SIZE = 65536;
    protected static final int FLUSH_CHAN_SIZE = 1;
    private long flushTimerInterval = 1L;
    private TimeUnit flushTimerUnit = TimeUnit.MILLISECONDS;
    private String respSub;
    private Subscription respMux;
    private ConcurrentHashMap<String, BlockingQueue<Message>> respMap;
    protected static final String CRLF = "\r\n";
    protected static final String _EMPTY_ = "";
    protected static final String _SPC_ = " ";
    protected static final String _PUB_P_ = "PUB ";
    protected static final String _OK_OP_ = "+OK";
    protected static final String _ERR_OP_ = "-ERR";
    protected static final String _MSG_OP_ = "MSG";
    protected static final String _PING_OP_ = "PING";
    protected static final String _PONG_OP_ = "PONG";
    protected static final String _INFO_OP_ = "INFO";
    protected static final String CONN_PROTO = "CONNECT %s\r\n";
    protected static final String PING_PROTO = "PING\r\n";
    protected static final String PONG_PROTO = "PONG\r\n";
    protected static final String PUB_PROTO = "PUB %s %s %d\r\n";
    protected static final String SUB_PROTO = "SUB %s%s %d\r\n";
    protected static final String UNSUB_PROTO = "UNSUB %d %s\r\n";
    protected static final String OK_PROTO = "+OK\r\n";
    private ConnectionImpl nc = null;
    final Lock mu = new ReentrantLock();
    private final AtomicLong sidCounter = new AtomicLong(0L);
    private URI url = null;
    private Options opts = null;
    private TcpConnectionFactory tcf = null;
    private TcpConnection conn = null;
    private ByteBuffer pubProtoBuf = null;
    private OutputStream bw = null;
    private InputStream br = null;
    private ByteArrayOutputStream pending = null;
    private Map<Long, SubscriptionImpl> subs = new ConcurrentHashMap<Long, SubscriptionImpl>();
    private List<Srv> srvPool = null;
    private Map<String, URI> urls = null;
    private Exception lastEx = null;
    private ServerInfo info = null;
    private int pout;
    private Parser parser = new Parser(this);
    private static final byte[] pingProtoBytes = "PING\r\n".getBytes();
    private static final int pingProtoBytesLen = pingProtoBytes.length;
    private static final byte[] pongProtoBytes = "PONG\r\n".getBytes();
    private static final int pongProtoBytesLen = pongProtoBytes.length;
    private static final byte[] pubPrimBytes = "PUB ".getBytes();
    private static final int pubPrimBytesLen = pubPrimBytes.length;
    private static final byte[] crlfProtoBytes = "\r\n".getBytes();
    private static final int crlfProtoBytesLen = crlfProtoBytes.length;
    private Statistics stats = null;
    private List<BlockingQueue<Boolean>> pongs;
    private static final int NUM_CORE_THREADS = 4;
    private ScheduledExecutorService exec;
    static final String EXEC_NAME = "jnats-exec";
    private ExecutorService subexec;
    static final String SUB_EXEC_NAME = "jnats-subscriptions";
    private ExecutorService cbexec;
    static final String CB_EXEC_NAME = "jnats-callbacks";
    private ScheduledFuture<?> ptmr = null;
    static final String PINGTIMER = "pingtimer";
    static final String READLOOP = "readloop";
    static final String FLUSHER = "flusher";
    private final Map<String, Future<?>> tasks = new HashMap();
    private static final int NUM_WATCHER_THREADS = 2;
    private CountDownLatch socketWatchersStartLatch = new CountDownLatch(2);
    private CountDownLatch socketWatchersDoneLatch = null;
    private BlockingQueue<Boolean> fch;
    static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    ConnectionImpl(Options opts) {
        Properties props = this.getProperties("jnats.properties");
        this.version = props.getProperty("client.version");
        this.nc = this;
        this.opts = opts;
        this.stats = new Statistics();
        this.tcf = opts.getFactory() != null ? opts.getFactory() : new TcpConnectionFactory();
    }

    ScheduledExecutorService createScheduler() {
        ScheduledThreadPoolExecutor sexec = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(4, new NatsThreadFactory(EXEC_NAME));
        sexec.setRemoveOnCancelPolicy(true);
        return sexec;
    }

    ExecutorService createSubscriptionScheduler() {
        return Executors.newCachedThreadPool(new NatsThreadFactory(SUB_EXEC_NAME));
    }

    ExecutorService createCallbackScheduler() {
        return Executors.newSingleThreadExecutor(new NatsThreadFactory(CB_EXEC_NAME));
    }

    void setup() {
        this.exec = this.createScheduler();
        this.cbexec = this.createCallbackScheduler();
        this.subexec = this.createSubscriptionScheduler();
        this.fch = this.createFlushChannel();
        this.pongs = this.createPongs();
        this.subs.clear();
        this.buildPublishProtocolBuffer(1024);
    }

    Properties getProperties(InputStream inputStream) {
        Properties rv = new Properties();
        try {
            if (inputStream == null) {
                rv = null;
            } else {
                rv.load(inputStream);
            }
        }
        catch (IOException e) {
            rv = null;
        }
        return rv;
    }

    Properties getProperties(String resourceName) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourceName);
        return this.getProperties(is);
    }

    private void buildPublishProtocolBuffer(int size) {
        this.pubProtoBuf = ByteBuffer.allocate(size);
        this.pubProtoBuf.put(pubPrimBytes, 0, pubPrimBytesLen);
        this.pubProtoBuf.mark();
    }

    void setupServerPool() {
        URI url = this.opts.getUrl() != null ? URI.create(this.opts.getUrl()) : null;
        List<URI> servers = this.opts.getServers();
        this.srvPool = new ArrayList<Srv>();
        this.urls = new ConcurrentHashMap<String, URI>();
        if (servers != null) {
            for (URI s : servers) {
                this.addUrlToPool(s, false);
            }
        }
        if (!this.opts.isNoRandomize()) {
            Collections.shuffle(this.srvPool, new Random(System.nanoTime()));
        }
        if (url != null) {
            this.srvPool.add(0, new Srv(url, false));
            this.urls.put(url.getAuthority(), url);
        }
        if (this.srvPool.isEmpty()) {
            this.addUrlToPool("nats://localhost:4222", false);
        }
        this.setUrl(this.srvPool.get((int)0).url);
    }

    void addUrlToPool(String srvUrl, boolean implicit) {
        URI uri = URI.create(srvUrl);
        this.srvPool.add(new Srv(uri, implicit));
        this.urls.put(uri.getAuthority(), uri);
    }

    void addUrlToPool(URI uri, boolean implicit) {
        this.srvPool.add(new Srv(uri, implicit));
        this.urls.put(uri.getAuthority(), uri);
    }

    Srv currentServer() {
        Srv rv = null;
        for (Srv s : this.srvPool) {
            if (!s.url.equals(this.getUrl())) continue;
            rv = s;
            break;
        }
        return rv;
    }

    Srv selectNextServer() throws IOException {
        Srv srv = this.currentServer();
        if (srv == null) {
            throw new IOException("nats: no servers available for connection");
        }
        this.srvPool.remove(srv);
        int maxReconnect = this.opts.getMaxReconnect();
        if (maxReconnect < 0 || srv.reconnects < maxReconnect) {
            this.srvPool.add(srv);
        }
        if (this.srvPool.isEmpty()) {
            this.setUrl(null);
            throw new IOException("nats: no servers available for connection");
        }
        return this.srvPool.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection connect() throws IOException {
        IOException returnedErr = null;
        this.setupServerPool();
        this.mu.lock();
        try {
            for (Srv srv : this.srvPool) {
                this.setUrl(srv.url);
                try {
                    this.createConn();
                    this.setup();
                    try {
                        this.processConnectInit();
                        srv.reconnects = 0;
                        returnedErr = null;
                        break;
                    }
                    catch (IOException e) {
                        returnedErr = e;
                        this.mu.unlock();
                        this.close(Nats.ConnState.DISCONNECTED, false);
                        this.mu.lock();
                        this.setUrl(null);
                    }
                    catch (InterruptedException e) {
                        returnedErr = new IOException(e);
                        this.mu.unlock();
                        this.close(Nats.ConnState.DISCONNECTED, false);
                        this.mu.lock();
                        this.setUrl(null);
                    }
                }
                catch (IOException e) {
                    if (e.getMessage() == null || !e.getMessage().contains("Connection refused")) continue;
                    this.setLastError(null);
                }
            }
            if (returnedErr == null && this.status != Nats.ConnState.CONNECTED) {
                returnedErr = new IOException("nats: no servers available for connection");
            }
            if (returnedErr != null) {
                throw returnedErr;
            }
            this.cbexec = this.createCallbackScheduler();
            ConnectionImpl connectionImpl = this;
            return connectionImpl;
        }
        finally {
            this.mu.unlock();
        }
    }

    void createConn() throws IOException {
        if (this.opts.getConnectionTimeout() < 0) {
            throw new IOException("nats: timeout invalid");
        }
        Srv srv = this.currentServer();
        if (srv == null) {
            throw new IOException("nats: no servers available for connection");
        }
        srv.updateLastAttempt();
        this.conn = this.tcf.createConnection();
        this.conn.open(srv.url.toString(), this.opts.getConnectionTimeout());
        if (this.pending != null && this.bw != null) {
            try {
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.bw = this.conn.getOutputStream(65536);
        this.br = this.conn.getInputStream(65536);
    }

    BlockingQueue<Message> createMsgChannel() {
        return this.createMsgChannel(Integer.MAX_VALUE);
    }

    BlockingQueue<Message> createMsgChannel(int size) {
        int theSize = size;
        if (theSize <= 0) {
            theSize = 1;
        }
        return new LinkedBlockingQueue<Message>(theSize);
    }

    BlockingQueue<Boolean> createBooleanChannel() {
        return new LinkedBlockingQueue<Boolean>();
    }

    BlockingQueue<Boolean> createBooleanChannel(int size) {
        int theSize = size;
        if (theSize <= 0) {
            theSize = 1;
        }
        return new LinkedBlockingQueue<Boolean>(theSize);
    }

    BlockingQueue<Boolean> createFlushChannel() {
        return new LinkedBlockingQueue<Boolean>(1);
    }

    void clearPendingFlushCalls() {
        if (this.pongs == null) {
            return;
        }
        for (BlockingQueue<Boolean> ch : this.pongs) {
            if (ch == null) continue;
            ch.clear();
            ch.add(false);
        }
        this.pongs.clear();
        this.pongs = null;
    }

    private synchronized void clearPendingRequestCalls() {
        if (this.respMap == null) {
            return;
        }
        Iterator<Map.Entry<String, BlockingQueue<Message>>> iter = this.respMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, BlockingQueue<Message>> entry = iter.next();
            try {
                entry.getValue().put(null);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            iter.remove();
        }
    }

    @Override
    public void close() {
        this.close(Nats.ConnState.CLOSED, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(Nats.ConnState closeState, boolean doCBs) {
        final ConnectionImpl nc = this;
        this.mu.lock();
        try {
            if (this.closed()) {
                this.status = closeState;
                return;
            }
            this.status = Nats.ConnState.CLOSED;
            this.kickFlusher();
        }
        finally {
            this.mu.unlock();
        }
        this.mu.lock();
        try {
            this.clearPendingFlushCalls();
            this.clearPendingRequestCalls();
            if (this.conn != null) {
                try {
                    if (this.bw != null) {
                        this.bw.flush();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            for (Map.Entry<Long, SubscriptionImpl> entry : this.subs.entrySet()) {
                SubscriptionImpl sub = entry.getValue();
                sub.lock();
                try {
                    sub.closeChannel();
                    sub.closed = true;
                    sub.connClosed = true;
                    sub.close();
                }
                finally {
                    sub.unlock();
                }
            }
            this.subs.clear();
            if (doCBs) {
                if (this.opts.getDisconnectedCallback() != null && this.conn != null) {
                    this.cbexec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionImpl.this.opts.getDisconnectedCallback().onDisconnect(new ConnectionEvent(nc));
                        }
                    });
                }
                if (this.opts.getClosedCallback() != null) {
                    this.cbexec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionImpl.this.opts.getClosedCallback().onClose(new ConnectionEvent(nc));
                        }
                    });
                }
                if (this.cbexec != null) {
                    this.cbexec.shutdown();
                }
            }
            this.status = closeState;
            if (this.conn != null) {
                this.conn.close();
            }
            if (this.exec != null) {
                this.shutdownAndAwaitTermination(this.exec, EXEC_NAME);
            }
            if (this.subexec != null) {
                this.shutdownAndAwaitTermination(this.subexec, SUB_EXEC_NAME);
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void shutdownAndAwaitTermination(ExecutorService pool, String name) {
        try {
            pool.shutdownNow();
            pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    void processConnectInit() throws IOException, InterruptedException {
        this.status = Nats.ConnState.CONNECTING;
        this.processExpectedInfo();
        this.sendConnect();
        this.setActualPingsOutstanding(0);
        this.spinUpSocketWatchers();
    }

    void checkForSecure() throws IOException {
        if (this.opts.isSecure() && !this.info.isTlsRequired()) {
            throw new IOException("nats: secure connection not available");
        }
        if (this.info.isTlsRequired() && !this.opts.isSecure()) {
            throw new IOException("nats: secure connection required");
        }
        if (this.opts.isSecure() || "tls".equals(this.getUrl().getScheme())) {
            this.makeTlsConn();
        }
    }

    void makeTlsConn() throws IOException {
        this.conn.makeTls(this.opts.getSslContext());
        this.bw = this.conn.getOutputStream(65536);
        this.br = this.conn.getInputStream(65536);
    }

    void processExpectedInfo() throws IOException, InterruptedException {
        Control control;
        try {
            control = this.readOp();
        }
        catch (IOException e) {
            this.processOpError(e);
            return;
        }
        if (!control.op.equals(_INFO_OP_)) {
            throw new IOException("nats: protocol exception, INFO not received");
        }
        this.processInfo(control.args);
        this.checkForSecure();
    }

    void processPing() {
        try {
            this.sendProto(pongProtoBytes, pongProtoBytesLen);
        }
        catch (IOException e) {
            this.setLastError(e);
        }
    }

    void processPong() throws InterruptedException {
        BlockingQueue<Boolean> ch = null;
        this.mu.lockInterruptibly();
        try {
            if (this.pongs != null && this.pongs.size() > 0) {
                ch = this.pongs.get(0);
                this.pongs.remove(0);
            }
            this.setActualPingsOutstanding(0);
        }
        finally {
            this.mu.unlock();
        }
        if (ch != null) {
            ch.add(true);
        }
    }

    void processOk() {
    }

    void processInfo(String infoString) {
        if (infoString == null || infoString.isEmpty()) {
            return;
        }
        this.setConnectedServerInfo(ServerInfo.createFromWire(infoString));
        if (this.info.getConnectUrls() != null) {
            ArrayList<String> connectUrls = new ArrayList<String>(Arrays.asList(this.info.getConnectUrls()));
            if (connectUrls.size() > 0 && !this.opts.isNoRandomize()) {
                Collections.shuffle(connectUrls);
            }
            for (String s : connectUrls) {
                if (this.urls.containsKey(s)) continue;
                this.addUrlToPool(String.format("nats://%s", s), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processAsyncInfo(byte[] asyncInfo, int offset, int length) {
        this.mu.lock();
        try {
            String theInfo = new String(asyncInfo, offset, length);
            this.processInfo(theInfo);
        }
        finally {
            this.mu.unlock();
        }
    }

    void processOpError(Exception err) throws InterruptedException {
        block13: {
            this.mu.lockInterruptibly();
            try {
                if (this.connecting() || this.closed() || this.reconnecting()) {
                    return;
                }
                if (this.opts.isReconnectAllowed() && this.status == Nats.ConnState.CONNECTED) {
                    this.status = Nats.ConnState.RECONNECTING;
                    if (this.ptmr != null) {
                        this.ptmr.cancel(true);
                        this.tasks.remove(this.ptmr);
                    }
                    if (this.conn != null) {
                        try {
                            this.bw.flush();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.conn.close();
                    }
                    if (this.fch != null) {
                        this.fch.offer(false);
                    }
                    this.setPending(new ByteArrayOutputStream(this.opts.getReconnectBufSize()));
                    this.setOutputStream(this.getPending());
                    if (this.exec.isShutdown()) {
                        this.exec = this.createScheduler();
                    }
                    this.exec.submit(new Runnable(){

                        @Override
                        public void run() {
                            Thread.currentThread().setName("reconnect");
                            try {
                                ConnectionImpl.this.doReconnect();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                    if (this.cbexec.isShutdown()) {
                        this.cbexec = this.createCallbackScheduler();
                    }
                    break block13;
                }
                this.processDisconnect();
                this.setLastError(err);
                this.close();
            }
            finally {
                this.mu.unlock();
            }
        }
    }

    protected void processDisconnect() {
        this.status = Nats.ConnState.DISCONNECTED;
    }

    @Override
    public boolean isReconnecting() {
        this.mu.lock();
        try {
            boolean bl = this.reconnecting();
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    boolean reconnecting() {
        return this.status == Nats.ConnState.RECONNECTING;
    }

    @Override
    public boolean isConnected() {
        this.mu.lock();
        try {
            boolean bl = this.connected();
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    boolean connected() {
        return this.status == Nats.ConnState.CONNECTED;
    }

    @Override
    public boolean isClosed() {
        this.mu.lock();
        try {
            boolean bl = this.closed();
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    boolean closed() {
        return this.status == Nats.ConnState.CLOSED;
    }

    void flushReconnectPendingItems() {
        if (this.pending == null) {
            return;
        }
        if (this.pending.size() > 0) {
            try {
                this.bw.write(this.pending.toByteArray(), 0, this.pending.size());
                this.bw.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.pending = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReconnect() throws InterruptedException {
        this.waitForExits();
        this.mu.lockInterruptibly();
        try {
            this.nc.clearPendingFlushCalls();
            this.setLastError(null);
            if (this.opts.getDisconnectedCallback() != null) {
                this.cbexec.submit(new Runnable(){

                    @Override
                    public void run() {
                        ConnectionImpl.this.opts.getDisconnectedCallback().onDisconnect(new ConnectionEvent(ConnectionImpl.this.nc));
                    }
                });
            }
            while (!this.srvPool.isEmpty()) {
                Srv cur;
                try {
                    cur = this.selectNextServer();
                    this.setUrl(cur.url);
                }
                catch (IOException nse) {
                    this.setLastError(nse);
                    break;
                }
                long sleepTime = 0L;
                long timeSinceLastAttempt = cur.timeSinceLastAttempt();
                if (timeSinceLastAttempt < this.opts.getReconnectWait()) {
                    sleepTime = this.opts.getReconnectWait() - timeSinceLastAttempt;
                }
                if (sleepTime > 0L) {
                    this.mu.unlock();
                    Thread.sleep(sleepTime);
                    this.mu.lockInterruptibly();
                }
                if (this.isClosed()) break;
                ++cur.reconnects;
                try {
                    this.createConn();
                }
                catch (Exception e) {
                    this.setLastError(null);
                    continue;
                }
                this.stats.incrementReconnects();
                try {
                    this.processConnectInit();
                }
                catch (IOException e) {
                    this.setLastError(e);
                    this.status = Nats.ConnState.RECONNECTING;
                    continue;
                }
                cur.reconnects = 0;
                this.resendSubscriptions();
                this.flushReconnectPendingItems();
                try {
                    this.getOutputStream().flush();
                }
                catch (IOException e) {
                    this.setLastError(e);
                    this.status = Nats.ConnState.RECONNECTING;
                    continue;
                }
                this.setPending(null);
                this.status = Nats.ConnState.CONNECTED;
                if (this.opts.getReconnectedCallback() != null) {
                    this.cbexec.submit(new Runnable(){

                        @Override
                        public void run() {
                            ConnectionImpl.this.opts.getReconnectedCallback().onReconnect(new ConnectionEvent(ConnectionImpl.this.nc));
                        }
                    });
                }
                this.mu.unlock();
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (this.getLastException() == null) {
                this.setLastError(new IOException("nats: no servers available for connection"));
            }
        }
        finally {
            this.mu.unlock();
        }
        this.close();
    }

    boolean connecting() {
        return this.status == Nats.ConnState.CONNECTING;
    }

    Nats.ConnState status() {
        return this.status;
    }

    static String normalizeErr(String error) {
        String str = error;
        if (str != null) {
            str = str.replaceFirst("-ERR\\s+", _EMPTY_).toLowerCase();
            str = str.replaceAll("^'|'$", _EMPTY_);
        }
        return str;
    }

    static String normalizeErr(ByteBuffer error) {
        String str = Parser.bufToString(error);
        if (str != null) {
            str = str.trim();
        }
        return ConnectionImpl.normalizeErr(str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processErr(ByteBuffer error) throws InterruptedException {
        String err = ConnectionImpl.normalizeErr(error);
        if (STALE_CONNECTION.equalsIgnoreCase(err)) {
            this.processOpError(new IOException("nats: stale connection"));
        } else if (err.startsWith("permissions violation")) {
            this.processPermissionsViolation(err);
        } else {
            NATSException ex = new NATSException("nats: " + err);
            ex.setConnection(this);
            this.mu.lock();
            try {
                this.setLastError(ex);
            }
            finally {
                this.mu.unlock();
            }
            this.close();
        }
    }

    protected void sendConnect() throws IOException {
        String line;
        this.bw.write(this.connectProto().getBytes());
        this.bw.flush();
        if (this.opts.isVerbose() && !_OK_OP_.equals(line = this.readLine())) {
            throw new IOException(String.format("nats: expected '%s', got '%s'", _OK_OP_, line));
        }
        this.bw.write(pingProtoBytes, 0, pingProtoBytesLen);
        this.bw.flush();
        try {
            line = this.readLine();
        }
        catch (IOException e) {
            throw new IOException("nats: connection read error", e);
        }
        if (!PONG_PROTO.trim().equals(line)) {
            if (line.startsWith(_ERR_OP_)) {
                line = ConnectionImpl.normalizeErr(line);
                throw new IOException("nats: " + line);
            }
            throw new IOException(String.format("nats: expected '%s', got '%s'", _PONG_OP_, line));
        }
        this.status = Nats.ConnState.CONNECTED;
    }

    String readLine() throws IOException {
        BufferedReader breader = this.conn.getBufferedReader();
        String line = breader.readLine();
        if (line == null) {
            throw new EOFException("nats: connection closed");
        }
        return line;
    }

    void sendProto(byte[] value, int length) throws IOException {
        this.mu.lock();
        try {
            this.bw.write(value, 0, length);
            this.kickFlusher();
        }
        finally {
            this.mu.unlock();
        }
    }

    String connectProto() {
        String userInfo = this.getUrl().getUserInfo();
        String user = null;
        String pass = null;
        String token = null;
        if (userInfo != null) {
            String[] userpass = userInfo.split(":");
            if (userpass[0].length() > 0) {
                switch (userpass.length) {
                    case 1: {
                        token = userpass[0];
                        break;
                    }
                    case 2: {
                        user = userpass[0];
                        pass = userpass[1];
                        break;
                    }
                }
            }
        } else {
            user = this.opts.getUsername();
            pass = this.opts.getPassword();
            token = this.opts.getToken();
        }
        ConnectInfo info = new ConnectInfo(this.opts.isVerbose(), this.opts.isPedantic(), user, pass, token, this.opts.isSecure(), this.opts.getConnectionName(), LANG_STRING, this.version, ClientProto.CLIENT_PROTO_INFO);
        return String.format(CONN_PROTO, info);
    }

    Control readOp() throws IOException {
        String str = this.readLine();
        return new Control(str);
    }

    private void waitForExits() throws InterruptedException {
        this.kickFlusher();
        if (this.socketWatchersDoneLatch != null) {
            this.socketWatchersDoneLatch.await();
        }
    }

    protected void spinUpSocketWatchers() throws InterruptedException {
        this.waitForExits();
        this.socketWatchersDoneLatch = new CountDownLatch(2);
        this.socketWatchersStartLatch = new CountDownLatch(2);
        Future<?> task = this.exec.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(ConnectionImpl.READLOOP);
                ConnectionImpl.this.socketWatchersStartLatch.countDown();
                try {
                    ConnectionImpl.this.socketWatchersStartLatch.await();
                    ConnectionImpl.this.readLoop();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                }
                finally {
                    ConnectionImpl.this.socketWatchersDoneLatch.countDown();
                }
            }
        });
        this.tasks.put(READLOOP, task);
        task = this.exec.submit(new Runnable(){

            @Override
            public void run() {
                Thread.currentThread().setName(ConnectionImpl.FLUSHER);
                ConnectionImpl.this.socketWatchersStartLatch.countDown();
                try {
                    ConnectionImpl.this.socketWatchersStartLatch.await();
                    ConnectionImpl.this.flusher();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                }
                finally {
                    ConnectionImpl.this.socketWatchersDoneLatch.countDown();
                }
            }
        });
        this.tasks.put(FLUSHER, task);
        this.socketWatchersStartLatch.countDown();
        this.resetPingTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readLoop() throws InterruptedException {
        Parser parser;
        TcpConnection conn = null;
        this.mu.lockInterruptibly();
        try {
            parser = this.parser;
            if (parser.ps == null) {
                parser.ps = new Parser.ParseState();
            }
        }
        finally {
            this.mu.unlock();
        }
        byte[] buffer = new byte[65536];
        while (!Thread.currentThread().isInterrupted()) {
            boolean sb;
            this.mu.lockInterruptibly();
            try {
                boolean bl = sb = this.closed() || this.reconnecting();
                if (sb) {
                    parser.ps = new Parser.ParseState();
                }
                conn = this.conn;
            }
            finally {
                this.mu.unlock();
            }
            if (sb || conn == null) break;
            try {
                int len = this.br.read(buffer);
                if (len == -1) {
                    throw new IOException("nats: stale connection");
                }
                parser.parse(buffer, len);
            }
            catch (IOException | ParseException e) {
                if (this.status == Nats.ConnState.CLOSED) break;
                this.processOpError(e);
                break;
            }
        }
        this.mu.lockInterruptibly();
        try {
            parser.ps = null;
        }
        finally {
            this.mu.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForMsgs(AsyncSubscriptionImpl sub) throws InterruptedException {
        block13: {
            long max;
            long delivered = 0L;
            do {
                boolean closed;
                MessageHandler mcb;
                Message msg;
                sub.lock();
                try {
                    BlockingQueue<Message> mch = sub.getChannel();
                    while (mch.size() == 0 && !sub.isClosed()) {
                        sub.pCond.await();
                    }
                    msg = (Message)mch.poll();
                    if (msg != null) {
                        --sub.pMsgs;
                        sub.pBytes = sub.pBytes - (msg.getData() == null ? 0 : msg.getData().length);
                    }
                    mcb = sub.getMessageHandler();
                    max = sub.max;
                    closed = sub.isClosed();
                    if (!closed) {
                        delivered = ++sub.delivered;
                    }
                }
                finally {
                    sub.unlock();
                }
                if (closed) break block13;
                if (msg == null || max > 0L && delivered > max) continue;
                try {
                    mcb.onMessage(msg);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            } while (max <= 0L || delivered < max);
            this.mu.lock();
            try {
                this.removeSub(sub);
            }
            finally {
                this.mu.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMsg(byte[] data, int offset, int length) {
        this.mu.lock();
        try {
            this.stats.incrementInMsgs();
            this.stats.incrementInBytes(length);
            SubscriptionImpl sub = this.subs.get(this.parser.ps.ma.sid);
            if (sub == null) {
                return;
            }
            Message msg = new Message(this.parser.ps.ma, sub, data, offset, length);
            MsgDeliveryWorker mdw = sub.getDeliveryWorker();
            if (mdw != null) {
                mdw.lock();
            } else {
                sub.lock();
            }
            try {
                ++sub.pMsgs;
                if (sub.pMsgs > sub.pMsgsMax) {
                    sub.pMsgsMax = sub.pMsgs;
                }
                sub.pBytes = sub.pBytes + (msg.getData() == null ? 0 : msg.getData().length);
                if (sub.pBytes > sub.pBytesMax) {
                    sub.pBytesMax = sub.pBytes;
                }
                if (sub.pMsgsLimit > 0 && sub.pMsgs > sub.pMsgsLimit || sub.pBytesLimit > 0 && sub.pBytes > sub.pBytesLimit) {
                    this.handleSlowConsumer(sub, msg);
                } else if (mdw != null) {
                    mdw.postMsg(msg);
                } else if (sub.getChannel() != null) {
                    if (sub.getChannel().add(msg)) {
                        sub.pCond.signal();
                        sub.setSlowConsumer(false);
                    } else {
                        this.handleSlowConsumer(sub, msg);
                    }
                }
            }
            finally {
                if (mdw != null) {
                    mdw.unlock();
                } else {
                    sub.unlock();
                }
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void handleSlowConsumer(SubscriptionImpl sub, Message msg) {
        ++sub.dropped;
        this.processSlowConsumer(sub);
        --sub.pMsgs;
        if (msg.getData() != null) {
            sub.pBytes -= msg.getData().length;
        }
    }

    void removeSub(SubscriptionImpl sub) {
        this.subs.remove(sub.getSid());
        sub.lock();
        try {
            if (sub.getChannel() != null) {
                sub.mch.clear();
                sub.mch = null;
            }
            sub.setConnection(null);
            sub.closed = true;
        }
        finally {
            sub.unlock();
        }
    }

    void processSlowConsumer(SubscriptionImpl sub) {
        IOException ex = new IOException("nats: slow consumer, messages dropped");
        final NATSException nex = new NATSException(ex, this, sub);
        this.setLastError(ex);
        if (this.opts.getExceptionHandler() != null && !sub.isSlowConsumer()) {
            this.cbexec.submit(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.opts.getExceptionHandler().onException(nex);
                }
            });
        }
        sub.setSlowConsumer(true);
    }

    void processPermissionsViolation(String err) {
        IOException serverEx = new IOException("nats: " + err);
        final NATSException nex = new NATSException(serverEx);
        nex.setConnection(this);
        this.setLastError(serverEx);
        if (this.opts.getExceptionHandler() != null) {
            this.cbexec.submit(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.opts.getExceptionHandler().onException(nex);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFlushEntry(BlockingQueue<Boolean> ch) throws InterruptedException {
        this.mu.lockInterruptibly();
        try {
            if (this.pongs == null) {
                boolean bl = false;
                return bl;
            }
            for (BlockingQueue<Boolean> c : this.pongs) {
                if (!c.equals(ch)) continue;
                c.clear();
                this.pongs.remove(c);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    void sendPing(BlockingQueue<Boolean> ch) {
        if (this.pongs == null) {
            this.pongs = this.createPongs();
        }
        if (ch != null) {
            this.pongs.add(ch);
        }
        try {
            this.bw.write(pingProtoBytes, 0, pingProtoBytesLen);
            this.bw.flush();
        }
        catch (IOException e) {
            this.setLastError(e);
        }
    }

    List<BlockingQueue<Boolean>> createPongs() {
        return new ArrayList<BlockingQueue<Boolean>>();
    }

    ScheduledFuture<?> createPingTimer() {
        PingTimerTask pinger = new PingTimerTask();
        return this.exec.scheduleWithFixedDelay(pinger, this.opts.getPingInterval(), this.opts.getPingInterval(), TimeUnit.MILLISECONDS);
    }

    void resetPingTimer() {
        this.mu.lock();
        try {
            if (this.ptmr != null) {
                this.ptmr.cancel(true);
                this.tasks.remove(this.ptmr);
            }
            if (this.opts.getPingInterval() > 0L) {
                this.ptmr = this.createPingTimer();
                this.tasks.put(PINGTIMER, this.ptmr);
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    void writeUnsubProto(SubscriptionImpl sub, long max) throws IOException {
        String str = String.format(UNSUB_PROTO, sub.getSid(), max > 0L ? Long.toString(max) : _EMPTY_);
        str = str.replaceAll(" +\r\n", CRLF);
        byte[] unsub = str.getBytes();
        this.bw.write(unsub);
    }

    void unsubscribe(SubscriptionImpl sub, int max) throws IOException {
        this.unsubscribe(sub, (long)max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsubscribe(SubscriptionImpl sub, long max) throws IOException {
        this.mu.lock();
        try {
            if (this.isClosed()) {
                throw new IllegalStateException("nats: connection closed");
            }
            SubscriptionImpl subscription = this.subs.get(sub.getSid());
            if (subscription == null) {
                return;
            }
            if (max > 0L) {
                subscription.setMax(max);
            } else {
                this.removeSub(subscription);
            }
            if (!this.reconnecting()) {
                this.writeUnsubProto(subscription, max);
            }
            this.kickFlusher();
        }
        finally {
            this.mu.unlock();
        }
    }

    protected void kickFlusher() {
        if (this.bw != null && this.fch != null) {
            this.fch.offer(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flusher() throws InterruptedException {
        this.mu.lockInterruptibly();
        OutputStream bw = this.bw;
        TcpConnection conn = this.conn;
        BlockingQueue<Boolean> fch = this.fch;
        this.mu.unlock();
        if (conn == null || bw == null) {
            return;
        }
        while (fch.take().booleanValue()) {
            this.mu.lockInterruptibly();
            try {
                if (!this.connected() || this.connecting() || bw != this.bw || conn != this.conn) {
                    return;
                }
                bw.flush();
                this.stats.incrementFlushes();
            }
            catch (IOException e) {
                this.setLastError(e);
            }
            finally {
                this.mu.unlock();
            }
            this.flushTimerUnit.sleep(this.flushTimerInterval);
        }
    }

    @Override
    public void flush(int timeout) throws IOException, InterruptedException {
        if (timeout <= 0) {
            throw new IllegalArgumentException("nats: timeout invalid");
        }
        BlockingQueue<Boolean> ch = null;
        this.mu.lockInterruptibly();
        try {
            if (this.closed()) {
                throw new IllegalStateException("nats: connection closed");
            }
            ch = this.createBooleanChannel(1);
            this.sendPing(ch);
        }
        finally {
            this.mu.unlock();
        }
        Boolean rv = ch.poll(timeout, TimeUnit.MILLISECONDS);
        if (rv == null) {
            this.removeFlushEntry(ch);
            throw new IOException("nats: timeout");
        }
        if (!rv.booleanValue()) {
            throw new IllegalStateException("nats: connection closed");
        }
        ch.clear();
    }

    @Override
    public void flush() throws IOException, InterruptedException {
        this.flush(60000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resendSubscriptions() {
        long adjustedMax = 0L;
        for (Map.Entry<Long, SubscriptionImpl> entry : this.subs.entrySet()) {
            SubscriptionImpl sub;
            block10: {
                sub = entry.getValue();
                sub.lock();
                try {
                    if (sub.max <= 0L) break block10;
                    if (sub.delivered < sub.max) {
                        adjustedMax = sub.max - sub.delivered;
                    }
                    if (adjustedMax == 0L) {
                        try {
                            this.unsubscribe(sub, 0);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                finally {
                    sub.unlock();
                    continue;
                }
            }
            this.sendSubscriptionMessage(sub);
            if (adjustedMax <= 0L) continue;
            try {
                this.writeUnsubProto(sub, adjustedMax);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscriptionImpl subscribe(String subject, String queue, MessageHandler cb, BlockingQueue<Message> ch) {
        this.mu.lock();
        try {
            SubscriptionImpl sub;
            if (this.closed()) {
                throw new IllegalStateException("nats: connection closed");
            }
            if (cb == null && ch == null) {
                throw new IllegalArgumentException("nats: invalid subscription");
            }
            if (cb != null) {
                MsgDeliveryPool msgDlvPool = null;
                boolean useDlvPool = this.opts.useGlobalMsgDelivery && (msgDlvPool = Nats.getMsgDeliveryThreadPool()) != null;
                sub = new AsyncSubscriptionImpl(this, subject, queue, cb, useDlvPool);
                if (useDlvPool) {
                    msgDlvPool.assignDeliveryWorker(sub);
                } else {
                    this.subexec.submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                ConnectionImpl.this.waitForMsgs((AsyncSubscriptionImpl)sub);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                        }
                    });
                }
            } else {
                sub = new SyncSubscriptionImpl(this, subject, queue);
                sub.setChannel(ch);
            }
            this.addSubscription(sub);
            if (!this.reconnecting()) {
                this.sendSubscriptionMessage(sub);
            }
            this.kickFlusher();
            SubscriptionImpl subscriptionImpl = sub;
            return subscriptionImpl;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public SyncSubscription subscribe(String subject) {
        return this.subscribeSync(subject, null);
    }

    @Override
    public SyncSubscription subscribe(String subject, String queue) {
        return this.subscribeSync(subject, queue);
    }

    @Override
    public AsyncSubscription subscribe(String subject, MessageHandler cb) {
        return this.subscribe(subject, null, cb);
    }

    @Override
    public AsyncSubscription subscribe(String subj, String queue, MessageHandler cb) {
        return (AsyncSubscription)((Object)this.subscribe(subj, queue, cb, null));
    }

    @Override
    @Deprecated
    public AsyncSubscription subscribeAsync(String subject, String queue, MessageHandler cb) {
        return (AsyncSubscription)((Object)this.subscribe(subject, queue, cb, null));
    }

    @Override
    @Deprecated
    public AsyncSubscription subscribeAsync(String subj, MessageHandler cb) {
        return this.subscribe(subj, null, cb);
    }

    private void addSubscription(SubscriptionImpl sub) {
        sub.setSid(this.sidCounter.incrementAndGet());
        this.subs.put(sub.getSid(), sub);
    }

    @Override
    public SyncSubscription subscribeSync(String subject, String queue) {
        return (SyncSubscription)((Object)this.subscribe(subject, queue, null, this.createMsgChannel()));
    }

    @Override
    public SyncSubscription subscribeSync(String subject) {
        return (SyncSubscription)((Object)this.subscribe(subject, null, null, this.createMsgChannel()));
    }

    void writePublishProto(ByteBuffer buffer, byte[] subject, byte[] reply, int msgSize) {
        this.pubProtoBuf.put(subject, 0, subject.length);
        if (reply != null) {
            this.pubProtoBuf.put((byte)32);
            this.pubProtoBuf.put(reply, 0, reply.length);
        }
        this.pubProtoBuf.put((byte)32);
        byte[] bytes = new byte[12];
        int idx = bytes.length;
        if (msgSize > 0) {
            for (int l = msgSize; l > 0; l /= 10) {
                bytes[--idx] = digits[l % 10];
            }
        } else {
            bytes[--idx] = digits[0];
        }
        this.pubProtoBuf.put(bytes, idx, bytes.length - idx);
        this.pubProtoBuf.put(crlfProtoBytes, 0, crlfProtoBytesLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void publish(byte[] subject, byte[] reply, byte[] data, boolean forceFlush) throws IOException {
        int msgSize = data != null ? data.length : 0;
        this.mu.lock();
        try {
            if ((long)msgSize > this.info.getMaxPayload()) {
                throw new IllegalArgumentException("nats: maximum payload exceeded");
            }
            if (this.closed()) {
                throw new IllegalStateException("nats: connection closed");
            }
            if (this.reconnecting()) {
                try {
                    this.bw.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.pending.size() >= this.opts.getReconnectBufSize()) {
                    throw new IOException("nats: outbound buffer limit exceeded");
                }
            }
            try {
                this.writePublishProto(this.pubProtoBuf, subject, reply, msgSize);
            }
            catch (BufferOverflowException e) {
                int resizeAmount = 1024 + subject.length + (reply != null ? reply.length : 0);
                this.buildPublishProtocolBuffer(resizeAmount);
                this.writePublishProto(this.pubProtoBuf, subject, reply, msgSize);
            }
            try {
                this.bw.write(this.pubProtoBuf.array(), 0, this.pubProtoBuf.position());
                this.pubProtoBuf.position(pubPrimBytesLen);
                if (msgSize > 0) {
                    this.bw.write(data, 0, msgSize);
                }
                this.bw.write(crlfProtoBytes, 0, crlfProtoBytesLen);
            }
            catch (IOException e) {
                this.setLastError(e);
                this.mu.unlock();
                return;
            }
            this.stats.incrementOutMsgs();
            this.stats.incrementOutBytes(msgSize);
            if (forceFlush) {
                try {
                    this.bw.flush();
                    this.stats.incrementFlushes();
                }
                catch (IOException iOException) {}
            } else if (this.fch.isEmpty()) {
                this.kickFlusher();
            }
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void publish(String subject, String reply, byte[] data, boolean flush) throws IOException {
        if (subject == null) {
            throw new NullPointerException("nats: invalid subject");
        }
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("nats: invalid subject");
        }
        byte[] subjBytes = subject.getBytes();
        byte[] replyBytes = null;
        if (reply != null) {
            replyBytes = reply.getBytes();
        }
        this.publish(subjBytes, replyBytes, data, flush);
    }

    @Override
    public void publish(String subject, String reply, byte[] data) throws IOException {
        this.publish(subject, reply, data, false);
    }

    @Override
    public void publish(String subject, byte[] data) throws IOException {
        this.publish(subject, null, data);
    }

    @Override
    public void publish(Message msg) throws IOException {
        this.publish(msg.getSubjectBytes(), msg.getReplyToBytes(), msg.getData(), false);
    }

    @Override
    public Message request(String subject, byte[] data, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        Message response;
        if (this.opts.useOldRequestStyle) {
            return this.oldRequest(subject, data, timeout, unit);
        }
        this.createRespMux();
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        String respInbox = this.newRespInbox();
        String token = this.respToken(respInbox);
        this.respMap.put(token, queue);
        this.publish(subject, respInbox, data);
        if (timeout < 0L) {
            response = (Message)queue.take();
        } else {
            response = (Message)queue.poll(timeout, unit);
            if (response == null) {
                this.respMap.remove(token);
            }
        }
        return response;
    }

    @Override
    public Message request(String subject, byte[] data, long timeout) throws IOException, InterruptedException {
        return this.request(subject, data, timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Message request(String subject, byte[] data) throws IOException, InterruptedException {
        return this.request(subject, data, -1L, TimeUnit.MILLISECONDS);
    }

    private synchronized void createRespMux() {
        if (this.respMap != null) {
            return;
        }
        this.respSub = String.format("%s.*", this.newInbox());
        this.respMux = this.subscribe(this.respSub, new RespHandler());
        this.respMap = new ConcurrentHashMap();
    }

    private String newRespInbox() {
        byte[] b = new byte[RESP_INBOX_PREFIX_LEN + 22];
        byte[] respSubBytes = this.respSub.getBytes();
        System.arraycopy(respSubBytes, 0, b, 0, RESP_INBOX_PREFIX_LEN);
        byte[] nuid = NUID.nextGlobal().getBytes();
        System.arraycopy(nuid, 0, b, RESP_INBOX_PREFIX_LEN, nuid.length);
        return new String(b);
    }

    private String respToken(String respInbox) {
        return respInbox.substring(RESP_INBOX_PREFIX_LEN);
    }

    private Message oldRequest(String subject, byte[] data, long timeout, TimeUnit unit) throws IOException, InterruptedException {
        String inbox = this.newInbox();
        BlockingQueue<Message> ch = this.createMsgChannel(8);
        try (SyncSubscription sub = (SyncSubscription)((Object)this.subscribe(inbox, null, null, ch));){
            sub.autoUnsubscribe(1);
            this.publish(subject, inbox, data);
            Message message = sub.nextMessage(timeout, unit);
            return message;
        }
    }

    @Override
    public String newInbox() {
        return String.format("%s%s", INBOX_PREFIX, NUID.nextGlobal());
    }

    @Override
    public synchronized Statistics getStats() {
        return new Statistics(this.stats);
    }

    @Override
    public synchronized void resetStats() {
        this.stats.clear();
    }

    @Override
    public synchronized long getMaxPayload() {
        return this.info.getMaxPayload();
    }

    void sendSubscriptionMessage(SubscriptionImpl sub) {
        String queue = sub.getQueue();
        String subLine = String.format(SUB_PROTO, sub.getSubject(), queue != null && !queue.isEmpty() ? _SPC_ + queue : _EMPTY_, sub.getSid());
        try {
            this.bw.write(subLine.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public ClosedCallback getClosedCallback() {
        this.mu.lock();
        try {
            ClosedCallback closedCallback = this.opts.getClosedCallback();
            return closedCallback;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void setClosedCallback(ClosedCallback cb) {
        this.mu.lock();
        try {
            this.opts.closedCb = cb;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public DisconnectedCallback getDisconnectedCallback() {
        this.mu.lock();
        try {
            DisconnectedCallback disconnectedCallback = this.opts.getDisconnectedCallback();
            return disconnectedCallback;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void setDisconnectedCallback(DisconnectedCallback cb) {
        this.mu.lock();
        try {
            this.opts.disconnectedCb = cb;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public ReconnectedCallback getReconnectedCallback() {
        this.mu.lock();
        try {
            ReconnectedCallback reconnectedCallback = this.opts.getReconnectedCallback();
            return reconnectedCallback;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void setReconnectedCallback(ReconnectedCallback cb) {
        this.mu.lock();
        try {
            this.opts.reconnectedCb = cb;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public ExceptionHandler getExceptionHandler() {
        this.mu.lock();
        try {
            ExceptionHandler exceptionHandler = this.opts.getExceptionHandler();
            return exceptionHandler;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.mu.lock();
        try {
            this.opts.asyncErrorCb = exceptionHandler;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getConnectedUrl() {
        this.mu.lock();
        try {
            if (this.status != Nats.ConnState.CONNECTED) {
                String string = null;
                return string;
            }
            String string = this.getUrl().toString();
            return string;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String getConnectedServerId() {
        this.mu.lock();
        try {
            if (this.status != Nats.ConnState.CONNECTED) {
                String string = null;
                return string;
            }
            String string = this.info.getId();
            return string;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public Nats.ConnState getState() {
        this.mu.lock();
        try {
            Nats.ConnState connState = this.status;
            return connState;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public ServerInfo getConnectedServerInfo() {
        return this.info;
    }

    void setConnectedServerInfo(ServerInfo info) {
        this.info = info;
    }

    @Override
    public Exception getLastException() {
        return this.lastEx;
    }

    void setLastError(Exception err) {
        this.lastEx = err;
    }

    @Override
    public String getName() {
        return this.opts.connectionName;
    }

    Options getOptions() {
        return this.opts;
    }

    void setOptions(Options options) {
        this.opts = options;
    }

    void setPending(ByteArrayOutputStream pending) {
        this.pending = pending;
    }

    ByteArrayOutputStream getPending() {
        return this.pending;
    }

    void setOutputStream(OutputStream out) {
        this.mu.lock();
        try {
            this.bw = out;
        }
        finally {
            this.mu.unlock();
        }
    }

    OutputStream getOutputStream() {
        return this.bw;
    }

    void setInputStream(InputStream in) {
        this.mu.lock();
        try {
            this.br = in;
        }
        finally {
            this.mu.unlock();
        }
    }

    InputStream getInputStream() {
        return this.br;
    }

    List<BlockingQueue<Boolean>> getPongs() {
        return this.pongs;
    }

    void setPongs(List<BlockingQueue<Boolean>> pongs) {
        this.pongs = pongs;
    }

    Map<Long, SubscriptionImpl> getSubs() {
        return this.subs;
    }

    void setSubs(Map<Long, SubscriptionImpl> subs) {
        this.subs = subs;
    }

    List<Srv> getServerPool() {
        return this.srvPool;
    }

    void setServerPool(List<Srv> pool) {
        this.srvPool = pool;
    }

    @Override
    public int getPendingByteCount() {
        int rv = 0;
        if (this.getPending() != null) {
            rv = this.getPending().size();
        }
        return rv;
    }

    protected void setFlushChannel(BlockingQueue<Boolean> fch) {
        this.fch = fch;
    }

    protected BlockingQueue<Boolean> getFlushChannel() {
        return this.fch;
    }

    void setTcpConnection(TcpConnection conn) {
        this.conn = conn;
    }

    TcpConnection getTcpConnection() {
        return this.conn;
    }

    void setTcpConnectionFactory(TcpConnectionFactory factory) {
        this.tcf = factory;
    }

    TcpConnectionFactory getTcpConnectionFactory() {
        return this.tcf;
    }

    URI getUrl() {
        return this.url;
    }

    void setUrl(URI url) {
        this.url = url;
    }

    int getActualPingsOutstanding() {
        return this.pout;
    }

    void setActualPingsOutstanding(int pout) {
        this.pout = pout;
    }

    ScheduledFuture<?> getPingTimer() {
        return this.ptmr;
    }

    void setPingTimer(ScheduledFuture<?> ptmr) {
        this.ptmr = ptmr;
    }

    void setParser(Parser parser) {
        this.parser = parser;
    }

    Parser getParser() {
        return this.parser;
    }

    String[] getServers(boolean implicitOnly) {
        ArrayList<String> serversList = new ArrayList<String>(this.srvPool.size());
        for (Srv aSrvPool : this.srvPool) {
            if (implicitOnly && !aSrvPool.isImplicit()) continue;
            URI url = aSrvPool.url;
            String schemeUrl = String.format("%s://%s:%d", url.getScheme(), url.getHost(), url.getPort());
            serversList.add(schemeUrl);
        }
        String[] servers = new String[serversList.size()];
        return serversList.toArray(servers);
    }

    @Override
    public String[] getServers() {
        this.mu.lock();
        try {
            String[] stringArray = this.getServers(false);
            return stringArray;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public String[] getDiscoveredServers() {
        this.mu.lock();
        try {
            String[] stringArray = this.getServers(true);
            return stringArray;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public boolean isAuthRequired() {
        this.mu.lock();
        try {
            boolean bl = this.info.isAuthRequired();
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    @Override
    public boolean isTlsRequired() {
        this.mu.lock();
        try {
            boolean bl = this.info.isTlsRequired();
            return bl;
        }
        finally {
            this.mu.unlock();
        }
    }

    class PingTimerTask
    extends TimerTask {
        PingTimerTask() {
        }

        @Override
        public void run() {
            boolean stale = false;
            ConnectionImpl.this.mu.lock();
            try {
                if (!ConnectionImpl.this.connected()) {
                    return;
                }
                ConnectionImpl.this.setActualPingsOutstanding(ConnectionImpl.this.getActualPingsOutstanding() + 1);
                if (ConnectionImpl.this.getActualPingsOutstanding() > ConnectionImpl.this.opts.getMaxPingsOut()) {
                    stale = true;
                    return;
                }
                ConnectionImpl.this.sendPing(null);
            }
            finally {
                ConnectionImpl.this.mu.unlock();
                if (stale) {
                    try {
                        ConnectionImpl.this.processOpError(new IOException("nats: stale connection"));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        }
    }

    static class Srv {
        URI url = null;
        int reconnects = 0;
        long lastAttemptNanos = 0L;
        boolean implicit = false;

        Srv(URI url, boolean implicit) {
            this.url = url;
            this.implicit = implicit;
        }

        boolean isImplicit() {
            return this.implicit;
        }

        void updateLastAttempt() {
            this.lastAttemptNanos = System.nanoTime();
        }

        long timeSinceLastAttempt() {
            return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.lastAttemptNanos);
        }

        public String toString() {
            return String.format("{url=%s, reconnects=%d, timeSinceLastAttempt=%dms}", this.url.toString(), this.reconnects, this.timeSinceLastAttempt());
        }
    }

    static class ConnectInfo {
        @SerializedName(value="verbose")
        private final Boolean verbose;
        @SerializedName(value="pedantic")
        private final Boolean pedantic;
        @SerializedName(value="user")
        private final String user;
        @SerializedName(value="pass")
        private final String pass;
        @SerializedName(value="auth_token")
        private final String token;
        @SerializedName(value="tls_required")
        private final Boolean tlsRequired;
        @SerializedName(value="name")
        private final String name;
        @SerializedName(value="lang")
        private String lang = "java";
        @SerializedName(value="version")
        private String version;
        @SerializedName(value="protocol")
        private final int protocol;
        private final transient Gson gson = new GsonBuilder().create();

        public ConnectInfo(boolean verbose, boolean pedantic, String username, String password, String token, boolean secure, String connectionName, String lang, String version, ClientProto proto) {
            this.verbose = verbose;
            this.pedantic = pedantic;
            this.user = username;
            this.pass = password;
            this.token = token;
            this.tlsRequired = secure;
            this.name = connectionName;
            this.lang = lang;
            this.version = version;
            this.protocol = proto.getValue();
        }

        public String toString() {
            return this.gson.toJson(this);
        }
    }

    static class Control {
        String op = null;
        String args = null;

        Control(String line) {
            if (line == null) {
                return;
            }
            String[] parts = line.split(ConnectionImpl._SPC_, 2);
            switch (parts.length) {
                case 1: {
                    this.op = parts[0].trim();
                    break;
                }
                case 2: {
                    this.op = parts[0].trim();
                    this.args = parts[1].trim();
                    if (!this.args.isEmpty()) break;
                    this.args = null;
                    break;
                }
            }
        }

        public String toString() {
            return "{op=" + this.op + ", args=" + this.args + "}";
        }
    }

    private final class RespHandler
    implements MessageHandler {
        private RespHandler() {
        }

        @Override
        public void onMessage(Message msg) {
            String token = ConnectionImpl.this.respToken(msg.getSubject());
            if (ConnectionImpl.this.isClosed()) {
                return;
            }
            BlockingQueue queue = (BlockingQueue)ConnectionImpl.this.respMap.get(token);
            if (queue == null) {
                return;
            }
            ConnectionImpl.this.respMap.remove(token);
            queue.offer(msg);
        }
    }

    static enum ClientProto {
        CLIENT_PROTO_ZERO(0),
        CLIENT_PROTO_INFO(1);

        private final int value;

        private ClientProto(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

