/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import io.nats.client.Connection;
import io.nats.client.MsgDeliveryPool;
import io.nats.client.Options;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public final class Nats {
    public static final String DEFAULT_HOST = "localhost";
    static final String PFX = "io.nats.client.";
    public static final String PROP_RECONNECTED_CB = "io.nats.client.callback.reconnected";
    public static final String PROP_DISCONNECTED_CB = "io.nats.client.callback.disconnected";
    public static final String PROP_CLOSED_CB = "io.nats.client.callback.closed";
    public static final String PROP_EXCEPTION_HANDLER = "io.nats.client.callback.exception";
    public static final String PROP_MAX_PINGS = "io.nats.client.maxpings";
    public static final String PROP_PING_INTERVAL = "io.nats.client.pinginterval";
    public static final String PROP_CONNECTION_TIMEOUT = "io.nats.client.timeout";
    public static final String PROP_RECONNECT_BUF_SIZE = "io.nats.client.reconnect.buffer.size";
    public static final String PROP_RECONNECT_WAIT = "io.nats.client.reconnect.wait";
    public static final String PROP_MAX_RECONNECT = "io.nats.client.reconnect.max";
    public static final String PROP_RECONNECT_ALLOWED = "io.nats.client.reconnect.allowed";
    public static final String PROP_TLS_DEBUG = "io.nats.client.tls.debug";
    public static final String PROP_SECURE = "io.nats.client.secure";
    public static final String PROP_PEDANTIC = "io.nats.client.pedantic";
    public static final String PROP_VERBOSE = "io.nats.client.verbose";
    public static final String PROP_CONNECTION_NAME = "io.nats.client.name";
    public static final String PROP_NORANDOMIZE = "io.nats.client.norandomize";
    public static final String PROP_SERVERS = "io.nats.client.servers";
    public static final String PROP_PASSWORD = "io.nats.client.password";
    public static final String PROP_USERNAME = "io.nats.client.username";
    public static final String PROP_PORT = "io.nats.client.port";
    public static final String PROP_HOST = "io.nats.client.host";
    public static final String PROP_URL = "io.nats.client.url";
    public static final String PROP_USE_OLD_REQUEST_STYLE = "use.old.request.style";
    public static final String PROP_USE_GLOBAL_MSG_DELIVERY = "io.nats.client.use.global.msg.delivery";
    private static final int SECOND = 1000;
    private static final int MINUTE = 60000;
    static final String PERMISSIONS_ERR = "permissions violation";
    static final String STALE_CONNECTION = "stale connection";
    public static final String DEFAULT_URL = "nats://localhost:4222";
    public static final int DEFAULT_PORT = 4222;
    public static final int DEFAULT_MAX_RECONNECT = 60;
    public static final int DEFAULT_RECONNECT_WAIT = 2000;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_PING_INTERVAL = 120000;
    public static final int DEFAULT_MAX_PINGS_OUT = 2;
    public static final int DEFAULT_RECONNECT_BUF_SIZE = 0x800000;
    public static final String ERR_CONNECTION_CLOSED = "nats: connection closed";
    public static final String ERR_SECURE_CONN_REQUIRED = "nats: secure connection required";
    public static final String ERR_SECURE_CONN_WANTED = "nats: secure connection not available";
    public static final String ERR_BAD_SUBSCRIPTION = "nats: invalid subscription";
    public static final String ERR_BAD_SUBJECT = "nats: invalid subject";
    public static final String ERR_SLOW_CONSUMER = "nats: slow consumer, messages dropped";
    public static final String ERR_TCP_FLUSH_FAILED = "nats: i/o exception when flushing output stream";
    public static final String ERR_TIMEOUT = "nats: timeout";
    public static final String ERR_BAD_TIMEOUT = "nats: timeout invalid";
    public static final String ERR_AUTHORIZATION = "nats: authorization violation";
    public static final String ERR_NO_SERVERS = "nats: no servers available for connection";
    public static final String ERR_JSON_PARSE = "nats: connect message, json parse err";
    public static final String ERR_MAX_PAYLOAD = "nats: maximum payload exceeded";
    public static final String ERR_MAX_MESSAGES = "nats: maximum messages delivered";
    public static final String ERR_SYNC_SUB_REQUIRED = "nats: illegal call on an async subscription";
    public static final String ERR_NO_INFO_RECEIVED = "nats: protocol exception, INFO not received";
    public static final String ERR_RECONNECT_BUF_EXCEEDED = "nats: outbound buffer limit exceeded";
    public static final String ERR_INVALID_CONNECTION = "nats: invalid connection";
    public static final String ERR_INVALID_MESSAGE = "nats: invalid message or message nil";
    public static final String ERR_STALE_CONNECTION = "nats: stale connection";
    public static final String ERR_PERMISSIONS_VIOLATION = "nats: permissions violation";
    public static final String ERR_CONNECTION_READ = "nats: connection read error";
    public static final String ERR_PROTOCOL = "nats: protocol error";
    static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";
    static final String DEFAULT_LANG_STRING = "java";
    static final String PROP_PROPERTIES_FILENAME = "jnats.properties";
    static final String PROP_CLIENT_VERSION = "client.version";
    protected static final String SERVER_ERR_PARSER = "'Parser Error'";
    protected static final String SERVER_ERR_AUTH_TIMEOUT = "'Authorization Timeout'";
    static final String SERVER_ERR_AUTH_VIOLATION = "'Authorization Violation'";
    protected static final String SERVER_ERR_MAX_PAYLOAD = "'Maximum Payload Violation'";
    protected static final String SERVER_ERR_INVALID_SUBJECT = "'Invalid Subject'";
    protected static final String SERVER_UNKNOWN_PROTOCOL_OP = "'Unknown Protocol Operation'";
    protected static final String SERVER_ERR_TLS_REQUIRED = "'Secure Connection - TLS Required'";
    static final String NATS_SCHEME = "nats";
    static final String TCP_SCHEME = "tcp";
    static final String TLS_SCHEME = "tls";
    protected static final String SYSTEM_ENV_MSG_DELIVERY_THREAD_POOL_SIZE = "JNATS_MSG_DELIVERY_THREAD_POOL_SIZE";
    private static MsgDeliveryPool globalMsgDeliveryPool = null;

    private Nats() {
    }

    public static Connection connect() throws IOException {
        return Nats.connect(DEFAULT_URL, Nats.defaultOptions());
    }

    public static Connection connect(String url) throws IOException {
        return Nats.connect(url, Nats.defaultOptions());
    }

    public static Connection connect(String url, Options options) throws IOException {
        Options opts = options;
        if (opts == null) {
            opts = Nats.defaultOptions();
        }
        opts.servers = Nats.processUrlString(url);
        return opts.connect();
    }

    public static Options defaultOptions() {
        return new Options.Builder().build();
    }

    static List<URI> processUrlString(String url) {
        ArrayList<URI> servers = null;
        if (url != null) {
            String[] urls = url.split(",");
            servers = new ArrayList<URI>(urls.length);
            for (String item : urls) {
                if (item.trim().isEmpty()) continue;
                servers.add(URI.create(item.trim()));
            }
        }
        return servers;
    }

    static List<URI> processUrlArray(String[] servers) {
        ArrayList<URI> list = null;
        if (servers != null && servers.length > 0) {
            list = new ArrayList<URI>(servers.length);
            for (String s : servers) {
                try {
                    list.add(new URI(s.trim()));
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        return list;
    }

    public static synchronized void setMsgDeliveryThreadPoolSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Pool size cannot be set to a value lower than 1");
        }
        if (globalMsgDeliveryPool == null) {
            globalMsgDeliveryPool = new MsgDeliveryPool();
        }
        globalMsgDeliveryPool.setSize(size);
    }

    public static synchronized int getMsgDeliveryThreadPoolSize() {
        if (globalMsgDeliveryPool == null) {
            return 0;
        }
        return globalMsgDeliveryPool.getSize();
    }

    public static synchronized void shutdownMsgDeliveryThreadPool() {
        if (globalMsgDeliveryPool == null) {
            return;
        }
        globalMsgDeliveryPool.shutdown();
        globalMsgDeliveryPool = null;
    }

    protected static synchronized MsgDeliveryPool getMsgDeliveryThreadPool() {
        return globalMsgDeliveryPool;
    }

    static {
        String msgDeliveryPoolSizeStr = System.getenv(SYSTEM_ENV_MSG_DELIVERY_THREAD_POOL_SIZE);
        if (msgDeliveryPoolSizeStr != null) {
            int poolSize = 0;
            try {
                poolSize = Integer.parseInt(msgDeliveryPoolSizeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (poolSize > 0) {
                Nats.setMsgDeliveryThreadPoolSize(poolSize);
            }
        }
    }

    public static enum ConnState {
        DISCONNECTED,
        CONNECTED,
        CLOSED,
        RECONNECTING,
        CONNECTING;

    }
}

