/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

class NatsThread
extends Thread {
    public static final String DEFAULT_NAME = "NatsThread";
    private static final AtomicInteger created = new AtomicInteger();
    private static final AtomicInteger alive = new AtomicInteger();
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;

    public NatsThread(Runnable r) {
        this(r, DEFAULT_NAME);
    }

    public NatsThread(Runnable runnable, String name) {
        super(runnable, name + "-" + created.incrementAndGet());
        this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
            }
        });
    }

    public NatsThread(Runnable r, String poolName, CountDownLatch startSignal, CountDownLatch doneSignal) {
        super(r, poolName);
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
    }

    @Override
    public void run() {
        try {
            if (this.startSignal != null) {
                this.startSignal.await();
            }
            alive.incrementAndGet();
            super.run();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.doneSignal != null) {
                this.doneSignal.countDown();
            }
            alive.decrementAndGet();
        }
    }

    public static int getThreadsCreated() {
        return created.get();
    }

    public static int getThreadsAlive() {
        return alive.get();
    }
}

