/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.Arrays;
import java.util.Objects;

class ServerInfo {
    @SerializedName(value="server_id")
    private String id;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="go")
    private String goVersion;
    @SerializedName(value="host")
    private String host;
    @SerializedName(value="port")
    private int port;
    @SerializedName(value="auth_required")
    private boolean authRequired;
    @SerializedName(value="ssl_required")
    private boolean sslRequired;
    @SerializedName(value="tls_required")
    private boolean tlsRequired;
    @SerializedName(value="tls_verify")
    private boolean tlsVerify;
    @SerializedName(value="max_payload")
    private long maxPayload;
    @SerializedName(value="connect_urls")
    private String[] connectUrls;
    private transient String jsonString = null;
    private static final transient Gson gson = new GsonBuilder().create();

    protected ServerInfo() {
    }

    ServerInfo(String id, String host, int port, String version, boolean authRequired, boolean tlsRequired, int maxPayload, String[] connectUrls) {
        this.id = id;
        this.host = host;
        this.port = port;
        this.version = version;
        this.authRequired = authRequired;
        this.tlsRequired = tlsRequired;
        this.maxPayload = maxPayload;
        if (connectUrls != null) {
            this.connectUrls = Arrays.copyOf(connectUrls, connectUrls.length);
        }
    }

    ServerInfo(ServerInfo input) {
        this.id = input.id;
        this.version = input.version;
        this.goVersion = input.goVersion;
        this.host = input.host;
        this.port = input.port;
        this.authRequired = input.authRequired;
        this.sslRequired = input.sslRequired;
        this.tlsRequired = input.tlsRequired;
        this.tlsVerify = input.tlsVerify;
        this.maxPayload = input.maxPayload;
        if (input.connectUrls != null) {
            this.connectUrls = Arrays.copyOf(input.connectUrls, input.connectUrls.length);
        }
    }

    static ServerInfo createFromWire(String infoString) {
        String jsonString = infoString.replaceFirst("^INFO ", "").trim();
        ServerInfo rv = gson.fromJson(jsonString, ServerInfo.class);
        return rv;
    }

    String getId() {
        return this.id;
    }

    void setId(String id) {
        this.id = id;
    }

    String getGoVersion() {
        return this.goVersion;
    }

    void setGoVersion(String goVersion) {
        this.goVersion = goVersion;
    }

    String getHost() {
        return this.host;
    }

    void setHost(String host) {
        this.host = host;
    }

    int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    String getVersion() {
        return this.version;
    }

    void setVersion(String version) {
        this.version = version;
    }

    boolean isAuthRequired() {
        return this.authRequired;
    }

    void setAuthRequired(boolean authRequired) {
        this.authRequired = authRequired;
    }

    boolean isTlsRequired() {
        return this.tlsRequired;
    }

    void setTlsRequired(boolean tlsRequired) {
        this.tlsRequired = tlsRequired;
    }

    boolean isSslRequired() {
        return this.sslRequired;
    }

    void setSslRequired(boolean sslRequired) {
        this.sslRequired = sslRequired;
    }

    boolean isTlsVerify() {
        return this.tlsVerify;
    }

    void setTlsVerify(boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    long getMaxPayload() {
        return this.maxPayload;
    }

    void setMaxPayload(long maxPayload) {
        this.maxPayload = maxPayload;
    }

    String[] getConnectUrls() {
        return this.connectUrls;
    }

    void setConnectUrls(String[] connectUrls) {
        this.connectUrls = Arrays.copyOf(connectUrls, connectUrls.length);
    }

    public String toString() {
        if (this.jsonString == null) {
            this.jsonString = gson.toJson(this);
        }
        String rv = String.format("INFO %s", this.jsonString);
        return rv;
    }

    public static boolean compare(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equals(str2);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServerInfo)) {
            return false;
        }
        ServerInfo other = (ServerInfo)obj;
        return ServerInfo.compare(this.id, other.id) && ServerInfo.compare(this.version, other.version) && ServerInfo.compare(this.goVersion, other.goVersion) && ServerInfo.compare(this.host, other.host) && Integer.compare(this.port, other.port) == 0 && Boolean.compare(this.authRequired, other.authRequired) == 0 && Boolean.compare(this.sslRequired, other.sslRequired) == 0 && Boolean.compare(this.tlsRequired, other.tlsRequired) == 0 && Boolean.compare(this.tlsVerify, other.tlsVerify) == 0 && Long.compare(this.maxPayload, other.maxPayload) == 0 && Arrays.equals(this.connectUrls, other.connectUrls);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.goVersion, this.host, this.port, this.authRequired, this.sslRequired, this.tlsRequired, this.tlsVerify, this.maxPayload, this.connectUrls);
    }
}

