/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.StreamingConnectionImpl;
import java.io.IOException;

public final class NatsStreaming {
    static final String DEFAULT_NATS_URL = "nats://localhost:4222";
    static final int DEFAULT_CONNECT_WAIT = 2;
    static final String DEFAULT_DISCOVER_PREFIX = "_STAN.discover";
    static final String DEFAULT_ACK_PREFIX = "_STAN.acks";
    static final int DEFAULT_MAX_PUB_ACKS_IN_FLIGHT = 16384;
    static final String PFX = "stan: ";
    static final String ERR_CONNECTION_REQ_TIMEOUT = "stan: connect request timeout";
    static final String ERR_CLOSE_REQ_TIMEOUT = "stan: close request timeout";
    static final String ERR_SUB_REQ_TIMEOUT = "stan: subscribe request timeout";
    static final String ERR_UNSUB_REQ_TIMEOUT = "stan: unsubscribe request timeout";
    static final String ERR_CONNECTION_CLOSED = "stan: connection closed";
    static final String ERR_TIMEOUT = "stan: publish ack timeout";
    static final String ERR_BAD_ACK = "stan: malformed ack";
    static final String ERR_BAD_SUBSCRIPTION = "stan: invalid subscription";
    static final String ERR_BAD_CONNECTION = "stan: invalid connection";
    static final String ERR_MANUAL_ACK = "stan: cannot manually ack in auto-ack mode";
    static final String ERR_NULL_MSG = "stan: null message";
    static final String ERR_NO_SERVER_SUPPORT = "stan: not supported by server";
    static final String SERVER_ERR_INVALID_SUBJECT = "stan: invalid subject";
    static final String SERVER_ERR_INVALID_SEQUENCE = "stan: invalid start sequence";
    static final String SERVER_ERR_INVALID_TIME = "stan: invalid start time";
    static final String SERVER_ERR_INVALID_SUB = "stan: invalid subscription";
    static final String SERVER_ERR_INVALID_CLIENT = "stan: clientID already registered";
    static final String SERVER_ERR_INVALID_ACK_WAIT = "stan: invalid ack wait time, should be >= 1s";
    static final String SERVER_ERR_INVALID_CONN_REQ = "stan: invalid connection request";
    static final String SERVER_ERR_INVALID_PUB_REQ = "stan: invalid publish request";
    static final String SERVER_ERR_INVALID_SUB_REQ = "stan: invalid subscription request";
    static final String SERVER_ERR_INVALID_UNSUB_REQ = "stan: invalid unsubscribe request";
    static final String SERVER_ERR_INVALID_CLOSE_REQ = "stan: invalid close request";
    static final String SERVER_ERR_DUP_DURABLE = "stan: duplicate durable registration";
    static final String SERVER_ERR_INVALID_DURABLE_NAME = "stan: durable name of a durable queue subscriber can't contain the character ':'";
    static final String SERVER_ERR_UNKNOWN_CLIENT = "stan: unknown clientID";

    private NatsStreaming() {
    }

    public static StreamingConnection connect(String clusterId, String clientId) throws IOException, InterruptedException {
        return NatsStreaming.connect(clusterId, clientId, NatsStreaming.defaultOptions());
    }

    public static StreamingConnection connect(String clusterId, String clientId, Options opts) throws IOException, InterruptedException {
        try {
            StreamingConnectionImpl conn = new StreamingConnectionImpl(clusterId, clientId, opts);
            return conn.connect();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static Options defaultOptions() {
        return new Options.Builder().build();
    }
}

