/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.client.Connection;
import io.nats.client.Message;
import io.nats.streaming.MessageHandler;
import io.nats.streaming.StreamingConnectionImpl;
import io.nats.streaming.Subscription;
import io.nats.streaming.SubscriptionOptions;
import io.nats.streaming.protobuf.SubscriptionResponse;
import io.nats.streaming.protobuf.UnsubscribeRequest;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class SubscriptionImpl
implements Subscription {
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    StreamingConnectionImpl sc;
    private String subject;
    private String qgroup;
    String inbox;
    String ackInbox;
    SubscriptionOptions opts = new SubscriptionOptions.Builder().build();
    MessageHandler cb;

    SubscriptionImpl() {
    }

    SubscriptionImpl(String subject, String qgroup, MessageHandler cb, StreamingConnectionImpl sc, SubscriptionOptions opts) {
        this.subject = subject;
        this.qgroup = qgroup;
        this.cb = cb;
        this.sc = sc;
        if (opts != null) {
            this.opts = opts;
        }
        this.inbox = sc.newInbox();
    }

    void rLock() {
        this.rwlock.readLock().lock();
    }

    void rUnlock() {
        this.rwlock.readLock().unlock();
    }

    void wLock() {
        this.rwlock.writeLock().lock();
    }

    void wUnlock() {
        this.rwlock.writeLock().unlock();
    }

    String getAckInbox() {
        return this.ackInbox;
    }

    StreamingConnectionImpl getConnection() {
        return this.sc;
    }

    String getInbox() {
        return this.inbox;
    }

    MessageHandler getMessageHandler() {
        return this.cb;
    }

    @Override
    public String getQueue() {
        return this.qgroup;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public SubscriptionOptions getOptions() {
        return this.opts;
    }

    @Override
    public void close() throws IOException {
        if (this.sc == null) {
            return;
        }
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(boolean unsubscribe) throws IOException {
        Message reply;
        Connection nc;
        String reqSubject;
        StreamingConnectionImpl sc;
        this.wLock();
        try {
            sc = this.sc;
            if (sc == null) {
                throw new IllegalStateException("stan: invalid subscription");
            }
            sc.dispatcher.unsubscribe(this.inbox);
            this.sc = null;
        }
        finally {
            this.wUnlock();
        }
        sc.lock();
        try {
            if (sc.nc == null) {
                throw new IllegalStateException("stan: connection closed");
            }
            sc.subMap.remove(this.inbox);
            reqSubject = sc.unsubRequests;
            if (!unsubscribe && (reqSubject = sc.subCloseRequests).isEmpty()) {
                throw new IllegalStateException("stan: not supported by server");
            }
            nc = sc.getNatsConnection();
        }
        finally {
            sc.unlock();
        }
        UnsubscribeRequest usr = UnsubscribeRequest.newBuilder().setClientID(sc.getClientId()).setSubject(this.subject).setInbox(this.ackInbox).build();
        byte[] bytes = usr.toByteArray();
        try {
            CompletableFuture incoming = nc.request(reqSubject, bytes);
            reply = (Message)incoming.get(sc.opts.connectTimeout.toMillis(), TimeUnit.MILLISECONDS);
            if (reply == null) {
                if (unsubscribe) {
                    throw new IOException("stan: unsubscribe request timeout");
                }
                throw new IOException("stan: close request timeout");
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        SubscriptionResponse response = SubscriptionResponse.parseFrom(reply.getData());
        if (!response.getError().isEmpty()) {
            throw new IOException("stan: " + response.getError());
        }
    }

    @Override
    public void unsubscribe() throws IOException {
        this.close(true);
    }

    void setAckInbox(String ackInbox) {
        this.ackInbox = ackInbox;
    }
}

