/*
 * Decompiled with CFR 0.152.
 */
package io.nats.streaming;

import io.nats.client.Connection;
import io.nats.client.ConnectionListener;
import io.nats.client.ErrorListener;
import io.nats.streaming.Options;
import io.nats.streaming.StreamingConnection;
import io.nats.streaming.StreamingConnectionImpl;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.TimeUnit;

public class StreamingConnectionFactory {
    private Options.Builder options;

    public StreamingConnectionFactory() {
        this.options = new Options.Builder();
    }

    public StreamingConnectionFactory(String clusterId, String clientId) {
        this();
        this.options.clusterId(clusterId).clientId(clientId);
    }

    public StreamingConnectionFactory(Options options) {
        this.options = new Options.Builder(options);
    }

    public StreamingConnection createConnection() throws IOException, InterruptedException {
        StreamingConnectionImpl conn = new StreamingConnectionImpl(this.options());
        conn.connect();
        return conn;
    }

    public void setOptions(Options o) {
        this.options = new Options.Builder(o);
    }

    Options options() {
        return this.options.build();
    }

    public Duration getAckTimeout() {
        return this.options.getAckTimeout();
    }

    public void setAckTimeout(Duration ackTimeout) {
        this.options.pubAckWait(ackTimeout);
    }

    public void setAckTimeout(long ackTimeout, TimeUnit unit) {
        this.options.pubAckWait(Duration.ofMillis(unit.toMillis(ackTimeout)));
    }

    public Duration getConnectTimeout() {
        return this.options.getConnectTimeout();
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.options.connectWait(connectTimeout);
    }

    public void setConnectTimeout(long connectTimeout, TimeUnit unit) {
        this.options.connectWait(Duration.ofMillis(unit.toMillis(connectTimeout)));
    }

    public String getDiscoverPrefix() {
        return this.options.getDiscoverPrefix();
    }

    public void setDiscoverPrefix(String discoverPrefix) {
        this.options.discoverPrefix(discoverPrefix);
    }

    public int getMaxPubAcksInFlight() {
        return this.options.getMaxPubAcksInFlight();
    }

    public void setMaxPubAcksInFlight(int maxPubAcksInFlight) {
        this.options.maxPubAcksInFlight(maxPubAcksInFlight);
    }

    public String getNatsUrl() {
        return this.options.getNatsUrl();
    }

    public void setNatsUrl(String natsUrl) {
        this.options.natsUrl(natsUrl);
    }

    public Connection getNatsConnection() {
        return this.options.getNatsConn();
    }

    public void setNatsConnection(Connection natsConn) {
        this.options.natsConn(natsConn);
    }

    public String getClientId() {
        return this.options.getClientId();
    }

    public void setClientId(String clientId) {
        this.options.clientId(clientId);
    }

    public String getClusterId() {
        return this.options.getClusterID();
    }

    public void setClusterId(String clusterId) {
        this.options.clusterId(clusterId);
    }

    public ConnectionListener getConnectionListener() {
        return this.options.getConnectionListener();
    }

    public void setConnectionListener(ConnectionListener l) {
        this.options.connectionListener(l);
    }

    public ErrorListener getErrorListener() {
        return this.options.getErrorListener();
    }

    public void setErrorListener(ErrorListener l) {
        this.options.errorListener(l);
    }
}

