/*
 * Decompiled with CFR 0.152.
 */
package io.nats.client.support;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public abstract class Encoding {
    private Encoding() {
    }

    @Deprecated
    public static byte[] base64Encode(byte[] input) {
        return Base64.getUrlEncoder().withoutPadding().encode(input);
    }

    public static byte[] base64UrlEncode(byte[] input) {
        return Base64.getUrlEncoder().withoutPadding().encode(input);
    }

    public static String toBase64Url(byte[] input) {
        return new String(Encoding.base64UrlEncode(input));
    }

    public static String toBase64Url(String input) {
        return new String(Encoding.base64UrlEncode(input.getBytes(StandardCharsets.US_ASCII)));
    }

    public static byte[] base64UrlDecode(byte[] input) {
        return Base64.getUrlDecoder().decode(input);
    }

    public static String fromBase64Url(String input) {
        return new String(Encoding.base64UrlDecode(input.getBytes(StandardCharsets.US_ASCII)));
    }

    public static String jsonDecode(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        block9: for (int x = 0; x < len; ++x) {
            int ch = s.charAt(x);
            if (ch == 92) {
                int nextChar = x == len - 1 ? 92 : (int)s.charAt(x + 1);
                switch (nextChar) {
                    case 92: {
                        ch = 92;
                        break;
                    }
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                        break;
                    }
                    case 117: {
                        if (x >= len - 5) {
                            ch = 117;
                            break;
                        }
                        int code = Integer.parseInt("" + s.charAt(x + 2) + s.charAt(x + 3) + s.charAt(x + 4) + s.charAt(x + 5), 16);
                        sb.append(Character.toChars(code));
                        x += 5;
                        continue block9;
                    }
                    default: {
                        ch = nextChar;
                    }
                }
                ++x;
            }
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public static String jsonEncode(String s) {
        return Encoding.jsonEncode(new StringBuilder(), s).toString();
    }

    public static StringBuilder jsonEncode(StringBuilder sb, String s) {
        int len = s.length();
        block10: for (int x = 0; x < len; ++x) {
            char ch = s.charAt(x);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch < ' ') {
                        sb.append(String.format("\\u%04x", ch));
                        continue block10;
                    }
                    sb.append(ch);
                }
            }
        }
        return sb;
    }

    public static String uriDecode(String source) {
        try {
            return URLDecoder.decode(source.replace("+", "%2B"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return source;
        }
    }
}

